/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

class TangramPositionCoder {
    private static final int coordMax = 780;
    private static final int alphaMax = 360;

    public static String encodePosition(int[][] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + TangramPositionCoder.encodePiece(nArray[i]);
        }
        return string;
    }

    public static int[][] decodePosition(String string) {
        int n;
        if ((string = string.trim()).length() != 28) {
            System.err.println("TangramPositionCoder.java: ");
            System.err.println("Error: #code=" + string.length() + "!=28! (code='" + string + "')");
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n < 48) {
                return null;
            }
            if (n > 57 && n < 65) {
                return null;
            }
            if (n > 90 && n < 97) {
                return null;
            }
            if (n <= 122) continue;
            return null;
        }
        int[][] nArrayArray = new int[7][];
        for (n = 0; n < 7; ++n) {
            nArrayArray[n] = TangramPositionCoder.decodePiece(string.substring(4 * n, 4 * n + 4));
        }
        return nArrayArray;
    }

    private static String encodePiece(int[] nArray) {
        if (nArray[0] >= 780) {
            return null;
        }
        if (nArray[1] >= 780) {
            return null;
        }
        if (nArray[2] >= 360) {
            return null;
        }
        int n = nArray[2] / 15;
        int n2 = nArray[0] + nArray[1] * 780 + n * 780 * 780;
        return TangramPositionCoder.intToString(n2);
    }

    private static int[] decodePiece(String string) {
        int[] nArray = new int[3];
        int n = TangramPositionCoder.StringToInt(string);
        nArray[0] = n % 780;
        nArray[1] = (n /= 780) % 780;
        nArray[2] = 15 * (n /= 780);
        return nArray;
    }

    private static String intToString(int n) {
        String string = "";
        int n2 = n;
        string = string + TangramPositionCoder.intToChar(n2 % 62);
        string = string + TangramPositionCoder.intToChar((n2 /= 62) % 62);
        string = string + TangramPositionCoder.intToChar((n2 /= 62) % 62);
        string = string + TangramPositionCoder.intToChar((n2 /= 62) % 62);
        return string;
    }

    private static int StringToInt(String string) {
        int n = 0;
        n += TangramPositionCoder.charToInt(string.charAt(0));
        n += TangramPositionCoder.charToInt(string.charAt(1)) * 62;
        n += TangramPositionCoder.charToInt(string.charAt(2)) * 62 * 62;
        return n += TangramPositionCoder.charToInt(string.charAt(3)) * 62 * 62 * 62;
    }

    private static char intToChar(int n) {
        if (n < 10) {
            return (char)(n + 48);
        }
        if (n < 36) {
            return (char)(n - 10 + 65);
        }
        if (n < 62) {
            return (char)(n - 36 + 97);
        }
        return '\u0000';
    }

    private static int charToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 36;
        }
        return -1;
    }
}

