/*
 * Decompiled with CFR 0.152.
 */
package ihanoi;

import ihanoi.JanelaTexto;
import ihanoi.ResourceReader;
import ihanoi.iHanoi;
import ihanoi.iHanoiPanel;
import ihanoi.util.StaticMethods;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class TowersPanel
extends Panel
implements ActionListener {
    private static final int FT1 = 10;
    private static final int FT2 = 11;
    private static final int FT3 = 12;
    private static final int FT4 = 13;
    private static final int FT5 = 14;
    private static final Color corEarth = iHanoiPanel.corEarth;
    private static final Color corBaseHastes = iHanoiPanel.corBaseHastes;
    private static final Color corFundoHastes = iHanoiPanel.corFundoHastes;
    private static final Color corHaste = iHanoiPanel.corHaste;
    private static final int DimL = 27;
    private static final int DimD = 30;
    private static double TIME = 5000000.0;
    private static final int MAXDISCOS = 20;
    private static final int Nhastes = 3;
    private static final int DimX = 660;
    private static final int DimY = 400;
    private static final int largMov = 400;
    private static final int altMov = 520;
    public static final String FIRSTLINE = "# ihanoi: http://www.matematica.br!";
    private Graphics offgraphics;
    private Image offscreen = null;
    private static int MaxDiscos;
    public Color[] cor = null;
    private Button Ha;
    private Button Hb;
    private Button Hc;
    private iHanoi ihanoi;
    private iHanoiPanel ihanoiPanel;
    public int numberOfDiscs;
    private float evaluation = -1.0f;
    private boolean isExercise = false;
    private static int staticNumTowers;
    private int numTower = staticNumTowers++;
    private StickTower[] hastes = new StickTower[3];
    private Disco[] discos;
    public int De = -1;
    public int Para = -1;
    public int Nmovimentos = 0;
    public int Ndiscos;
    private Vector vectorOfMovements = new Vector();

    public void setIsExercise(boolean bl) {
        this.isExercise = bl;
    }

    public void setDiscs(int n) {
        this.numberOfDiscs = n;
        this.buildDiscColors(n);
    }

    public void buildDiscColors(int n) {
        if (n > 20) {
            String string = ResourceReader.read("limiteEstourado");
            System.out.println(string);
            n = 20;
        }
        MaxDiscos = n;
        this.discos = new Disco[MaxDiscos];
        this.cor = new Color[MaxDiscos];
    }

    public static int fromMove(Object object) {
        if (object instanceof Move) {
            return ((Move)object).de;
        }
        return -1;
    }

    public static int toMove(Object object) {
        if (object instanceof Move) {
            return ((Move)object).para;
        }
        return -1;
    }

    public void setTower(int n, int n2, int n3) {
        System.out.println("TowersPanel.setTower(" + n + "," + n2 + "," + n3 + "): #hastes=" + this.hastes.length);
        this.hastes[n].X = n2;
        this.hastes[n].Y = n3;
    }

    public void setDisc_X(int n, int n2) {
        this.discos[n].X = n2;
    }

    public void setDisc_Y(int n, int n2) {
        this.discos[n].Y = n2;
    }

    public void debugLista() {
        StickTower[] stickTowerArray = this.hastes;
        int n = stickTowerArray.length;
        System.out.println("TowersPanel.java: debugLista(): numStickTower=" + n);
        for (int i = 0; i < n; ++i) {
            StickTower stickTower = stickTowerArray[i];
            int n2 = stickTower.d.length;
            System.out.print(" #disco " + i + "=" + n2 + ": ");
            for (int j = 0; j < n2; ++j) {
                System.out.print(" " + stickTower.d[j] + ",");
            }
            System.out.println();
        }
    }

    public void redrawDiscs() {
        int n;
        for (n = 0; n < 3; ++n) {
            this.hastes[n] = new StickTower((n + 1) * 660 / 4, 270, n, this.numberOfDiscs);
        }
        int n2 = this.hastes[0].X - 3;
        int n3 = this.hastes[0].Y - 20 * (this.numberOfDiscs - 1) + 40;
        this.hastes[0].topo = this.numberOfDiscs - 1;
        for (n = 0; n < this.numberOfDiscs; ++n) {
            float f = (float)n / (float)this.numberOfDiscs;
            this.hastes[0].d[n] = this.numberOfDiscs - (n + 1);
            try {
                if (this.discos[n] == null) {
                    this.cor[n] = new Color(f, f, f);
                    this.discos[n] = new Disco(n, n2 - n * 10, n3 + 20 * n, (2 * n + 1) * 10 + 10, 20, this.cor[n]);
                    continue;
                }
                this.discos[n].X = n2 - n * 10;
                this.discos[n].Y = n3 + 20 * n;
                this.discos[n].dimX = (2 * n + 1) * 10 + 10;
                this.discos[n].dimY = 20;
                this.discos[n].C = new Color(f, f, f);
                continue;
            }
            catch (Exception exception) {
                String string = this.discos != null ? " #discos=" + this.discos.length : " #discos=0";
                System.err.println("TowersPanel.java: redrawDiscs: i=" + n + ", discos:" + string);
                exception.printStackTrace();
            }
        }
    }

    public void updateDiscs(int n) {
        this.numberOfDiscs = n;
        this.Ndiscos = n;
        this.updateDiscs();
    }

    public void updateDiscs() {
        this.Nmovimentos = 0;
        this.redrawDiscs();
        int n = this.hastes[0].X - 3;
        int n2 = this.hastes[0].Y - 20 * (this.numberOfDiscs - 1) + 40;
        for (int i = 0; i < this.numberOfDiscs; ++i) {
            float f = (float)i / (float)this.numberOfDiscs;
            this.hastes[0].d[i] = this.numberOfDiscs - (i + 1);
            this.discos[i].X = n - i * 10;
            this.discos[i].Y = n2 + 20 * i;
        }
        this.hastes[0].topo = this.numberOfDiscs - 1;
        this.hastes[1].topo = -1;
        this.hastes[2].topo = -1;
        this.repaint();
    }

    public void pinta() {
        Graphics graphics = null;
        if (this.offscreen != null) {
            graphics = this.offscreen.getGraphics();
            if (graphics != null) {
                this.offgraphics = graphics;
            }
            this.update(graphics);
        } else {
            this.update(this.offgraphics);
        }
    }

    public final void paint(Graphics graphics) {
        this.pinta();
    }

    public void update(Graphics graphics) {
        String string;
        int n;
        int n2 = 5;
        int n3 = 15;
        int n4 = 100;
        if (this.offscreen == null) {
            this.offscreen = this.createImage(660, 400);
            this.offgraphics = this.offscreen.getGraphics();
        }
        graphics = this.offscreen.getGraphics();
        graphics.setColor(corFundoHastes);
        graphics.fill3DRect(n2, n4 / 4, 660 - n2, 400 - n4, true);
        graphics.setColor(corEarth);
        graphics.fill3DRect(n2, 303, 660 - n2, 20, true);
        graphics.setColor(corHaste);
        boolean bl = false;
        for (n = 0; n < 3; ++n) {
            try {
                graphics.fill3DRect(this.hastes[n].X, 30, n3, this.hastes[n].Y, true);
                continue;
            }
            catch (Exception exception) {
                string = this.hastes != null ? "" + this.hastes.length : "";
                System.err.println("TowersPanel.update(Graphics): i=" + n + ", #TowersPanel=" + this.numTower + ", hastes=" + this.hastes + ", #hastes=" + string + ": " + exception);
            }
        }
        for (n = 0; n < this.numberOfDiscs; ++n) {
            try {
                graphics.setColor(this.discos[n].C);
                graphics.fill3DRect(this.discos[n].X, this.discos[n].Y - 40, this.discos[n].dimX, this.discos[n].dimY, true);
                continue;
            }
            catch (Exception exception) {
                string = this.discos != null ? "" + this.discos.length : "";
                System.err.println("TowersPanel.update(Graphics): i=" + n + ", #discos=" + string + ": " + exception);
                if (bl) continue;
                exception.printStackTrace();
                bl = true;
            }
        }
        graphics = this.getGraphics();
        graphics.drawImage(this.offscreen, 0, 0, this);
    }

    public void setVectorOfMovements(Vector vector) {
        this.vectorOfMovements = vector;
    }

    public int getSizeVectorOfMovements() {
        return this.vectorOfMovements.size();
    }

    public void addElementVectorOfMovements(Vector vector, int n, int n2) {
        Move move = new Move(n, n2);
        vector.addElement(move);
    }

    public void addElementVectorOfMovements(Object object) {
        if (object instanceof Move) {
            Move move = (Move)object;
            this.vectorOfMovements.addElement(move);
        }
    }

    public TowersPanel() {
        int n = 165;
        int n2 = 330;
        this.setLayout(null);
        this.discos = new Disco[MaxDiscos];
        this.cor = new Color[MaxDiscos];
        this.Ha = new Button("A");
        this.Ha.setSize(150, 27);
        this.Ha.setLocation(n - 60 - 10, n2 - 40);
        this.Ha.setBackground(corBaseHastes);
        this.Hb = new Button("B");
        this.Hb.setSize(150, 27);
        this.Hb.setLocation(2 * n - 60 - 10, n2 - 40);
        this.Hb.setBackground(corBaseHastes);
        this.Hc = new Button("C");
        this.Hc.setSize(150, 27);
        this.Hc.setLocation(3 * n - 60 - 10, n2 - 40);
        this.Hc.setBackground(corBaseHastes);
        this.Ha.setFont(new Font("Helvetica", 1, 12));
        this.Hb.setFont(new Font("Helvetica", 1, 12));
        this.Hc.setFont(new Font("Helvetica", 1, 12));
        this.Ha.addActionListener(this);
        this.Hb.addActionListener(this);
        this.Hc.addActionListener(this);
        this.add(this.Ha);
        this.add(this.Hb);
        this.add(this.Hc);
        this.setSize(660, 400);
    }

    public static long pot(int n, int n2) {
        long l = 1L;
        for (int i = 0; i < n2; ++i) {
            l *= (long)n;
        }
        return l;
    }

    public void moveAutomatico(int n, int n2, int n3, int n4) {
        if (n == 0 || n2 == -1 || n3 == -1) {
            return;
        }
        this.moveAutomatico(n - 1, n2, n4, n3);
        this.acertaOrigemDestino(-1, -1, " ", " ");
        this.moveDisco("" + n2, n2, n3, this.topo(n3), this.topo(n2));
        this.retardo();
        this.moveAutomatico(n - 1, n4, n3, n2);
    }

    public void reverTodosOsMovimentos() {
        Vector vector = new Vector();
        String string = "";
        int n = -2;
        int n2 = -2;
        int n3 = -2;
        int n4 = -2;
        if (this.Nmovimentos == 0) {
            this.Nmovimentos = this.vectorOfMovements.size();
        }
        string = ResourceReader.read("movTitulo") + "\n" + ResourceReader.read("movSubTitulo") + "\n" + ResourceReader.read("movMovimentos") + ": " + this.Nmovimentos + "\n" + StaticMethods.dadosUsuario() + "\n";
        this.Ha.setEnabled(false);
        this.Hb.setEnabled(false);
        this.Hc.setEnabled(false);
        try {
            int n5;
            int n6 = this.vectorOfMovements.size();
            for (n5 = 0; n5 < n6; ++n5) {
                vector.addElement(this.vectorOfMovements.elementAt(n5));
            }
            this.ihanoiPanel.updateDiscs(false, false);
            this.pinta();
            this.vectorOfMovements = new Vector();
            System.out.println("Review: number of movements=" + n6);
            for (n5 = 0; n5 < n6; ++n5) {
                this.retardo();
                Object e = vector.elementAt(n5);
                Move move = (Move)e;
                n = move.de;
                n2 = move.para;
                String string2 = TowersPanel.haste(n);
                String string3 = TowersPanel.haste(n2);
                string = string + n5 + ": " + string2 + " -> " + string3 + "\n";
                n3 = this.hastes[n2].topo;
                n4 = this.hastes[n].topo;
                this.moveDisco(string2, n, n2, n3, n4);
                this.pinta();
            }
        }
        catch (Exception exception) {
            System.err.println("iHanoi: error during the review of used movements:\n (from,to)=(" + n + "," + n2 + ") (t1,t2)=(" + n3 + "," + n4 + "): " + exception);
            exception.printStackTrace();
        }
        JanelaTexto janelaTexto = new JanelaTexto(this.ihanoiPanel, 400, 520, string);
        ((Component)janelaTexto).setVisible(true);
        this.Ha.setEnabled(true);
        this.Hb.setEnabled(true);
        this.Hc.setEnabled(true);
    }

    public void desfazUltimoMovimento() {
        int n = -1;
        int n2 = this.hastes.length;
        try {
            int n3 = this.vectorOfMovements.size();
            if (n3 < 1) {
                this.ihanoiPanel.setTextTmsg(ResourceReader.read("moveErrDesfazVazio"));
                return;
            }
            Object e = this.vectorOfMovements.elementAt(n3 - 1);
            this.vectorOfMovements.removeElementAt(n3 - 1);
            --this.Nmovimentos;
            this.ihanoiPanel.setTextTmov(String.valueOf(this.Nmovimentos));
            this.acertaOrigemDestino(-1, -1, " ", " ");
            Move move = (Move)e;
            int n4 = move.de;
            int n5 = move.para;
            int n6 = this.hastes[n4].topo;
            int n7 = this.hastes[n5].topo;
            try {
                this.hastes[n4].d[++n6] = this.hastes[n5].d[n7];
                this.hastes[n5].d[n7] = -1;
            }
            catch (Exception exception) {
                System.err.println("iHanoi: erro ao tentar listar movimentos (" + n + "):\n " + "(de,para)=(" + n5 + "," + n4 + ") (t1,t2)=(" + n6 + "," + n7 + "): " + exception);
                exception.printStackTrace();
            }
            ++this.hastes[n4].topo;
            --this.hastes[n5].topo;
            int n8 = this.hastes[n4].d[n6];
            this.discos[n8].X = this.hastes[n4].X - this.discos[n8].N * 10 - 2;
            this.discos[n8].Y = this.hastes[n4].Y - 20 * n6 + 40;
            this.repaint();
        }
        catch (Exception exception) {
            System.err.println("iHanoi: erro ao tentar listar movimentos (" + n + "): " + exception);
            exception.printStackTrace();
        }
    }

    private static char getTower(int n) {
        switch (n) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'B';
            }
            case 2: {
                return 'C';
            }
        }
        return ' ';
    }

    public String getMovements() {
        String string = FIRSTLINE;
        int n = this.vectorOfMovements.size();
        if (n == 0) {
            System.err.println("Error: there is no disc movements!");
            return null;
        }
        String string2 = "";
        if (this.isExercise) {
            long l = TowersPanel.pot(2, this.numberOfDiscs) - 1L;
            if (this.hastes[0].topo == -1) {
                if (this.hastes[1].topo == -1) {
                    this.evaluation = (float)l / (float)this.Nmovimentos;
                    string2 = "1: 0==-1 e 1==-1";
                } else if (this.hastes[2].topo == -1) {
                    this.evaluation = (float)l / (float)(2 * this.Nmovimentos);
                    string2 = "2: 0==-1 e 2==-1";
                } else {
                    this.evaluation = 0.0f;
                    string2 = "3: 0==-1 e 2!=-1";
                }
            } else {
                this.evaluation = 0.0f;
                string2 = "4: 0!=-1";
            }
            string2 = string2 + ", evaluation=" + this.evaluation + ", minimumMov=" + l + "=" + TowersPanel.pot(2, this.numberOfDiscs) + "-" + 1;
            this.ihanoi.setEvaluation(this.numberOfDiscs, n, this.evaluation);
        }
        if (this.Ndiscos == 0) {
            this.Ndiscos = this.numberOfDiscs;
        }
        string = string + "\nDiscs: " + this.Ndiscos + "\nSize: " + n + "\nMovements:";
        for (int i = 0; i < n; ++i) {
            Move move = (Move)this.vectorOfMovements.elementAt(i);
            int n2 = move.de;
            int n3 = move.para;
            string = string + "\n" + TowersPanel.getTower(n2) + " " + TowersPanel.getTower(n3) + " ;";
        }
        return string;
    }

    public void setTowerPanel(int n, iHanoi iHanoi2, iHanoiPanel iHanoiPanel2) {
        this.numberOfDiscs = n;
        this.ihanoiPanel = iHanoiPanel2;
        this.ihanoi = iHanoi2;
        if (MaxDiscos == 0) {
            MaxDiscos = n;
        }
    }

    public int setMovements(String string) {
        Vector vector = new Vector();
        String string2 = "";
        this.setDiscs(this.Ndiscos);
        if (this.isExercise) {
            this.ihanoiPanel.setEnabledChoice(true);
        } else {
            this.ihanoiPanel.setEnabledChoice(false);
        }
        this.ihanoiPanel.updateDiscs(true, false);
        if (!this.isExercise) {
            this.ihanoiPanel.brever_setEnabled(true);
            this.ihanoiPanel.setEnabledNotExercise();
            System.out.println("Loaded: #movements=" + this.getSizeVectorOfMovements());
        } else {
            this.ihanoiPanel.setEnabledExercise();
            System.out.println("Loaded: it is exercise");
        }
        return 1;
    }

    public void acertaOrigemDestino(int n, int n2, String string, String string2) {
        this.De = n;
        this.Para = n2;
        if (n >= 0) {
            if (n2 < 0 && this.hastes[n].topo < 0) {
                this.Para = -1;
                this.De = -1;
                this.ihanoiPanel.setTextFrom(" ");
                this.ihanoiPanel.setTextTo(" ");
                this.ihanoiPanel.setTextTmsg(ResourceReader.read("moveHasteVazia"));
                return;
            }
        } else if (n == n2) {
            this.Para = -1;
            this.De = -1;
            this.ihanoiPanel.setTextFrom(" ");
            this.ihanoiPanel.setTextTo(" ");
            if (n != -1) {
                this.ihanoiPanel.setTextTmsg(ResourceReader.read("moveMesmaHaste"));
            }
            return;
        }
        if (string != null) {
            this.ihanoiPanel.setTextFrom(string);
        }
        if (string2 != null) {
            this.ihanoiPanel.setTextTo(string2);
        }
    }

    public int topo(int n) {
        int n2;
        int n3 = this.hastes == null ? -1 : this.hastes.length;
        int n4 = n2 = n3 > n ? this.hastes[n].topo : -1;
        if (n3 < 0) {
            System.err.println("Erro: haste " + n + " com erro: " + n3 + " e " + n2);
        }
        return n2;
    }

    private String verifyTopTowers(int n, int n2, int n3, int n4) {
        String string = null;
        if (n == n2) {
            string = ResourceReader.read("ihpErrSameTower");
        } else if (this.hastes[n].d[n3] == -1) {
            string = ResourceReader.read("ihpErrEmptyTower");
        } else if (n4 > -1 && this.hastes[n].d[n3] > this.hastes[n2].d[n4]) {
            string = ResourceReader.read("ihpErrGreaterOver");
        }
        return string;
    }

    public void moveDisco(String string, int n, int n2, int n3, int n4) {
        String string2 = null;
        try {
            this.ihanoiPanel.setTextTo(string);
            string2 = n4 < 0 ? "Invalid negative: topTo=" + n3 + ", topFrom=" + n4 : this.verifyTopTowers(n, n2, n4, n3);
            if (string2 == null) {
                this.hastes[n2].d[++n3] = this.hastes[n].d[n4];
                this.hastes[n].d[n4] = -1;
                ++this.hastes[n2].topo;
                --this.hastes[n].topo;
                int n5 = this.hastes[n2].d[n3];
                this.discos[n5].X = this.hastes[n2].X - this.discos[n5].N * 10 - 2;
                this.discos[n5].Y = this.hastes[n2].Y - 20 * n3 + 40;
                ++this.Nmovimentos;
                this.ihanoiPanel.setTextTmov(String.valueOf(this.Nmovimentos));
                Move move = new Move(n, n2);
                this.vectorOfMovements.addElement(move);
                this.pinta();
            } else {
                String string3 = n4 > -1 ? "disc " + this.hastes[n].d[n4] : "topFrom=" + n4;
                String string4 = n3 > -1 ? "disc " + this.hastes[n].d[n3] : "topTo=" + n3;
                System.err.println("Error: invalid movement! Ignored from=" + n + " to=" + n2 + ": " + string3 + " -> " + string4 + "");
                System.err.println(string2);
                this.ihanoiPanel.setTextTmsg(string2);
            }
        }
        catch (Exception exception) {
            int n6 = this.hastes == null ? 0 : this.hastes.length;
            int n7 = n6 > n ? this.hastes[n].d.length : -1;
            int n8 = n6 > n2 ? this.hastes[n2].d.length : -1;
            String string5 = " - #hastes=" + n6 + ", #hastes[" + n + "].d=" + n7 + ", #hastes[" + n2 + "].d=" + n8;
            System.err.println("TowersPanel.moveDisco(...): error trying to register the movement " + n + "->" + n2 + " (" + n3 + "," + n4 + "): " + string5 + "\n: " + exception);
            exception.printStackTrace();
        }
        this.De = -1;
        this.Para = -1;
    }

    private static String haste(int n) {
        if (n == 0) {
            return "A";
        }
        if (n == 1) {
            return "B";
        }
        return "C";
    }

    private void retardo() {
        double d = 1.0;
        int n = 0;
        while ((double)n < TIME) {
            d += Math.sin(2.0) + Math.cos(3.0);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals("A")) {
            if (this.De == -1) {
                this.acertaOrigemDestino(0, -1, "A", " ");
                return;
            }
            int n = this.hastes[0].topo;
            int n2 = this.hastes[this.De].topo;
            this.Para = 0;
            if (this.De == this.Para) {
                this.acertaOrigemDestino(-1, -1, " ", " ");
                return;
            }
            if (n > -1 && n2 > -1) {
                if (this.hastes[0].d[n] != -1 && this.hastes[0].d[n] < this.hastes[this.De].d[n2]) {
                    this.ihanoiPanel.setTextTmsg(ResourceReader.read("moveMaiorSobreMenor") + this.hastes[this.De].d[n2] + "->" + this.hastes[0].d[n]);
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    return;
                }
            } else if (n2 == -1) {
                this.acertaOrigemDestino(-1, -1, " ", " ");
                return;
            }
            this.moveDisco("A", this.De, 0, n, n2);
            return;
        }
        if (string.equals("B")) {
            if (this.De == -1) {
                this.acertaOrigemDestino(1, -1, "B", " ");
                return;
            }
            int n = this.hastes[1].topo;
            int n3 = this.hastes[this.De].topo;
            this.Para = 1;
            if (this.De == this.Para) {
                this.acertaOrigemDestino(-1, -1, " ", " ");
                return;
            }
            if (n > -1 && n3 > -1) {
                if (this.hastes[1].d[n] != -1 && this.hastes[1].d[n] < this.hastes[this.De].d[n3]) {
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    this.ihanoiPanel.setTextTmsg(ResourceReader.read("moveMaiorSobreMenor"));
                    return;
                }
            } else if (n3 == -1) {
                this.acertaOrigemDestino(-1, -1, " ", " ");
                return;
            }
            this.moveDisco("B", this.De, 1, n, n3);
            if (this.hastes[1].topo == this.Ndiscos - 1) {
                long l = TowersPanel.pot(2, this.Ndiscos) - 1L;
                if ((long)this.Nmovimentos == l) {
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    String[] stringArray = new String[]{"" + this.Ndiscos, "" + this.Nmovimentos};
                    this.ihanoiPanel.setTextTmsg(ResourceReader.readVar("moveFimParabensMas", "N", stringArray));
                } else {
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    String[] stringArray = new String[]{"" + this.Nmovimentos};
                    this.ihanoiPanel.setTextTmsg(ResourceReader.readVar("moveFimExcessoMas", "N", stringArray));
                }
                this.ihanoiPanel.brever_setEnabled(true);
            }
            return;
        }
        if (string.equals("C")) {
            if (this.De == -1) {
                this.acertaOrigemDestino(2, this.Para, "C", " ");
                return;
            }
            int n = this.hastes[2].topo;
            int n4 = this.hastes[this.De].topo;
            this.Para = 2;
            if (this.De == this.Para) {
                this.acertaOrigemDestino(-1, -1, " ", " ");
                return;
            }
            if (n > -1 && n4 > -1) {
                if (this.hastes[2].d[n] != -1 && this.hastes[2].d[n] < this.hastes[this.De].d[n4]) {
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    this.ihanoiPanel.setTextTmsg(ResourceReader.read("moveMaiorSobreMenor"));
                    return;
                }
            } else if (n4 == -1) {
                this.acertaOrigemDestino(-1, -1, " ", " ");
                return;
            }
            this.moveDisco("C", this.De, 2, n, n4);
            if (this.hastes[2].topo == this.Ndiscos - 1) {
                long l = TowersPanel.pot(2, this.Ndiscos) - 1L;
                if ((long)this.Nmovimentos == l) {
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    String[] stringArray = new String[]{"" + this.Ndiscos, "" + this.Nmovimentos};
                    this.ihanoiPanel.setTextTmsg(ResourceReader.readVar("moveFimParabens", "N", stringArray));
                } else {
                    this.acertaOrigemDestino(-1, -1, " ", " ");
                    String[] stringArray = new String[]{"" + this.Nmovimentos, "" + this.Ndiscos};
                    this.ihanoiPanel.setTextTmsg(ResourceReader.readVar("moveFimExcesso", "N", stringArray));
                }
                this.ihanoiPanel.brever_setEnabled(true);
            }
            return;
        }
    }

    static {
        staticNumTowers = 0;
    }

    protected class Move {
        public int de;
        public int para;

        public int from() {
            return this.de;
        }

        public int to() {
            return this.para;
        }

        public Move(int n, int n2) {
            this.de = n;
            this.para = n2;
        }
    }

    protected class Disco {
        public int X;
        public int Y;
        public int dimX;
        public int dimY;
        public int N;
        public Color C;

        public Disco(int n, int n2, int n3, int n4, int n5, Color color) {
            this.N = n;
            this.X = n2;
            this.Y = n3;
            this.dimX = n4;
            this.dimY = n5;
            this.C = color;
        }
    }

    protected class StickTower {
        protected int X;
        protected int Y;
        protected int N;
        protected int topo;
        protected int[] d;

        protected StickTower(int n, int n2, int n3, int n4) {
            this.d = new int[n4];
            this.topo = -1;
            for (int i = 0; i < n4; ++i) {
                this.d[i] = -1;
            }
            this.X = n;
            this.Y = n2;
            this.N = n3;
        }
    }
}

