/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloJanelasAuxiliares.controle.JanelaHistoricoController;
import igraf.moduloJanelasAuxiliares.eventos.JanelaHistoricoEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class JanelaHistorico
extends JFrame
implements MouseListener,
LanguageUpdatable {
    public static final String IGCLASSPATH = "src/igraf/moduloJanelasAuxiliares/visao/JanelaHistorico.java";
    private static HashMap hashMapButtons = null;
    private JPanel mainJPanel;
    private JButton stepFront;
    private JButton stepBack;
    private JButton forward;
    private JButton backward;
    private JTextArea windowHistTextArea = new JTextArea();
    private static final Color COLOR_BG_WINDOW = EsquemaVisual.corAreaDesenho;
    private static final Color COLOR_FG_WINDOW = EsquemaVisual.corLetrasBotoes;
    private static final Color COLOR_BG_BUTTONS = EsquemaVisual.corFundoBotoes;
    private static final Color COLOR_DISABLED_BUTTON = EsquemaVisual.corDesFundoBotoes;
    private boolean isVisible;
    private JanelaHistoricoController jhc;

    public JanelaHistorico(JanelaHistoricoController janelaHistoricoController) {
        super("iGraf - " + ResourceReader.msg("titleWinHistSession"));
        this.setBackground(COLOR_BG_WINDOW);
        this.jhc = janelaHistoricoController;
        this.mainJPanel = new JPanel(new BorderLayout());
        this.createButtons();
        this.setFont(EsquemaVisual.fontHB12);
        this.windowHistTextArea.setSize(390, 85);
        this.windowHistTextArea.setLocation(5, 35);
        this.windowHistTextArea.setEditable(false);
        this.windowHistTextArea.setBackground(EsquemaVisual.corAreaDesenho);
        this.mainJPanel.add(this.windowHistTextArea);
        this.getContentPane().add(this.mainJPanel);
        this.insereControles();
        this.closer();
        this.pack();
        this.setVisible(true);
    }

    private void createButtons() {
        this.stepFront = new JButton(" > ");
        this.stepBack = new JButton(" < ");
        this.forward = new JButton(" >> ");
        this.backward = new JButton(" << ");
        this.stepFront.setToolTipText(ResourceReader.msg("toolTipHSstepFront"));
        this.stepBack.setToolTipText(ResourceReader.msg("toolTipHSstepBack"));
        this.forward.setToolTipText(ResourceReader.msg("toolTipHSforward"));
        this.backward.setToolTipText(ResourceReader.msg("toolTipHSbackward"));
        this.setDisabledButton(this.stepBack);
        hashMapButtons = new HashMap();
        hashMapButtons.put("stepFront", this.stepFront);
        hashMapButtons.put("stepBack", this.stepBack);
        hashMapButtons.put("forward", this.forward);
        hashMapButtons.put("backward", this.backward);
    }

    public void visibilidade() {
        if (!this.isVisible) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.isVisible = !this.isVisible;
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 275);
    }

    private void insertJButton(JPanel jPanel, JButton jButton) {
        jButton.setBackground(COLOR_BG_BUTTONS);
        jButton.setForeground(COLOR_FG_WINDOW);
        jButton.setOpaque(true);
        jButton.addMouseListener(this);
        jPanel.add(jButton);
    }

    private void insereControles() {
        JPanel jPanel = new JPanel(new GridLayout(1, 4, 2, 0));
        jPanel.setBorder(LineBorder.createGrayLineBorder());
        this.insertJButton(jPanel, this.backward);
        this.insertJButton(jPanel, this.stepBack);
        this.insertJButton(jPanel, this.stepFront);
        this.insertJButton(jPanel, this.forward);
        this.mainJPanel.add("South", jPanel);
    }

    private void closer() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JanelaHistorico.this.restabeleceSessao();
                JanelaHistorico.this.setVisible(false);
                JanelaHistorico.this.dispose();
            }
        });
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        if (!jButton.isEnabled()) {
            return;
        }
        if (jButton == this.stepFront) {
            this.jhc.enviarEvento(new JanelaHistoricoEvent(this, "step redraw"));
            this.setEnabledButtons(false);
        } else if (jButton == this.stepBack) {
            this.setEnabledButtons(true);
        } else if (jButton == this.forward) {
            this.restabeleceSessao();
            this.setEnabledButtons(false);
            this.setDisabledButtons(true);
        } else if (jButton == this.backward) {
            this.historico();
            this.setEnabledButtons(true);
            this.setDisabledButtons(false);
        }
    }

    private void restabeleceSessao() {
        this.jhc.enviarEvento(new JanelaHistoricoEvent(this, "redraw all"));
    }

    public void historico() {
        this.windowHistTextArea.setText("");
        this.jhc.iniciaHistorico();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        if (jButton.isEnabled()) {
            jButton.setBackground(COLOR_FG_WINDOW);
            jButton.setForeground(COLOR_BG_BUTTONS);
        } else {
            jButton.setBackground(COLOR_DISABLED_BUTTON);
            jButton.setForeground(COLOR_BG_BUTTONS);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        if (jButton.isEnabled()) {
            jButton.setBackground(COLOR_BG_BUTTONS);
            jButton.setForeground(COLOR_FG_WINDOW);
        } else {
            jButton.setBackground(COLOR_DISABLED_BUTTON);
            jButton.setForeground(COLOR_BG_BUTTONS);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setNextStep(String string) {
        this.windowHistTextArea.append(string + "\n");
        if (string != null && string.trim().equals(ResourceReader.msg("FIM"))) {
            this.setDisabledButtons(true);
        }
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.stepFront.setEnabled(true);
            this.stepFront.setBackground(COLOR_BG_BUTTONS);
            this.stepFront.setForeground(COLOR_FG_WINDOW);
            this.forward.setEnabled(true);
            this.forward.setBackground(COLOR_BG_BUTTONS);
            this.forward.setForeground(COLOR_FG_WINDOW);
        } else {
            this.backward.setEnabled(true);
            this.backward.setBackground(COLOR_BG_BUTTONS);
            this.backward.setForeground(COLOR_FG_WINDOW);
        }
    }

    public void setDisabledButtons(boolean bl) {
        if (bl) {
            this.stepFront.setEnabled(false);
            this.forward.setEnabled(false);
            this.stepFront.setBackground(COLOR_DISABLED_BUTTON);
            this.forward.setBackground(COLOR_DISABLED_BUTTON);
        } else {
            this.stepBack.setEnabled(false);
            this.backward.setEnabled(false);
            this.stepBack.setBackground(COLOR_DISABLED_BUTTON);
            this.backward.setBackground(COLOR_DISABLED_BUTTON);
        }
    }

    public void setDisabledButton(JButton jButton) {
        jButton.setEnabled(false);
        jButton.setBackground(COLOR_DISABLED_BUTTON);
    }

    public void updateLabels() {
        this.setTitle(ResourceReader.msg("titleWinHistSession"));
        this.stepFront.setToolTipText(ResourceReader.msg("toolTipHSstepFront"));
        this.stepBack.setToolTipText(ResourceReader.msg("toolTipHSstepBack"));
        this.forward.setToolTipText(ResourceReader.msg("toolTipHSforward"));
        this.backward.setToolTipText(ResourceReader.msg("toolTipHSbackward"));
    }
}

