/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.controle;

import difusor.CommunicationFacade;
import difusor.evento.CommunicationEvent;
import igraf.basico.event.ChangeLanguageEvent;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Utilitarios;
import igraf.moduloCentral.eventos.GraphPlotterEvent;
import igraf.moduloCentral.eventos.GraphicOnScreenChangedEvent;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.desenho.DesenhoFuncao;
import igraf.moduloCentral.visao.plotter.GraphPlotter;
import igraf.moduloJanelasAuxiliares.controle.JanelaController;
import igraf.moduloJanelasAuxiliares.eventos.EdicaoExpressaoEvent;
import igraf.moduloJanelasAuxiliares.visao.JanelaEdicaoExpressao;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import moduloColor.ColorChangeListener;
import moduloColor.ColorEvent;

public class JanelaEdicaoExpressaoController
extends JanelaController
implements KeyListener,
ActionListener,
ItemListener,
ColorChangeListener {
    private String funcaoOriginal;
    private String funcaoAtual;
    private String novaFuncao;
    private Color corAtual;
    private Color corOriginal;
    private JanelaEdicaoExpressao jee;
    private boolean sendEvent;

    public JanelaEdicaoExpressaoController(CommunicationFacade communicationFacade, boolean bl) {
        super(communicationFacade, bl);
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        super.tratarEventoRecebido(communicationEvent);
        if (communicationEvent instanceof ChangeLanguageEvent) {
            if (this.jee != null) {
                this.jee.updateLabels();
            }
        } else if (communicationEvent instanceof GraphicOnScreenChangedEvent && this.jee != null) {
            try {
                this.atualizaChoices();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = 0;
        if (communicationEvent instanceof GraphPlotterEvent && communicationEvent.getCommand().equals(ResourceReader.msg("msgMenuGrfEditaExp"))) {
            this.exibeJanelaEdicao();
            String string = ((GraphPlotter)communicationEvent.getSource()).getExpressaoSobCursor();
            n = this.getExprIndex(string);
            this.iniciaEdicao(n);
            return;
        }
        if (communicationEvent.getCommand().equals(ResourceReader.msg("msgMenuGrfEditaExp"))) {
            this.exibeJanelaEdicao();
            this.iniciaEdicao(n);
        }
    }

    private void exibeJanelaEdicao() {
        this.jee = new JanelaEdicaoExpressao(this);
        this.atualizaChoices();
        this.jee.setVisible(true);
    }

    private void atualizaChoices() {
        this.sendEvent = false;
        this.jee.setFunctionList(this.getListaDesenho());
        this.sendEvent = true;
    }

    private int getExprIndex(String string) {
        if (string == null) {
            return 0;
        }
        for (int i = 0; i < this.listaDesenho.size(); ++i) {
            DesenhoFuncao desenhoFuncao = (DesenhoFuncao)this.listaDesenho.get(i);
            if (!desenhoFuncao.getDescricao().equals(string)) continue;
            this.jee.setFunctionIndex(i);
            return i;
        }
        return 0;
    }

    private void iniciaEdicao(int n) {
        DesenhoFuncao desenhoFuncao = (DesenhoFuncao)this.listaDesenho.get(n);
        String string = Utilitarios.retiraEspacos(((Desenho)desenhoFuncao).getFuncaoAtual());
        this.setChoiceCores(n);
        this.corAtual = desenhoFuncao.getColor();
        this.funcaoOriginal = string;
        this.funcaoAtual = string;
        this.jee.setText(string);
    }

    private void setChoiceCores(int n) {
        Color color;
        this.sendEvent = false;
        DesenhoFuncao desenhoFuncao = (DesenhoFuncao)this.listaDesenho.get(n);
        this.corOriginal = color = desenhoFuncao.getColor();
        this.jee.setColorIndex(Desenho.getColorIndex(this.corOriginal));
        this.sendEvent = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
        String string = Utilitarios.retiraEspacos(this.jee.getText());
        if (!this.funcaoAtual.equals(string) && Analisa.sintaxeCorreta(string)) {
            this.novaFuncao = string;
            this.atualizaPlotter();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ResourceReader.msg("msgCancelar"))) {
            this.novaFuncao = this.funcaoOriginal;
            this.corAtual = this.corOriginal;
            this.atualizaPlotter();
        }
        this.jee.setVisible(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (!jComboBox.isShowing()) {
            return;
        }
        if (jComboBox.getName().equals("colorComboBox")) {
            try {
                this.mudaCor(Desenho.getColor(this.jee.getColorIndex()));
            }
            catch (Exception exception) {}
        } else if (jComboBox.getName().equals("functionComboBox")) {
            this.iniciaEdicao(jComboBox.getSelectedIndex());
        }
    }

    public void mudaCor(Color color) {
        if (color != null) {
            this.novaFuncao = this.funcaoAtual;
            this.corAtual = color;
            this.atualizaPlotter();
        }
    }

    private void atualizaPlotter() {
        if (this.sendEvent) {
            this.enviarEvento(new EdicaoExpressaoEvent(this));
            this.funcaoAtual = this.novaFuncao;
        }
    }

    public String getFuncaoOriginal() {
        return this.funcaoOriginal;
    }

    public String getFuncaoAtual() {
        return this.funcaoAtual;
    }

    public String getNovaFuncao() {
        return this.novaFuncao;
    }

    public void setColor(Color color) {
        this.corAtual = color;
    }

    public Color getColor() {
        return this.corAtual;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void updateColor(ColorEvent colorEvent) {
        this.mudaCor(colorEvent.getColor());
    }
}

