/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao;

import igraf.moduloExercicio.visao.JanelaExercicio;
import igraf.moduloExercicio.visao.PainelBasico;
import igraf.moduloExercicio.visao.PainelResposta;
import igraf.moduloExercicio.visao.PainelRespostaAlgebrica;
import igraf.moduloExercicio.visao.PainelRespostaIntervalo;
import igraf.moduloExercicio.visao.PainelRespostaNumerica;
import igraf.moduloExercicio.visao.PainelRespostaPonto;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;

public class PainelListaResposta
extends PainelBasico {
    private Vector listaResposta;
    private Vector listaRespostaAluno;
    private int altura = 0;
    private final int alturaLinha = 40;
    private static int totalAcertos = 0;
    private int totalErros = 0;
    private int numberOfAnswerType1 = 0;
    private int numberOfAnswerType2 = 0;
    private int numberOfAnswerType3 = 0;
    private int numberOfAnswerType4 = 0;
    private int numberOfAnswerType5 = 0;

    public PainelListaResposta(JanelaExercicio janelaExercicio) {
        this.janelaExercicio = janelaExercicio;
        this.setLayout(new GridLayout(0, 1, 0, 2));
        this.listaResposta = new Vector();
    }

    public void addToNumberOfAnswers(int n) {
        switch (n) {
            case 1: {
                ++this.numberOfAnswerType1;
                break;
            }
            case 2: {
                ++this.numberOfAnswerType2;
                break;
            }
            case 3: {
                ++this.numberOfAnswerType3;
                break;
            }
            case 4: {
                ++this.numberOfAnswerType4;
                break;
            }
            case 5: {
                ++this.numberOfAnswerType5;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(630, this.getAltura());
    }

    private void atualizaAltura(int n) {
        if (Math.abs(n) != 1) {
            throw new IllegalArgumentException("Valor n\u00e3o permitido para atualizar altura de painel");
        }
        this.altura += 40 * n;
    }

    public int getAltura() {
        return this.listaResposta.size() * 40;
    }

    public void alteraPainelResposta(int n) {
        if (n == 5) {
            this.removePainelResposta();
            this.atualizaAltura(-1);
            return;
        }
        this.inserePainelResposta(n);
    }

    private void removePainelResposta() {
        try {
            this.listaResposta.removeElementAt(this.listaResposta.size() - 1);
            this.remove(this.getComponentCount() - 1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void inserePainelResposta(int n) {
        PainelResposta painelResposta = null;
        switch (n) {
            case 1: {
                painelResposta = new PainelRespostaNumerica(this.janelaExercicio, this.listaResposta.size() + 1);
                break;
            }
            case 2: {
                painelResposta = new PainelRespostaPonto(this.janelaExercicio, this.listaResposta.size() + 1);
                break;
            }
            case 3: {
                painelResposta = new PainelRespostaIntervalo(this.janelaExercicio, this.listaResposta.size() + 1);
                break;
            }
            case 4: {
                painelResposta = new PainelRespostaAlgebrica(this.janelaExercicio, this.listaResposta.size() + 1);
            }
        }
        this.insereEntradaResposta(painelResposta);
    }

    public void inserePainelResposta(PainelResposta painelResposta) {
        this.insereEntradaResposta(painelResposta);
    }

    private void insereEntradaResposta(PainelResposta painelResposta) {
        this.listaResposta.addElement(painelResposta);
        this.add(painelResposta);
        this.atualizaAltura(1);
    }

    public Vector getListaResposta() {
        return this.listaResposta;
    }

    public boolean dadosValidos() {
        for (int i = 0; i < this.listaResposta.size(); ++i) {
            PainelResposta painelResposta = (PainelResposta)this.listaResposta.elementAt(i);
            boolean bl = painelResposta.validar();
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String responder() {
        this.totalErros = 0;
        totalAcertos = 0;
        PainelResposta painelResposta = null;
        this.listaRespostaAluno = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.listaResposta.size(); ++i) {
            painelResposta = (PainelResposta)this.listaResposta.elementAt(i);
            painelResposta.reset();
            painelResposta.resetDiagnostico();
            painelResposta.comparaResposta();
            stringBuffer.append(painelResposta.getDiagnostico() + "\r\n");
            this.totalErros += painelResposta.getNumErros();
            totalAcertos += painelResposta.getNumAcertos();
            this.addRespostaTentativa(painelResposta.getValorResposta(), painelResposta.correcao());
        }
        return stringBuffer.toString();
    }

    private void addRespostaTentativa(String string, String string2) {
        this.listaRespostaAluno.add(string + ";" + string2);
    }

    public Vector getListaRespostaAluno() {
        return this.listaRespostaAluno;
    }

    public int getTotalErros() {
        return this.totalErros;
    }

    public int getTotalAcertos() {
        return totalAcertos;
    }

    public void limparCampos() {
        for (int i = 0; i < this.listaResposta.size(); ++i) {
            ((PainelResposta)this.listaResposta.elementAt(i)).limparCampos();
        }
    }

    public void setLimits(int n, int n2) {
        Object var3_3 = null;
        for (int i = 0; i < this.listaResposta.size(); ++i) {
            var3_3 = this.listaResposta.get(i);
        }
        if (var3_3 instanceof PainelRespostaAlgebrica) {
            PainelRespostaAlgebrica painelRespostaAlgebrica = var3_3;
            painelRespostaAlgebrica.setLimits(n, n2);
        }
    }

    public void reset() {
        this.listaResposta = new Vector();
        this.removeAll();
    }

    public void setChoiceItens(Vector vector) {
        Object var2_2 = null;
        for (int i = 0; i < this.listaResposta.size(); ++i) {
            if (!(this.listaResposta.elementAt(i) instanceof PainelRespostaAlgebrica)) continue;
            ((PainelRespostaAlgebrica)this.listaResposta.elementAt(i)).setChoiceItens(vector);
        }
    }

    public void updateLabels() {
        PainelResposta painelResposta = null;
        for (int i = 0; i < this.listaResposta.size(); ++i) {
            painelResposta = (PainelResposta)this.listaResposta.elementAt(i);
            painelResposta.updateLabels();
        }
    }
}

