/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloExercicio.controle.JanelaExercicioController;
import igraf.moduloExercicio.visao.PainelComentario;
import igraf.moduloExercicio.visao.PainelListaResposta;
import igraf.moduloExercicio.visao.PainelSeletorTipoResposta;
import igraf.moduloInferior.visao.InfoPane;
import igraf.moduloSuperior.visao.PainelBotoes;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JanelaExercicio
extends JDialog
implements ActionListener,
LanguageUpdatable {
    public static final int ENVIO = 0;
    public static final int CRIACAO = 1;
    public static final int ALT = 300;
    public static final int LARG = 570;
    private JPanel buttonsPanel;
    private JPanel southPanel;
    private PainelListaResposta jePainelListaResposta = null;
    private PainelListaResposta jePainelListaRespostaOld = null;
    private PainelSeletorTipoResposta jePainelSeletorTipoResposta = null;
    private PainelSeletorTipoResposta jePainelSeletorTipoRespostaOld = null;
    private PainelComentario jePainelComentario;
    private PainelBotoes painelBotoes;
    private InfoPane infoPane;
    private JButton buttonCancel = JanelaExercicio.createButton("exercFQRcancel", "exercFQRcancelTooltip");
    private JButton buttonClear = JanelaExercicio.createButton("exercFQRLimpa", "exercFQRLimpaTooltip");
    private JButton buttonEvaluate = JanelaExercicio.createButton("exercFQRCGabarito", "exercFQRCGabaritoTooltip");
    private int altura;
    private static int modo;
    private static boolean respAluno;
    private JanelaExercicioController janelaExercicioController = null;

    public void setPainelBotoes(PainelBotoes painelBotoes) {
        this.painelBotoes = painelBotoes;
    }

    protected void setMessage(String string) {
        this.infoPane.setStatusBarMessage(string);
    }

    private static JButton createButton(String string, String string2) {
        JButton jButton = new JButton(ResourceReader.msg(string));
        jButton.setToolTipText(ResourceReader.msg(string2));
        return jButton;
    }

    public static int getModo() {
        return modo;
    }

    public static boolean getRespAluno() {
        return respAluno;
    }

    public static void setRespAluno(boolean bl) {
        respAluno = bl;
    }

    public JanelaExercicio(JanelaExercicioController janelaExercicioController, PainelBotoes painelBotoes, InfoPane infoPane) {
        super((Frame)new JFrame(), false);
        this.janelaExercicioController = janelaExercicioController;
        this.painelBotoes = painelBotoes;
        this.infoPane = infoPane;
        System.out.println("src/igraf/moduloExercicio/visao/JanelaExercicio.java: painelBotoes=" + this.painelBotoes + " infoPane=" + this.infoPane);
        respAluno = true;
        this.jePainelListaResposta = new PainelListaResposta(this);
        this.jePainelComentario = new PainelComentario(this);
        this.jePainelSeletorTipoResposta = new PainelSeletorTipoResposta(janelaExercicioController);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.southPanel = new JPanel(new BorderLayout());
        jPanel.add("North", this.jePainelComentario);
        jPanel.add("South", this.jePainelSeletorTipoResposta);
        this.buttonsPanel = this.configuraBotoes(janelaExercicioController);
        this.southPanel.add("North", this.jePainelListaResposta);
        this.southPanel.add("South", this.buttonsPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JanelaExercicio.this.fechaJanela();
            }
        });
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("South", this.southPanel);
        this.pack();
    }

    public void setMode(int n) {
        modo = n;
        if (n == 0) {
            this.setTitle("iGraf - " + ResourceReader.msg("exercFQRPRAluno"));
        } else {
            this.setTitle("iGraf - " + ResourceReader.msg("exercFQRPCGabarito"));
            this.buttonEvaluate.setLabel(ResourceReader.msg("exercFQRCGabarito"));
        }
        this.jePainelComentario.setMode(n);
        this.jePainelSeletorTipoResposta.setMode(n);
    }

    private JPanel configuraBotoes(JanelaExercicioController janelaExercicioController) {
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.buttonCancel.addActionListener(this);
        this.buttonClear.addActionListener(this);
        this.buttonEvaluate.addActionListener(janelaExercicioController);
        this.buttonCancel.setBackground(EsquemaVisual.corFundoBotao);
        this.buttonClear.setBackground(EsquemaVisual.corFundoBotao);
        this.buttonEvaluate.setBackground(EsquemaVisual.corFundoBotao);
        this.buttonCancel.setForeground(EsquemaVisual.corLetraBotao);
        this.buttonClear.setForeground(EsquemaVisual.corLetraBotao);
        this.buttonEvaluate.setForeground(EsquemaVisual.corLetraBotao);
        jPanel.add(this.buttonCancel);
        jPanel.add(this.buttonClear);
        jPanel.add(this.buttonEvaluate);
        return jPanel;
    }

    public void alteraPainelResposta(int n) {
        this.jePainelListaResposta.alteraPainelResposta(n);
        this.pack();
    }

    public void creatNewExercise() {
        if (this.jePainelListaRespostaOld != null) {
            this.jePainelListaRespostaOld = this.jePainelListaResposta;
            this.jePainelListaResposta = new PainelListaResposta(this);
            this.jePainelSeletorTipoRespostaOld = this.jePainelSeletorTipoResposta;
            this.jePainelSeletorTipoResposta = new PainelSeletorTipoResposta(this.janelaExercicioController);
            this.southPanel.remove(this.jePainelListaRespostaOld);
            this.southPanel.add("North", this.jePainelListaResposta);
            this.pack();
        }
    }

    public void cancel() {
        this.setVisible(false);
        respAluno = false;
    }

    public void fechaJanela() {
        if (this.jePainelListaRespostaOld != null) {
            PainelListaResposta painelListaResposta = this.jePainelListaResposta;
            PainelSeletorTipoResposta painelSeletorTipoResposta = this.jePainelSeletorTipoResposta;
            this.jePainelListaResposta = this.jePainelListaRespostaOld;
            this.jePainelListaRespostaOld = painelListaResposta;
            this.jePainelSeletorTipoResposta = this.jePainelSeletorTipoRespostaOld;
            this.jePainelSeletorTipoRespostaOld = painelSeletorTipoResposta;
        } else {
            this.jePainelListaRespostaOld = this.jePainelListaResposta;
            this.jePainelSeletorTipoRespostaOld = this.jePainelSeletorTipoResposta;
        }
        if (this.jePainelListaResposta != null) {
            this.painelBotoes.setEnabledMenuItem("menuExerc", "mexExercEditar", true);
        }
        this.setVisible(false);
        respAluno = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonCancel) {
            this.cancel();
        } else if (object == this.buttonClear) {
            this.jePainelListaResposta.limparCampos();
        }
    }

    public PainelListaResposta getPainelListaResposta() {
        return this.jePainelListaResposta;
    }

    public void reset() {
        this.jePainelSeletorTipoResposta.reset();
        this.atualizarDimensoes();
    }

    public void atualizarDimensoes() {
        this.validate();
        this.pack();
    }

    public String getComentario() {
        return this.jePainelComentario.getComentario();
    }

    public PainelComentario getPainelComentario() {
        return this.jePainelComentario;
    }

    public void updateLabels() {
        this.buttonCancel.setLabel(ResourceReader.msg("msgCancelar"));
        this.buttonClear.setLabel(ResourceReader.msg("exercFQRLimpa"));
        this.buttonEvaluate.setLabel(ResourceReader.msg("exercFQRCGabarito"));
        this.buttonCancel.setToolTipText(ResourceReader.msg("exercFQRcancelTooltip"));
        this.buttonClear.setToolTipText(ResourceReader.msg("exercFQRLimpaTooltip"));
        this.buttonEvaluate.setToolTipText(ResourceReader.msg("exercFQRCGabaritoTooltip"));
        this.jePainelComentario.updateLabels();
        this.jePainelSeletorTipoResposta.updateLabels();
        this.jePainelListaResposta.updateLabels();
    }

    static {
        respAluno = false;
    }
}

