/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.menu;

import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.eventos.menu.IgrafSubMenuEvent;
import igraf.moduloCentral.visao.menu.IgrafMenu;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Timer;
import javax.swing.JLabel;

public class IgrafMenuItem
extends JLabel {
    public static final int MOUSE_CLICKED = 1;
    public static final int MOUSE_ENTERED = 2;
    public static final int MOUSE_EXITED = 3;
    private static final int VAR_X = 8;
    private static final int LIM_X = -1;
    private static final int LIM_Y_MIN = -1;
    private static final int LIM_Y_MAX = 20;
    private String description;
    private static final Color cinzaMedio = new Color(210, 210, 210);
    private boolean useTimer;
    private Timer timer;
    private IgrafMenu im;
    private boolean hasSubMenu = false;

    public IgrafMenuItem(String string, String string2, boolean bl) {
        this(string, string2);
    }

    public IgrafMenuItem(String string, String string2) {
        super(string);
        this.description = string2;
        this.setToolTipText(string2);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.description == null) {
            this.insereSeparador(graphics);
        }
    }

    private void insereSeparador(Graphics graphics) {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        graphics.setColor(Color.black);
        graphics.drawLine(2, n / 2, n2 - 3, n / 2);
        graphics.setColor(Color.gray);
        graphics.drawLine(2, n / 2, n2 - 3, n / 2);
        graphics.setColor(cinzaMedio);
        graphics.drawLine(2, n / 2, n2 - 3, n / 2);
    }

    private void textoAlternativo() {
        if (this.getText() == null) {
            return;
        }
        if (this.getText().equals(ResourceReader.msg("madEixosRemover"))) {
            this.setText(ResourceReader.msg("madEixosExibir"));
        } else if (this.getText().equals(ResourceReader.msg("madEixosExibir"))) {
            this.setText(ResourceReader.msg("madEixosRemover"));
        }
        if (this.getText().equals(ResourceReader.msg("madEscalaRemover"))) {
            this.setText(ResourceReader.msg("madEscalaExibir"));
        } else if (this.getText().equals(ResourceReader.msg("madEscalaExibir"))) {
            this.setText(ResourceReader.msg("madEscalaRemover"));
        }
        if (this.getText().equals(ResourceReader.msg("madGradeRemover"))) {
            this.setText(ResourceReader.msg("madGradeExibir"));
        } else if (this.getText().equals(ResourceReader.msg("madGradeExibir"))) {
            this.setText(ResourceReader.msg("madGradeRemover"));
        } else if (this.getText().equals(ResourceReader.msg("mepPintaPoli"))) {
            this.setText(ResourceReader.msg("mepNPintaPoli"));
        } else if (this.getText().equals(ResourceReader.msg("mepNPintaPoli"))) {
            this.setText(ResourceReader.msg("mepPintaPoli"));
        }
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    private IgrafMenu getContainer() {
        return (IgrafMenu)this.getParent();
    }

    private void corNormal() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
    }

    public void setSubMenu(IgrafMenu igrafMenu) {
        this.hasSubMenu = true;
        this.im = igrafMenu;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.description != null) {
            this.setBackground(Color.blue);
            this.setForeground(Color.white);
            this.getContainer().disparaEvento(2, this.getDescription());
        }
        if (this.hasSubMenu) {
            IgrafMenu igrafMenu = this.getContainer();
            int n = igrafMenu.getX() + igrafMenu.getWidth() - 8;
            igrafMenu.disparaEventoSubMenu(new IgrafSubMenuEvent(this, 2, this.im.toString(), n));
        }
    }
}

