/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.StringTokenizer;
import java.util.Vector;

public class DesenhoPoligono
extends Desenho {
    protected Polygon p;
    private double[] px;
    private double[] py;
    private int x;
    private int y;
    private int polygonType;
    private int vertexMode = 0;
    protected String vertices;
    private boolean preencher = false;
    private int destak = -1;
    private Color c;
    Color fillColor = Color.magenta;
    private int r = 6;

    public DesenhoPoligono(Plotter plotter, String string, int n, boolean bl, int n2) {
        super(plotter, n);
        this.ok = this.defineVertices(string);
        this.preencher = bl;
        this.vertexMode = n2;
    }

    public DesenhoPoligono(Plotter plotter, String string, int n, int n2) {
        super(plotter, n);
        this.ok = this.defineVertices(string);
        this.polygonType = n2;
    }

    public DesenhoPoligono(Plotter plotter, String string, String string2, String string3, int n, int n2, int n3) {
        super(plotter, 0);
        this.ok = this.defineVertices(string);
        this.polygonType = n;
        this.preencher = n2 > 0;
        this.fillColor = this.getColor(string2);
        this.vertexMode = n3;
    }

    public DesenhoPoligono(DesenhoPoligono desenhoPoligono) {
        this(desenhoPoligono.plotter, desenhoPoligono.toString(), desenhoPoligono.getFillColorToStringRGB(), desenhoPoligono.getLineColorToStringRGB(), desenhoPoligono.getPolygonType(), desenhoPoligono.isFilledPolygon() ? 1 : 0, 0);
    }

    protected boolean defineVertices(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string2 = string.substring(1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "(,) ", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() % 2 != 0) {
            return false;
        }
        this.p = new Polygon();
        int n2 = vector.size() / 2;
        this.px = new double[n2];
        this.py = new double[n2];
        for (n = 0; n < vector.size(); ++n) {
            String string3 = (String)vector.elementAt(n);
            double d = Double.valueOf(string3);
            if (n % 2 == 0) {
                this.px[n / 2] = this.vertexMode == 0 ? d : (double)Math.round(d);
                continue;
            }
            this.py[n / 2] = this.vertexMode == 0 ? d : (double)Math.round(d);
        }
        for (n = 0; n < this.px.length; ++n) {
            this.x = (int)(this.px[n] * (double)this.getEscala());
            this.y = (int)(this.py[n] * (double)this.getEscala() * -1.0);
            this.p.addPoint(this.x, this.y);
        }
        if (this.p.npoints > 2) {
            this.x = (int)(this.px[0] * (double)this.getEscala());
            this.y = (int)(this.py[0] * (double)this.getEscala() * -1.0);
            this.p.addPoint(this.x, this.y);
        }
        this.vertices = string;
        return true;
    }

    public boolean editaGrafico(String string, Color color) {
        this.setColor(color);
        if (string.equals(this.vertices)) {
            return false;
        }
        return this.defineVertices(string);
    }

    public void atualizaDesenho(Graphics2D graphics2D) {
        this.defineVertices(this.vertices);
        if (this.polygonToBeDrawn.npoints == 1) {
            this.desenhaPonto(graphics2D);
        } else {
            if (this.preencher) {
                this.preencher(graphics2D);
            }
            this.renderiza(this.polygonToBeDrawn, graphics2D);
            int n = this.polygonToBeDrawn.npoints;
            int n2 = n - (n > 2 ? 1 : 0);
            for (int i = 0; i < n2; ++i) {
                this.desenhaPonto(graphics2D, this.polygonToBeDrawn.xpoints[i], this.polygonToBeDrawn.ypoints[i], i);
            }
        }
    }

    protected void desenhaPonto(Graphics graphics) {
        this.desenhaPonto(graphics, this.x, this.y, 0);
    }

    protected void desenhaPonto(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.destak != n3 ? 5 : 7;
        int n5 = this.destak != n3 ? -1 : -2;
        int n6 = this.destak != n3 ? -6 : -7;
        this.c = graphics.getColor();
        graphics.setColor(this.destak != n3 ? Color.green : Color.yellow);
        graphics.fillOval(this.plotter.normalizaX(n - 1) + n5, this.plotter.normalizaY(-n2 - 4) + n6, n4, n4);
        graphics.setColor(Color.black);
        graphics.drawOval(this.plotter.normalizaX(n - 1) + n5, this.plotter.normalizaY(-n2 - 4) + n6, n4, n4);
        graphics.setColor(this.c);
    }

    public Polygon getPolygon() {
        return this.p;
    }

    public int getPolygonType() {
        return this.polygonType;
    }

    public String toString() {
        return this.vertices;
    }

    public String getFuncaoAtual() {
        return ResourceReader.msg("POLIGONO") + " " + this.vertices;
    }

    public void insereVertice(float f, float f2) {
        int n = this.vertices.length() - 1;
        this.vertices = this.vertices.substring(0, n) + "(" + f + "," + f2 + ")]";
    }

    public void changeVertex(float f, float f2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.vertices, "(");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string = stringTokenizer.nextToken();
        stringBuffer.append(string);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (n++ == this.destak) {
                string = f + ", " + f2 + ")";
            }
            stringBuffer.append("(" + string);
        }
        this.vertices = stringBuffer.toString();
    }

    private void preencher(Graphics graphics) {
        Polygon polygon = this.normaliza(this.p);
        graphics.setColor(this.fillColor);
        graphics.fillPolygon(polygon);
    }

    private Polygon normaliza(Polygon polygon) {
        Polygon polygon2 = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        for (int i = 0; i < polygon.npoints; ++i) {
            polygon2.xpoints[i] = this.plotter.normalizaX(polygon.xpoints[i]) + 1;
            polygon2.ypoints[i] = this.plotter.normalizaY(-polygon.ypoints[i] - 1);
        }
        return polygon2;
    }

    public boolean mouseOverVertex(float f, float f2) {
        for (int i = 0; i < this.p.npoints - (this.p.npoints > 2 ? 1 : 0); ++i) {
            if (this.p.xpoints[i] < (int)(f * (float)this.getEscala() + (float)this.r) && this.p.xpoints[i] > (int)(f * (float)this.getEscala() - (float)this.r) && this.p.ypoints[i] < (int)(-f2 * (float)this.getEscala() + (float)this.r) && this.p.ypoints[i] > (int)(-f2 * (float)this.getEscala() - (float)this.r)) {
                this.destak = i;
                return true;
            }
            this.destak = -1;
        }
        return false;
    }

    public String getLineColorToStringRGB() {
        return this.getColorToStringRGB(Color.blue);
    }

    public String getFillColorToStringRGB() {
        return this.getColorToStringRGB(Color.magenta);
    }

    public boolean isFilledPolygon() {
        return this.preencher;
    }
}

