/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao;

import igraf.IGraf;
import igraf.basico.io.ImageFromIGraf;
import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.Arquivo;
import igraf.moduloCentral.ModuloCentral;
import igraf.moduloCentral.controle.AreaDesenhoController;
import igraf.moduloCentral.visao.AreaDesenho;
import igraf.moduloInferior.ModuloInferior;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTabbedPane;

public class TabbedViewer
extends JTabbedPane
implements MouseListener {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/TabbedViewer.java";
    private static int tabIndex = 0;
    private int numAba = 0;
    private int indiceControlador = 0;
    ModuloCentral mc;
    private Vector listaControlador = new Vector();
    private int sliderHeight = 0;
    private AreaDesenhoController areaDesenhoController;
    private AreaDesenhoController areaDesenhoControllerOld;
    private AreaDesenhoController areaDesenhoControllerAux;
    private AreaDesenho areaDesenho;
    private ModuloInferior moduloInferior;

    public TabbedViewer(ModuloCentral moduloCentral, ModuloInferior moduloInferior) {
        this.mc = moduloCentral;
        this.moduloInferior = moduloInferior;
        this.setTabPlacement(3);
        this.addMouseListener(this);
        this.setOpaque(true);
        this.setForeground(Color.black);
        this.setBackground(Color.gray);
        this.criaAba(false);
    }

    public void makeSliderRoom() {
        this.sliderHeight = 25;
        this.fixBounds();
    }

    public void resetDimensions() {
        this.sliderHeight = 0;
        this.fixBounds();
    }

    public void setTabbedViewerBounds(Rectangle rectangle) {
        this.fixBounds();
    }

    private void fixBounds() {
        int n = IGraf.ehApplet ? 0 : 140;
    }

    public void criaAba(boolean bl) {
        this.areaDesenhoControllerAux = new AreaDesenhoController(this.mc, true, this.numAba);
        this.listaControlador.add(this.areaDesenhoControllerAux);
        AreaDesenho areaDesenho = this.areaDesenho;
        this.areaDesenho = new AreaDesenho(this.areaDesenhoControllerAux, this.moduloInferior);
        this.areaDesenho.addMouseMotionListener(this.mc.pcc);
        int n = this.numAba++;
        String[] stringArray = new String[]{this.numAba + ""};
        this.addTab(ResourceReader.msg("msgTab") + this.numAba, this.areaDesenho);
        this.setToolTipTextAt(n, ResourceReader.msgComVar("msgTabTip", "OBJ", stringArray));
        this.setSelectedIndex(this.numAba - 1);
        this.indiceControlador = this.getSelectedIndex();
        if (bl) {
            this.changeControlTab(true, this.indiceControlador);
        } else {
            int n2 = this.getTabCount() - 1;
            if (n2 > 0) {
                this.areaDesenhoController.setActive(false);
                this.mc.removeInternEventListener(this.areaDesenhoController);
            }
            this.areaDesenhoController = this.areaDesenhoControllerAux;
            this.areaDesenhoController.notificaTrocaAba();
            if (areaDesenho != null) {
                areaDesenho.stopAnimation();
            }
            tabIndex = n2;
        }
    }

    private void changeControlTab(boolean bl, int n) {
        if (tabIndex == n) {
            return;
        }
        if (this.areaDesenhoController != null) {
            this.areaDesenhoController.setActive(false);
            this.mc.removeInternEventListener(this.areaDesenhoController);
        } else {
            String string = "changeControlTab(" + n + "): areaDesenhoController=null";
            System.err.println("\nigraf/moduloCentral/visao/TabbedViewer.java: DEBUG!! Attention: the controller 'areaDesenhoController' is not supposed to be NULL in 'changeControlTab(boolean,int)'!");
            System.out.println(" " + string);
            Arquivo.addLogError("TabbedViewer.java", string);
        }
        this.areaDesenhoController = (AreaDesenhoController)this.listaControlador.get(n);
        this.areaDesenhoController.setActive(true);
        this.areaDesenhoController.notificaTrocaAba();
        if (bl) {
            this.areaDesenho.stopAnimation();
            this.mc.addInternEventListener(this.areaDesenhoController);
            this.areaDesenho = this.areaDesenhoController.getAreaDesenho();
            this.areaDesenho.startAnimation();
        }
        tabIndex = n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.indiceControlador = this.getSelectedIndex();
        this.changeControlTab(true, this.indiceControlador);
    }

    public void nextTab() {
        int n = this.getTabCount() - 1;
        this.changeControlTab(true, n);
        this.setSelectedIndex(n);
    }

    public static int getTabIndex() {
        return tabIndex;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void removeAba() {
        if (this.getTabCount() > 1) {
            this.remove(this.indiceControlador);
            if (this.indiceControlador > 0) {
                this.changeControlTab(true, this.indiceControlador - 1);
            }
        }
    }

    public void resetTabs() {
        this.indiceControlador = this.getTabCount() - 1;
        while (this.indiceControlador > 0) {
            this.removeAba();
            --this.indiceControlador;
        }
        this.changeControlTab(true, 0);
    }

    public void copiarImagem() {
        ImageFromIGraf.copiarImagem(this.getSelectedComponent());
    }

    public void exportarJPG() {
        ImageFromIGraf.salvarComoJPEG(this.getSelectedComponent());
    }

    public void updateLabels() {
        int n = this.getTabCount();
        String[] stringArray = new String[1];
        for (int i = 0; i < n; ++i) {
            stringArray[0] = i + 1 + "";
            this.setTitleAt(i, ResourceReader.msg("msgTab") + (i + 1));
            this.setToolTipTextAt(i, ResourceReader.msgComVar("msgTabTip", "OBJ", stringArray));
        }
    }
}

