/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao;

import igraf.moduloCentral.controle.AreaDesenhoController;
import igraf.moduloCentral.visao.plotter.AxesPlotter;
import igraf.moduloCentral.visao.plotter.GraphPlotter;
import igraf.moduloCentral.visao.plotter.PolygonPlotter;
import igraf.moduloInferior.ModuloInferior;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class AreaDesenho
extends JComponent
implements Runnable {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/AreaDesenho.java";
    private static int count = 0;
    private int ID = count++;
    private BufferedImage axesImage;
    private BufferedImage graphImage;
    private Graphics2D axesBuffer;
    private Graphics2D graphBuffer;
    public PolygonPlotter polygonPlotter = new PolygonPlotter();
    public AxesPlotter eixos = new AxesPlotter();
    public GraphPlotter graphPlotter;
    private ModuloInferior moduloInferior;
    private int widthADD;
    private int heightADD;
    private boolean deixarRastro;
    private boolean animando = false;
    private Thread threadToAnimation = null;
    private Cursor cursorSelected = new Cursor(1);
    private Cursor cursorDefault = new Cursor(0);
    static int tt = 0;
    private boolean suspended = false;

    public int getID() {
        return this.ID;
    }

    public AreaDesenho(AreaDesenhoController areaDesenhoController, ModuloInferior moduloInferior) {
        this.moduloInferior = moduloInferior;
        this.graphPlotter = new GraphPlotter(this, moduloInferior);
        this.addKeyListener(this.eixos);
        this.addMouseListener(this.eixos);
        this.addMouseMotionListener(this.eixos);
        this.addKeyListener(this.graphPlotter);
        this.addMouseListener(this.graphPlotter);
        this.addMouseMotionListener(this.graphPlotter);
        this.addKeyListener(this.polygonPlotter);
        this.addMouseListener(this.polygonPlotter);
        this.addMouseMotionListener(this.polygonPlotter);
        this.polygonPlotter.setController(areaDesenhoController);
        this.graphPlotter.setController(areaDesenhoController);
        this.eixos.setController(areaDesenhoController);
        areaDesenhoController.setControlledObject(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    AreaDesenho.this.defaultCursor();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AreaDesenho.this.defaultCursor();
                }
            }
        });
    }

    private void setAxesBuffer(int n, int n2) {
        if (this.axesImage == null || this.axesImage.getWidth() != n || this.axesImage.getHeight() != n2 || this.eixos.axesChanged()) {
            this.axesImage = this.getGraphicsConfiguration().createCompatibleImage(n, n2, 2);
            this.axesBuffer = this.axesImage.createGraphics();
            this.eixos.axesFixed();
        }
        this.eixos.desenha(this.axesBuffer, n, n2);
    }

    private void setGraphBuffer(int n, int n2) {
        if (!this.deixarRastro) {
            this.graphImage = this.getGraphicsConfiguration().createCompatibleImage(n, n2, 2);
            this.graphBuffer = this.graphImage.createGraphics();
        }
        this.graphPlotter.desenha(this.graphBuffer, n, n2);
    }

    private void setBuffer(int n, int n2) {
        this.polygonPlotter.setDrawingArea(this.getGraphicsConfiguration().createCompatibleImage(n, n2, 2), n, n2);
    }

    public void repaint() {
        super.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.widthADD = this.getBounds().width;
        this.heightADD = this.getBounds().height;
        this.setAxesBuffer(this.widthADD, this.heightADD);
        this.setGraphBuffer(this.widthADD, this.heightADD);
        this.setBuffer(this.widthADD, this.heightADD);
        graphics2D.drawImage((Image)this.axesImage, 0, 0, null);
        graphics2D.drawImage((Image)this.graphImage, 0, 0, null);
        graphics2D.drawImage((Image)this.polygonPlotter.getImage(), 0, 0, null);
    }

    public void mudaEstadoRastro() {
        this.deixarRastro = !this.deixarRastro;
    }

    public void stopAnimation() {
        if (this.animando) {
            this.suspended = true;
        }
    }

    public void startAnimation() {
        if (this.animando) {
            this.suspended = false;
            this.animar(true);
        }
    }

    public void run() {
        while (this.animando) {
            try {
                if (this.suspended) break;
                Thread.sleep(120L);
                this.repaint();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void animar(boolean bl) {
        this.animando = bl;
        if (bl) {
            try {
                this.threadToAnimation = new Thread(this);
                this.threadToAnimation.start();
            }
            catch (Exception exception) {}
        } else {
            try {
                this.threadToAnimation.suspend();
                this.threadToAnimation = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean animando() {
        System.err.println("igraf/moduloCentral/visao/AreaDesenho.java: animando(): return " + this.animando + "");
        return this.animando;
    }

    public void atualizaDesenho() {
        if (!this.animando) {
            this.repaint(0L);
        }
    }

    private void clearScreen(Graphics2D graphics2D) {
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics2D.setPaint(Color.black);
    }

    public void limpaRastro() {
        if (this.animando) {
            this.clearScreen(this.graphBuffer);
        }
    }

    public void changeCursor() {
        this.requestFocus();
        this.setCursor(this.cursorSelected);
    }

    public void defaultCursor() {
        this.setCursor(this.cursorDefault);
    }
}

