/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloArquivo.modelo;

import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.Arquivo;
import igraf.moduloArquivo.controle.ArquivoController;
import igraf.moduloArquivo.eventos.IgrafMenuArquivoEvent;
import igraf.moduloCentral.eventos.DesenhoTextoEvent;
import igraf.moduloCentral.eventos.EstadoTelaEvent;
import igraf.moduloCentral.eventos.ResetEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuCalculoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuEdicaoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuGraficoEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuPoligonoEvent;
import igraf.moduloCentral.modelo.Acao;
import igraf.moduloCentral.modelo.Sessao;
import igraf.moduloExercicio.eventos.DiagnosticEvent;
import igraf.moduloExercicio.eventos.RespostaAlgebricaEvent;
import igraf.moduloExercicio.eventos.RespostaDiscursivaEvent;
import igraf.moduloExercicio.eventos.RespostaIntervaloEvent;
import igraf.moduloExercicio.eventos.RespostaNumericaEvent;
import igraf.moduloExercicio.eventos.RespostaPontoEvent;
import igraf.moduloExercicio.visao.menuSelector.DisableMenuEvent;
import igraf.moduloJanelasAuxiliares.eventos.EdicaoExpressaoEvent;
import igraf.moduloJanelasAuxiliares.eventos.JanelaIntegralEvent;
import igraf.moduloJanelasAuxiliares.eventos.JanelaTangenteEvent;
import igraf.moduloSuperior.eventos.EntradaExpressaoEvent;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class ArquivoModel {
    public static final String IGCLASSPATH = "igraf/moduloArquivo/modelo/ArquivoModel.java";
    private Sessao sessao;
    private int tamanhoSessao = 0;
    private int numLinha = 0;
    private int ultimaLinha;
    private boolean sessionChanged = false;
    private Vector listaSessao = new Vector();
    private Vector listaAcao;
    private ArquivoController controller;
    private static boolean onePrint = false;
    private boolean carregando;
    private boolean anotouExercicio;
    private Vector vetSessao;
    private Vector vetorRespostas;
    private Vector vetSessaoCripto;
    private Vector vetSessaoCriptoIndice;

    public void setController(ArquivoController arquivoController) {
        this.controller = arquivoController;
    }

    public void insereSessao(Sessao sessao) {
        int n = this.listaSessao.size();
        this.sessionChanged = sessao.getListaAcao().size() > 0;
        for (int i = 0; i < n; ++i) {
            this.sessao = (Sessao)this.listaSessao.get(i);
            if (this.sessao.getTabIndex() != sessao.getTabIndex()) continue;
            this.listaSessao.setElementAt(sessao, i);
            return;
        }
        this.listaSessao.add(sessao);
        this.sessao = sessao;
    }

    public void sessionChanged(boolean bl) {
        this.sessionChanged = bl;
    }

    public boolean sessionChanged() {
        return this.sessionChanged;
    }

    public String getListaSessaoAsString() {
        int n = this.listaSessao.size();
        Collections.sort(this.listaSessao);
        String string = Arquivo.cabecalho();
        for (int i = 0; i < n; ++i) {
            this.sessao = (Sessao)this.listaSessao.get(i);
            string = string + this.sessao.getSessaoAsString();
        }
        return string;
    }

    public void reset() {
        this.controller.enviarEvento(new ResetEvent(this));
        this.listaSessao = new Vector();
        this.tamanhoSessao = 0;
        this.numLinha = 0;
        this.sessionChanged = false;
    }

    public int getTamanhoSessao() {
        return this.tamanhoSessao;
    }

    public void nextStep(Acao acao) {
        int n = acao.getCodigoAcao();
        String string = acao.getListaArg();
        this.refazGrafico(n, string);
        this.controller.enviarEvento(new IgrafMenuArquivoEvent(this, acao.getDescricao() + " " + string));
        if (this.ultimaLinha == this.numLinha) {
            this.controller.enviarEvento(new IgrafMenuArquivoEvent(this, ResourceReader.msg("FIM") + "\n"));
        }
    }

    public void restabelerSessao() {
        while (this.numLinha < this.ultimaLinha) {
            this.nextStep((Acao)this.listaAcao.get(this.numLinha++));
        }
        this.numLinha = 0;
    }

    public void carregarListaAcao() {
        this.listaAcao = this.sessao.getListaAcao();
        this.ultimaLinha = this.listaAcao.size();
    }

    public void proximaAcao() {
        if (this.numLinha < this.ultimaLinha) {
            this.nextStep((Acao)this.listaAcao.get(this.numLinha++));
        } else {
            this.numLinha = 0;
        }
    }

    public static String[] limpaLinha(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        String string3 = "";
        int n = 0;
        int n2 = 0;
        if (string == null || string == "") {
            return null;
        }
        int n3 = string.indexOf("{");
        string = string.substring(n3, string.length()).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if ((string2 = string2.trim()) == "" || string2.length() == 0) continue;
            if (n % 3 == 0) {
                if (string2.charAt(0) != '{') continue;
                n = 1;
                continue;
            }
            if (n % 3 == 1) {
                string3 = string2;
                n = 2;
                continue;
            }
            int n4 = string2.length();
            if (string2.charAt(n4 - 1) != '}') continue;
            string2 = "{" + string3 + " }";
            ++n2;
            vector.addElement(string2);
            n = 0;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public void refazSessao(String string) {
        String[] stringArray = ArquivoModel.limpaLinha(string);
        String string2 = "";
        this.carregando = true;
        this.vetSessao = new Vector();
        this.vetorRespostas = new Vector();
        this.vetSessaoCripto = new Vector();
        this.vetSessaoCriptoIndice = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n = -1;
            string2 = string3;
            if (string3.charAt(0) != '{') continue;
            try {
                n = ArquivoModel.getKey(string3);
                string2 = ArquivoModel.getArg(string3);
                this.refazGrafico(n, string2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Erro: ao ler arquivo, na linha " + i + " chave=" + n + ": " + string3 + ": " + exception);
            }
        }
        if (this.anotouExercicio) {
            // empty if block
        }
        this.anotouExercicio = false;
        this.carregando = false;
    }

    private void refazGrafico(int n, String string) {
        Object e = null;
        try {
            switch (n) {
                case 0: {
                    this.controller.enviarEvento(new EntradaExpressaoEvent(this, string));
                    break;
                }
                case 1: {
                    this.controller.enviarEvento(new IgrafMenuGraficoEvent(this, "msgMenuGrfDesTodos"));
                    break;
                }
                case 2: {
                    this.controller.enviarEvento(new IgrafMenuGraficoEvent(this, "msgMenuGrfEsconderUlt"));
                    break;
                }
                case 3: {
                    this.controller.enviarEvento(new IgrafMenuGraficoEvent(this, string, "msgMenuGrfEsconder"));
                    break;
                }
                case 4: {
                    this.controller.enviarEvento(new IgrafMenuGraficoEvent(this, "msgMenuGrfRemoverTodos"));
                    break;
                }
                case 5: {
                    this.controller.enviarEvento(new IgrafMenuGraficoEvent(this, "msgMenuGrfEsconderTodos"));
                    break;
                }
                case 6: {
                    this.controller.enviarEvento(new EdicaoExpressaoEvent(string, this));
                    break;
                }
                case 7: {
                    this.controller.enviarEvento(new IgrafMenuGraficoEvent(this, "msgMenuGrfNovaAba"));
                    break;
                }
                case 30: {
                    this.controller.enviarEvento(new IgrafMenuPoligonoEvent(this, "load_polygon", string));
                    break;
                }
                case 31: {
                    this.controller.enviarEvento(new IgrafMenuPoligonoEvent("undo_polygon", this));
                    break;
                }
                case 32: {
                    this.controller.enviarEvento(new IgrafMenuPoligonoEvent("redo_polygon", this));
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    break;
                }
                case 102: {
                    break;
                }
                case 103: {
                    break;
                }
                case 200: {
                    this.controller.enviarEvento(new IgrafMenuEdicaoEvent(this, "data loaded from file", 200));
                    break;
                }
                case 201: {
                    this.controller.enviarEvento(new IgrafMenuEdicaoEvent(this, "data loaded from file", 201));
                    break;
                }
                case 202: {
                    this.controller.enviarEvento(new IgrafMenuEdicaoEvent(this, "data loaded from file", 202));
                    break;
                }
                case 300: {
                    this.controller.enviarEvento(new IgrafMenuCalculoEvent(this, string, IgrafMenuCalculoEvent.DERIVATE));
                    break;
                }
                case 301: {
                    this.controller.enviarEvento(new JanelaTangenteEvent((Object)this, string));
                    break;
                }
                case 302: {
                    this.controller.enviarEvento(new JanelaIntegralEvent((Object)this, string));
                    break;
                }
                case 303: {
                    this.controller.enviarEvento(new IgrafMenuCalculoEvent(this, string, IgrafMenuCalculoEvent.INTEGRATE));
                    break;
                }
                case 600: {
                    return;
                }
                case 601: {
                    this.controller.enviarEvento(new RespostaNumericaEvent(string, this));
                    break;
                }
                case 602: {
                    this.controller.enviarEvento(new RespostaAlgebricaEvent(string, this));
                    break;
                }
                case 603: {
                    this.controller.enviarEvento(new RespostaPontoEvent(string, this));
                    break;
                }
                case 604: {
                    this.controller.enviarEvento(new RespostaIntervaloEvent(string, this));
                    break;
                }
                case 605: {
                    this.controller.enviarEvento(new RespostaDiscursivaEvent(string, this, 605));
                    break;
                }
                case 609: {
                    this.controller.enviarEvento(new DisableMenuEvent(this, string));
                    break;
                }
                case 606: {
                    this.controller.enviarEvento(new DiagnosticEvent(this, "load result", "", 606));
                    break;
                }
                case 607: {
                    this.controller.enviarEvento(new DiagnosticEvent(this, "load result", string, 607));
                    break;
                }
                case 608: {
                    this.controller.enviarEvento(new DiagnosticEvent(this, "load result", string, 608));
                    break;
                }
                case 610: {
                    this.controller.enviarEvento(new DiagnosticEvent(this, "load result", string, 610));
                    break;
                }
                case 203: 
                case 400: 
                case 401: 
                case 402: {
                    this.controller.enviarEvento(new EstadoTelaEvent(this, string));
                    break;
                }
                case 500: {
                    ++DesenhoTextoEvent.textId;
                    this.controller.enviarEvento(new DesenhoTextoEvent(this, string, "insertText"));
                    break;
                }
                case 501: {
                    this.controller.enviarEvento(new DesenhoTextoEvent(this, string, "eraseText"));
                    break;
                }
                case 502: {
                    break;
                }
                case 503: {
                    break;
                }
                default: {
                    System.err.println("Erro no carregamento do arquivo\n N\u00e3o foi possivel anotar acao " + n + ": " + string);
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        if (e != null) {
            this.vetorRespostas.addElement(e);
        }
    }

    public static String getArg(String string) {
        int n = string.indexOf(44, 6) + 1;
        int n2 = string.length() - 1;
        return string.substring(n, n2);
    }

    public static int getKey(String string) {
        int n = string.indexOf(44);
        String string2 = string.substring(1, n);
        return Integer.parseInt(string2);
    }
}

