/*
 * Decompiled with CFR 0.152.
 */
package igraf.edu.hws.jcm.data;

import igraf.edu.hws.jcm.data.ExpressionProgram;
import igraf.edu.hws.jcm.data.MathObject;
import igraf.edu.hws.jcm.data.NumUtils;
import igraf.edu.hws.jcm.data.ParseError;
import igraf.edu.hws.jcm.data.SymbolTable;
import java.io.Serializable;

public class ParserContext
implements Serializable {
    public static final int END_OF_STRING = 1;
    public static final int NUMBER = 2;
    public static final int IDENTIFIER = 3;
    public static final int OPCHARS = 4;
    private static final int NONE = 0;
    public String data;
    public int pos;
    public ExpressionProgram prog;
    public int token;
    public String tokenString;
    public MathObject tokenObject;
    public double tokenValue;
    public int options;
    protected SymbolTable symbols;
    private StringBuffer tokBuf = new StringBuffer();

    public ParserContext(String string, int n, SymbolTable symbolTable) {
        this.data = string;
        this.options = n;
        this.symbols = symbolTable;
        this.prog = new ExpressionProgram();
    }

    public void mark() {
        this.symbols = new SymbolTable(this.symbols);
    }

    public void revert() {
        this.symbols = this.symbols.getParent();
    }

    public MathObject get(String string) {
        if ((this.options & 1) != 0) {
            return this.symbols.get(string);
        }
        return this.symbols.get(string.toLowerCase());
    }

    public void add(MathObject mathObject) {
        if ((this.options & 1) != 0) {
            this.symbols.add(mathObject);
        } else {
            this.symbols.add(mathObject.getName().toLowerCase(), mathObject);
        }
    }

    public int next() {
        int n = this.look();
        if (this.token != 1) {
            this.token = 0;
        }
        return n;
    }

    public int look() {
        if (this.token == 0) {
            while (this.pos < this.data.length() && (this.data.charAt(this.pos) == ' ' || this.data.charAt(this.pos) == '\t')) {
                ++this.pos;
            }
            if (this.pos >= this.data.length()) {
                this.token = 1;
                this.tokenString = null;
            } else {
                this.readToken();
            }
        }
        return this.token;
    }

    private void readToken() {
        char c = this.data.charAt(this.pos);
        int n = this.pos;
        this.tokBuf.setLength(0);
        if (Character.isLetter(c) || c == '_' && (this.options & 0x80) == 0) {
            this.token = 3;
            while (Character.isLetter(c) || c == '_' && (this.options & 0x80) == 0 || Character.isDigit(c) && (this.options & 0x100) == 0) {
                this.tokBuf.append(c);
                ++this.pos;
                if (this.pos >= this.data.length()) break;
                c = this.data.charAt(this.pos);
            }
            this.tokenString = this.tokBuf.toString();
            this.tokenObject = null;
            for (int i = this.tokenString.length(); i > 0; --i) {
                String string = this.tokenString.substring(0, i);
                if ((this.options & 0x20) != 0) {
                    if (string.equalsIgnoreCase("and")) {
                        this.token = 4;
                        this.tokenString = "&";
                        this.pos = n + 3;
                        return;
                    }
                    if (string.equalsIgnoreCase("or")) {
                        this.token = 4;
                        this.tokenString = "|";
                        this.pos = n + 2;
                        return;
                    }
                    if (string.equalsIgnoreCase("not")) {
                        this.token = 4;
                        this.tokenString = "~";
                        this.pos = n + 3;
                        return;
                    }
                }
                if (this.get(string) != null) {
                    this.tokenString = string;
                    this.tokenObject = this.get(this.tokenString);
                    this.pos = n + i;
                } else if ((this.options & 4) != 0) {
                    continue;
                }
                break;
            }
        } else if (Character.isDigit(c) || c == '.' && this.pos < this.data.length() - 1 && Character.isDigit(this.data.charAt(this.pos + 1))) {
            this.token = 2;
            while (this.pos < this.data.length() && Character.isDigit(this.data.charAt(this.pos))) {
                this.tokBuf.append(this.data.charAt(this.pos++));
            }
            if (this.pos < this.data.length() && this.data.charAt(this.pos) == '.') {
                this.tokBuf.append(this.data.charAt(this.pos++));
                while (this.pos < this.data.length() && Character.isDigit(this.data.charAt(this.pos))) {
                    this.tokBuf.append(this.data.charAt(this.pos++));
                }
            }
            if (this.pos < this.data.length() && (this.data.charAt(this.pos) == 'e' || this.data.charAt(this.pos) == 'E')) {
                n = this.pos;
                this.tokBuf.append(this.data.charAt(this.pos++));
                if (this.pos < this.data.length() && (this.data.charAt(this.pos) == '+' || this.data.charAt(this.pos) == '-')) {
                    this.tokBuf.append(this.data.charAt(this.pos++));
                }
                if (this.pos >= this.data.length() || !Character.isDigit(this.data.charAt(this.pos))) {
                    if ((this.options & 2) == 0) {
                        throw new ParseError("Illegal number, '" + this.tokBuf.toString() + "'.  No digits in exponential part.", this);
                    }
                    this.pos = n;
                } else {
                    while (this.pos < this.data.length() && Character.isDigit(this.data.charAt(this.pos))) {
                        this.tokBuf.append(this.data.charAt(this.pos++));
                    }
                }
            }
            this.tokenString = this.tokBuf.toString();
            double d = NumUtils.stringToReal(this.tokenString);
            if (Double.isInfinite(d)) {
                throw new ParseError("The number '" + this.tokBuf.toString() + "' is outside the range of legal numbers.", this);
            }
            if (Double.isNaN(d)) {
                throw new ParseError("The string '" + this.tokBuf.toString() + "' is not a legal number.", this);
            }
            this.tokenValue = d;
        } else {
            this.token = 4;
            this.tokenString = "" + c;
            ++this.pos;
            if (this.pos < this.data.length()) {
                char c2 = this.data.charAt(this.pos);
                switch (c) {
                    case '*': {
                        if (c2 != '*') break;
                        this.tokenString = "^";
                        ++this.pos;
                        break;
                    }
                    case '=': {
                        if (c2 == '<' || c2 == '>') {
                            this.tokenString = this.data.charAt(this.pos++) + this.tokenString;
                        }
                        break;
                    }
                    case '<': {
                        if (c2 == '=' || c2 == '>') {
                            this.tokenString = this.tokenString + this.data.charAt(this.pos++);
                        }
                        break;
                    }
                    case '>': {
                        if (c2 == '=') {
                            this.tokenString = this.tokenString + this.data.charAt(this.pos++);
                            break;
                        }
                        if (c2 != '<') break;
                        this.tokenString = this.data.charAt(this.pos++) + this.tokenString;
                    }
                }
            }
        }
    }
}

