/*
 * Decompiled with CFR 0.152.
 */
package icomb.util;

public final class Matrix {
    private final int M;
    private final int N;
    private final double[][] data;

    public Matrix(int n, int n2) {
        this.M = n;
        this.N = n2;
        this.data = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this.M = dArray.length;
        this.N = dArray[0].length;
        this.data = new double[this.M][this.N];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.data[i][j] = dArray[i][j];
            }
        }
    }

    private Matrix(Matrix matrix) {
        this(matrix.data);
    }

    public static Matrix random(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.data[i][j] = Math.random();
            }
        }
        return matrix;
    }

    public static Matrix identity(int n) {
        Matrix matrix = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.data[i][i] = 1.0;
        }
        return matrix;
    }

    private void swap(int n, int n2) {
        double[] dArray = this.data[n];
        this.data[n] = this.data[n2];
        this.data[n2] = dArray;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.N, this.M);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                matrix.data[j][i] = this.data[i][j];
            }
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        Matrix matrix2 = this;
        if (matrix.M != matrix2.M || matrix.N != matrix2.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix matrix3 = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                matrix3.data[i][j] = matrix2.data[i][j] + matrix.data[i][j];
            }
        }
        return matrix3;
    }

    public Matrix minus(Matrix matrix) {
        Matrix matrix2 = this;
        if (matrix.M != matrix2.M || matrix.N != matrix2.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix matrix3 = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                matrix3.data[i][j] = matrix2.data[i][j] - matrix.data[i][j];
            }
        }
        return matrix3;
    }

    public boolean eq(Matrix matrix) {
        Matrix matrix2 = this;
        if (matrix.M != matrix2.M || matrix.N != matrix2.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (matrix2.data[i][j] == matrix.data[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix times(Matrix matrix) {
        Matrix matrix2 = this;
        if (matrix2.N != matrix.M) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix matrix3 = new Matrix(matrix2.M, matrix.N);
        for (int i = 0; i < matrix3.M; ++i) {
            for (int j = 0; j < matrix3.N; ++j) {
                for (int k = 0; k < matrix2.N; ++k) {
                    double[] dArray = matrix3.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + matrix2.data[i][k] * matrix.data[k][j];
                }
            }
        }
        return matrix3;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        if (this.M != this.N || matrix.M != this.N || matrix.N != 1) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix matrix2 = new Matrix(this);
        Matrix matrix3 = new Matrix(matrix);
        for (int i = 0; i < this.N; ++i) {
            int n2;
            n = i;
            for (n2 = i + 1; n2 < this.N; ++n2) {
                if (!(Math.abs(matrix2.data[n2][i]) > Math.abs(matrix2.data[n][i]))) continue;
                n = n2;
            }
            matrix2.swap(i, n);
            matrix3.swap(i, n);
            if (matrix2.data[i][i] == 0.0) {
                throw new RuntimeException("Matrix is singular.");
            }
            for (n2 = i + 1; n2 < this.N; ++n2) {
                double[] dArray = matrix3.data[n2];
                dArray[0] = dArray[0] - matrix3.data[i][0] * matrix2.data[n2][i] / matrix2.data[i][i];
            }
            for (n2 = i + 1; n2 < this.N; ++n2) {
                double d = matrix2.data[n2][i] / matrix2.data[i][i];
                for (int j = i + 1; j < this.N; ++j) {
                    double[] dArray = matrix2.data[n2];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - matrix2.data[i][j] * d;
                }
                matrix2.data[n2][i] = 0.0;
            }
        }
        Matrix matrix4 = new Matrix(this.N, 1);
        for (n = this.N - 1; n >= 0; --n) {
            double d = 0.0;
            for (int i = n + 1; i < this.N; ++i) {
                d += matrix2.data[n][i] * matrix4.data[i][0];
            }
            matrix4.data[n][0] = (matrix3.data[n][0] - d) / matrix2.data[n][n];
        }
        return matrix4;
    }

    public void show() {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                System.out.println(this.data[i][j]);
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {9.0, 1.0, 3.0}};
        Matrix matrix = new Matrix(dArrayArray);
        matrix.show();
        System.out.println();
        Matrix matrix2 = Matrix.random(5, 5);
        matrix2.show();
        System.out.println();
        matrix2.swap(1, 2);
        matrix2.show();
        System.out.println();
        Matrix matrix3 = matrix2.transpose();
        matrix3.show();
        System.out.println();
        Matrix matrix4 = Matrix.identity(5);
        matrix4.show();
        System.out.println();
        matrix2.plus(matrix3).show();
        System.out.println();
        matrix3.times(matrix2).show();
        System.out.println();
        System.out.println(matrix2.times(matrix3).eq(matrix3.times(matrix2)));
        System.out.println();
        Matrix matrix5 = Matrix.random(5, 1);
        matrix5.show();
        System.out.println();
        Matrix matrix6 = matrix2.solve(matrix5);
        matrix6.show();
        System.out.println();
        matrix2.times(matrix6).show();
    }
}

