/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import icomb.components.CustomChoice;
import icomb.events.ObjectManager;
import icomb.objects.Condicao;
import icomb.objects.Expressao;
import icomb.objects.Universo;
import icomb.ui.ConstructionPanel;
import icomb.ui.IListFrameListener;
import icomb.ui.ListFrame;
import icomb.ui.MessageFrame;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.I18n;
import icomb.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;

public class StagePanel
extends Panel
implements ItemListener,
ActionListener {
    private static int cont = 0;
    private static final String STR_LBL_AND = I18n.getString("and");
    private static final String STR_LBL_AND_ABOUT = I18n.getString("about_and");
    private static final Label LBL_AND1 = new Label("");
    private static final Label LBL_AND2 = new Label(STR_LBL_AND);
    private static final Label LBL_AND_ABOUT = new Label(STR_LBL_AND_ABOUT);
    private static final int TOTAL = 50;
    private static final int ALT = 10;
    private static final int ALT2 = 12;
    private final ConstructionPanel painelConstrucao;
    private final Button btnVerifyStage;
    private final Button btnAddStage;
    private CustomChoice chNumberOfElements;
    private CustomChoice chNumberOfProp;
    private CustomChoice chAttributes1;
    private CustomChoice chAttributes2;
    private CustomChoice chRelations1;
    private CustomChoice chRelations2;
    private CustomChoice chElements1;
    private CustomChoice chElements2;
    private Label lblIWant;
    private Label lblElementsVerifying;
    private Label lblExplain = null;
    private Label lblAnd1;
    private Label lblAnd2;
    private final Panel panelFormula;
    private final Panel panelFormulaEdit;
    private final Label lblFormula;
    private final Label lblN;
    private final Label lblP;
    private final CustomChoice chFormula;
    private final CustomChoice chN;
    private final CustomChoice chP;
    private final Panel panelFormulaCancel;
    private final Label lblCancel;
    private final Button btnCancelFormula;
    private final Button btnOk;
    private final ListFrame listFrame;
    private final Label lblListElements1;
    private String strListElements1;
    private final Label lblListElements2;
    private String strListElements2;
    private Button btnEscolhe1;
    private Button btnEscolhe2;

    private static void setFontStatic(Component component) {
        try {
            component.setFont(Configuracoes.FONTE_BOTAO);
        }
        catch (Exception exception) {
            System.err.println("Error: in stage panel, while defining font " + Configuracoes.FONTE_BOTAO + ": " + exception);
        }
    }

    public void limpaListElementos1() {
        this.lblListElements1.setText("");
        this.strListElements1 = "";
    }

    public void limpaListElementos2() {
        this.lblListElements2.setText("");
        this.strListElements1 = "";
    }

    public StagePanel(ConstructionPanel constructionPanel) {
        this.painelConstrucao = constructionPanel;
        this.setBackground(Configuracoes.CINZA);
        this.lblListElements1 = new Label();
        this.lblListElements2 = new Label();
        this.strListElements1 = "";
        this.strListElements2 = "";
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        panel.setBackground(Configuracoes.CINZA);
        Panel panel2 = new Panel(new GridLayout(0, 1, 0, 0));
        panel2.setVisible(false);
        panel2.add(this.firstLine());
        panel2.add(this.secondLine());
        panel2.add(this.thirdLine());
        this.invisible();
        panel2.setVisible(true);
        this.add((Component)panel2, "Center");
        Panel panel3 = new Panel(new BorderLayout(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        });
        this.lblFormula = new Label(I18n.getString("formula"));
        this.lblFormula.setForeground(Configuracoes.FACE_DARK1);
        this.lblFormula.setFont(Configuracoes.FONTE_BOTAO);
        this.lblN = new Label("n");
        this.lblN.setForeground(Configuracoes.FACE_DARK1);
        this.lblP = new Label("p");
        this.lblP.setForeground(Configuracoes.FACE_DARK1);
        this.panelFormulaEdit = new Panel(new FlowLayout(0));
        this.panelFormulaEdit.setBackground(Configuracoes.CINZA);
        this.chFormula = ObjectManager.criaCombo(this.panelFormulaEdit, Util.getListFormula(), I18n.getString("choiceFormula-dica"));
        this.chFormula.addItemListener(this);
        this.chN = ObjectManager.criaCombo(this.panelFormulaEdit, Util.getListNumbers(50), I18n.getString("choiceN-dica"));
        this.chP = ObjectManager.criaCombo(this.panelFormulaEdit, Util.getListNumbers(50), I18n.getString("choiceP-dica"));
        this.chN.addItemListener(this);
        this.chP.addItemListener(this);
        this.lblCancel = new Label("");
        this.panelFormulaCancel = new Panel(new FlowLayout(0));
        this.panelFormulaCancel.setBackground(Configuracoes.CINZA);
        this.btnCancelFormula = ObjectManager.criaBotao(this.panelFormulaCancel, I18n.getString("cancel"), I18n.getString("cancel-dica"));
        this.btnCancelFormula.addActionListener(this);
        this.panelFormulaCancel.add(this.lblCancel);
        this.panelFormulaCancel.add(this.btnCancelFormula);
        this.btnOk = ObjectManager.criaBotao(this.panelFormulaEdit, I18n.getString("ok"), I18n.getString("ok-dica"));
        this.btnOk.setSize(new Dimension(23, 23));
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(this);
        this.lblFormula.setVisible(false);
        this.lblN.setVisible(false);
        this.lblP.setVisible(false);
        this.chFormula.setVisible(false);
        this.chN.setVisible(false);
        this.chP.setVisible(false);
        this.btnOk.setVisible(false);
        this.panelFormulaEdit.add(this.lblFormula);
        this.panelFormulaEdit.add(this.chFormula);
        this.panelFormulaEdit.add(this.lblN);
        this.panelFormulaEdit.add(this.chN);
        this.panelFormulaEdit.add(this.lblP);
        this.panelFormulaEdit.add(this.chP);
        this.panelFormulaEdit.add(this.btnOk);
        this.panelFormula = new Panel(new BorderLayout());
        this.panelFormula.add(this.panelFormulaEdit);
        panel3.setBackground(Configuracoes.CINZA);
        this.btnVerifyStage = ObjectManager.criaBotao(panel3, I18n.getString("verifyStage"), I18n.getString("verifyStage-dica"));
        this.btnVerifyStage.setEnabled(false);
        this.btnVerifyStage.addActionListener(this);
        this.btnAddStage = ObjectManager.criaBotao(panel3, I18n.getString("addStage"), I18n.getString("addStage-dica"));
        this.btnAddStage.setEnabled(false);
        this.btnAddStage.addActionListener(this);
        panel3.setBackground(Configuracoes.CINZA);
        Panel panel4 = new Panel();
        panel4.add(this.btnVerifyStage);
        panel4.add(this.panelFormula);
        panel4.add(this.btnAddStage);
        panel4.setSize(550, 30);
        this.btnVerifyStage.setSize(90, 23);
        this.btnVerifyStage.setLocation(0, 3);
        this.panelFormula.setSize(300, 25);
        this.panelFormula.setLocation(100, 0);
        panel3.add((Component)panel4, "West");
        this.add((Component)panel3, "South");
        this.listFrame = new ListFrame(this);
        this.validate();
        this.close();
        this.setVisible(true);
    }

    public Panel constroiPainel(int n, CustomChoice customChoice, CustomChoice customChoice2, CustomChoice customChoice3, Button button) {
        Panel panel = new Panel();
        Panel panel2 = new Panel(new FlowLayout(0));
        panel2.setSize(550, 60);
        if (n == 1) {
            panel.setSize(550, 190);
            panel.setLayout(new BorderLayout());
            this.lblExplain = LBL_AND_ABOUT;
            StagePanel.setFontStatic(this.lblExplain);
            this.lblExplain.setSize(132, 10);
            this.lblExplain.setForeground(Configuracoes.FACE_DARK1);
            this.lblExplain.setVisible(false);
            panel.add((Component)this.lblExplain, "North");
            this.lblAnd1 = LBL_AND1;
            StagePanel.setFontStatic(this.lblAnd1);
            this.lblAnd1.setForeground(Configuracoes.FACE_DARK1);
            this.lblAnd1.setVisible(false);
            panel2.add(this.lblAnd1);
            panel.add((Component)panel2, "Center");
        } else {
            panel.setSize(550, 190);
            panel.setLayout(new FlowLayout(0));
            this.lblAnd2 = LBL_AND2;
            StagePanel.setFontStatic(this.lblAnd2);
            this.lblAnd2.setForeground(Configuracoes.FACE_DARK1);
            this.lblAnd2.setVisible(false);
            panel2.add(this.lblAnd2);
            panel.add(panel2);
        }
        panel2.add(customChoice);
        customChoice.setVisible(false);
        panel2.add(customChoice2);
        customChoice2.setVisible(false);
        panel2.add(customChoice3);
        customChoice3.setVisible(false);
        panel2.add(button);
        button.setVisible(false);
        return panel;
    }

    public Panel firstLine() {
        Panel panel = new Panel(new FlowLayout(0));
        panel.setForeground(Configuracoes.FACE_DARK1);
        panel.setBackground(Configuracoes.CINZA);
        this.lblIWant = new Label(I18n.getString("iWant"));
        StagePanel.setFontStatic(this.lblIWant);
        panel.add(this.lblIWant);
        this.chNumberOfElements = ObjectManager.criaCombo(panel, Util.getListNumbers(50), I18n.getString("iWant-dica"));
        this.chNumberOfElements.addItemListener(this);
        panel.add(this.chNumberOfElements);
        this.lblElementsVerifying = new Label(I18n.getString("elementsVerifying"));
        StagePanel.setFontStatic(this.lblElementsVerifying);
        panel.add(this.lblElementsVerifying);
        this.chNumberOfProp = ObjectManager.criaCombo(panel, Util.getListPropertyOptions(), I18n.getString("choiceNumberOfPrepositions-dica"));
        this.chNumberOfProp.addItemListener(this);
        panel.add(this.chNumberOfProp);
        return panel;
    }

    public void carregaAtributos(Universo universo) {
        this.chAttributes1.removeAll();
        this.chAttributes2.removeAll();
        Vector vector = universo.getAtributos();
        this.chAttributes1.populate(vector);
        this.chAttributes2.populate(vector);
        ObjectManager.defineCoresFonte(-2, null, this, this.chAttributes1);
        ObjectManager.defineCoresFonte(-2, null, this, this.chAttributes2);
    }

    public Panel secondLine() {
        if (ObjectManager.setMachine.getUniverso() == null) {
            Vector<String> vector = new Vector<String>();
            vector.add("");
            this.chAttributes1 = ObjectManager.criaCombo(this, vector, I18n.getString("choiceAttribute1-dica"));
        } else {
            this.chAttributes1 = ObjectManager.criaCombo(this, ObjectManager.setMachine.getUniverso().getAtributos(), I18n.getString("choiceAttribute1-dica"));
        }
        this.chAttributes1.addItemListener(this);
        this.chAttributes1.setSize(100, 10);
        this.chRelations1 = ObjectManager.criaCombo(this, Util.getListRelationOptions(), I18n.getString("choiceRelation1-dica"));
        this.chRelations1.addItemListener(this);
        this.chRelations1.setSize(80, 10);
        this.chElements1 = ObjectManager.criaCombo(this, new Vector(), I18n.getString("choiceElements1-dica"));
        this.chElements1.setSize(150, 10);
        this.chElements1.addItemListener(this);
        this.btnEscolhe1 = ObjectManager.criaBotao(this, I18n.getString("inNotInSet"), I18n.getString("inNotInSet-dica"));
        this.btnEscolhe1.setSize(23, 12);
        this.btnEscolhe1.addActionListener(this);
        this.lblListElements1.setSize(150, 10);
        this.limpaListElementos1();
        return this.constroiPainel(1, this.chAttributes1, this.chRelations1, this.chElements1, this.btnEscolhe1);
    }

    public Panel thirdLine() {
        this.chAttributes2 = ObjectManager.setMachine.getUniverso() == null ? ObjectManager.criaCombo(this, new Vector(), "choiceAttribute2-dica") : ObjectManager.criaCombo(this, ObjectManager.setMachine.getUniverso().getAtributos(), "choiceAttribute2-dica");
        this.chAttributes2.addItemListener(this);
        this.chAttributes2.setSize(100, 10);
        this.chRelations2 = ObjectManager.criaCombo(this, Util.getListRelationOptions(), "choiceRelation2-dica");
        this.chRelations2.addItemListener(this);
        this.chRelations2.setSize(80, 10);
        this.chElements2 = ObjectManager.criaCombo(this, new Vector(), "choiceElement2-dica");
        this.chElements2.setSize(150, 10);
        this.chElements2.addItemListener(this);
        this.btnEscolhe2 = ObjectManager.criaBotao(this, I18n.getString("inNotInSet"), I18n.getString("inNotInSet-dica"));
        StagePanel.setFontStatic(this.btnEscolhe2);
        this.btnEscolhe2.setSize(23, 12);
        this.btnEscolhe2.addActionListener(this);
        this.lblListElements2.setSize(150, 10);
        this.limpaListElementos2();
        return this.constroiPainel(2, this.chAttributes2, this.chRelations2, this.chElements2, this.btnEscolhe2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH - 10, 178);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.drawString(I18n.getString("stage"), 5, 15);
        graphics.setColor(Configuracoes.CINZA_ESCURO);
        graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    private boolean multiple1() {
        return this.chRelations1.getSelectedKey().equals("isIn") || this.chRelations1.getSelectedKey().equals("isNotIn");
    }

    private boolean multiple2() {
        return this.chRelations2.getSelectedKey().equals("isIn") || this.chRelations2.getSelectedKey().equals("isNotIn");
    }

    private String testChoice(ItemEvent itemEvent) {
        CustomChoice customChoice = (CustomChoice)itemEvent.getSource();
        if (customChoice == this.chFormula) {
            return "chFormula";
        }
        if (customChoice == this.chN) {
            return "chN";
        }
        if (customChoice == this.chP) {
            return "chP";
        }
        if (customChoice == this.chNumberOfElements) {
            return "chNumberOfElements";
        }
        if (customChoice == this.chNumberOfProp) {
            return "chNumberOfProp";
        }
        if (customChoice == this.chAttributes1) {
            return "chAttributes1";
        }
        if (customChoice == this.chRelations1) {
            return "chRelations1";
        }
        if (customChoice == this.chElements1) {
            return "chElements1";
        }
        if (customChoice == this.chAttributes2) {
            return "chAttributes2";
        }
        if (customChoice == this.chRelations2) {
            return "chRelations2";
        }
        if (customChoice == this.chElements2) {
            return "chElements2";
        }
        return "<>";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chRelations1 || itemEvent.getSource() == this.chAttributes1) {
            if (!this.chRelations1.getSelectedKey().equals("chooseOption") && !this.chAttributes1.getSelectedKey().equals("chooseOption")) {
                if (this.multiple1()) {
                    this.chElements1.setVisible(false);
                    this.btnEscolhe1.setVisible(true);
                } else {
                    this.chElements1.populate(ObjectManager.setMachine.getUniverso().getPredicados(this.chAttributes1.getSelectedKey()));
                    this.chElements1.setVisible(true);
                    this.btnEscolhe1.setVisible(false);
                }
                this.limpaListElementos1();
            }
            this.updateBtnOk();
            this.updateBtnVerify();
        } else if (itemEvent.getSource() == this.chRelations2 || itemEvent.getSource() == this.chAttributes2) {
            if (!this.chRelations2.getSelectedKey().equals("chooseOption") && !this.chAttributes2.getSelectedKey().equals("chooseOption")) {
                if (this.multiple2()) {
                    this.chElements2.setVisible(false);
                    this.btnEscolhe2.setVisible(true);
                } else {
                    this.chElements2.populate(ObjectManager.setMachine.getUniverso().getPredicados(this.chAttributes2.getSelectedKey()));
                    this.chElements2.setVisible(true);
                    this.btnEscolhe2.setVisible(false);
                }
                this.limpaListElementos2();
            }
            this.updateBtnOk();
            this.updateBtnVerify();
        } else if (itemEvent.getSource() == this.chFormula) {
            if (!this.chFormula.getSelectedKey().equals("chooseOption")) {
                ObjectManager.setMachine.setFormulaAtual(this.chFormula.getSelectedKey());
                this.inputFormulaMode();
                if (ObjectManager.setMachine.formulaAtualTemParametroN()) {
                    this.chN.setVisible(true);
                    this.lblN.setVisible(true);
                } else {
                    this.chN.setVisible(false);
                    this.lblN.setVisible(false);
                }
                if (ObjectManager.setMachine.formulaAtualTemParametroP()) {
                    this.chP.setVisible(true);
                    this.lblP.setVisible(true);
                } else {
                    this.chP.setVisible(false);
                    this.lblP.setVisible(false);
                }
            } else {
                this.chN.setVisible(false);
                this.lblN.setVisible(false);
                this.chP.setVisible(false);
                this.lblP.setVisible(false);
            }
            this.updateBtnOk();
        } else if (itemEvent.getSource() == this.chN || itemEvent.getSource() == this.chP) {
            if (!this.chN.getSelectedKey().equals("chooseOption") || !this.chP.getSelectedKey().equals("chooseOption")) {
                ObjectManager.setMachine.defineNeP(this.chN.getSelectedKey(), this.chP.getSelectedKey());
            }
            this.updateBtnOk();
        } else if (itemEvent.getSource() == this.chNumberOfProp) {
            this.lblExplain.setVisible(false);
            this.lblAnd1.setVisible(false);
            this.lblAnd2.setVisible(false);
            this.lblAnd1.setVisible(false);
            String string = this.chNumberOfProp.getSelectedKey();
            if (string.equals("noProperty")) {
                this.lblExplain.setVisible(false);
                this.lblAnd1.setVisible(false);
                this.lblAnd2.setVisible(false);
                this.chAttributes1.setVisible(false);
                this.chRelations1.setVisible(false);
                this.chElements1.setVisible(false);
                this.btnEscolhe1.setVisible(false);
                this.chAttributes2.setVisible(false);
                this.chRelations2.setVisible(false);
                this.chElements2.setVisible(false);
                this.btnEscolhe2.setVisible(false);
            } else if (string.equals("oneProperty")) {
                this.lblExplain.setVisible(true);
                this.lblAnd1.setVisible(true);
                this.chAttributes1.setVisible(true);
                this.chRelations1.setVisible(true);
                boolean bl = this.multiple1();
                this.chElements1.setVisible(!bl);
                this.btnEscolhe1.setVisible(bl);
                this.chAttributes2.setVisible(false);
                this.chRelations2.setVisible(false);
                this.chElements2.setVisible(false);
            } else if (string.equals("twoProperties")) {
                this.lblExplain.setVisible(true);
                this.lblAnd1.setVisible(true);
                this.lblAnd2.setVisible(true);
                this.chAttributes1.setVisible(true);
                this.chRelations1.setVisible(true);
                boolean bl = this.multiple1();
                this.chElements1.setVisible(!bl);
                this.btnEscolhe1.setVisible(bl);
                this.chAttributes2.setVisible(true);
                this.chRelations2.setVisible(true);
                boolean bl2 = this.multiple2();
                this.chElements2.setVisible(!bl2);
                this.btnEscolhe2.setVisible(bl2);
            }
            this.updateBtnOk();
            this.updateBtnVerify();
        } else if (itemEvent.getSource() == this.chElements1 || itemEvent.getSource() == this.chElements2 || itemEvent.getSource() == this.chNumberOfElements || itemEvent.getSource() == this.chNumberOfProp) {
            this.updateBtnOk();
            this.updateBtnVerify();
        }
        this.validate();
    }

    public void invisible() {
        this.lblAnd1.setVisible(false);
        this.lblAnd2.setVisible(false);
        this.lblExplain.setVisible(false);
        this.chAttributes1.setVisible(false);
        this.chRelations1.setVisible(false);
        this.chElements1.setVisible(false);
        this.btnEscolhe1.setVisible(false);
        this.chAttributes2.setVisible(false);
        this.chRelations2.setVisible(false);
        this.chElements2.setVisible(false);
        this.btnEscolhe2.setVisible(false);
    }

    public Condicao criaCondicao(StringBuffer stringBuffer) {
        Expressao expressao;
        boolean bl;
        String string;
        Condicao condicao = new Condicao(Integer.parseInt(this.chNumberOfElements.getSelectedKey()));
        stringBuffer.append("VerificaEstagio$");
        stringBuffer.append(Integer.parseInt(this.chNumberOfElements.getSelectedKey()));
        stringBuffer.append(" " + I18n.getString("elementsSuch") + " ");
        if (this.chAttributes1.isVisible()) {
            string = this.chElements1.getSelectedKey();
            if (!this.strListElements1.trim().equals("")) {
                string = this.strListElements1;
            }
            stringBuffer.append(I18n.getString(this.chAttributes1.getSelectedKey()) + " ");
            stringBuffer.append(I18n.getString(this.chRelations1.getSelectedKey()) + " ");
            stringBuffer.append(Util.translateSetString(string) + " ");
            bl = this.chRelations1.getSelectedKey().equals("isIn") || this.chRelations1.getSelectedKey().equals("is");
            expressao = new Expressao(this.chAttributes1.getSelectedKey(), bl, Util.produceStringSet(string));
            condicao.addExpressao(expressao);
        }
        if (this.chAttributes2.isVisible()) {
            string = this.chElements2.getSelectedKey();
            if (!this.strListElements2.trim().equals("")) {
                string = this.strListElements2;
            }
            stringBuffer.append(" " + I18n.getString("msgE") + " ");
            stringBuffer.append(I18n.getString(this.chAttributes2.getSelectedKey()) + " ");
            stringBuffer.append(I18n.getString(this.chRelations2.getSelectedKey()) + " ");
            stringBuffer.append(Util.translateSetString(string) + " ");
            bl = this.chRelations2.getSelectedKey().equals("isIn") || this.chRelations2.getSelectedKey().equals("is");
            expressao = new Expressao(this.chAttributes2.getSelectedKey(), bl, Util.produceStringSet(string));
            condicao.addExpressao(expressao);
        }
        return condicao;
    }

    public void verifyStage() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Condicao condicao = this.criaCondicao(stringBuffer);
            ObjectManager.setMachine.verificaErro(condicao);
            ObjectManager.getInstance().registraAcao(stringBuffer);
        }
        catch (RuntimeException runtimeException) {
            String string = runtimeException.getMessage();
            if (string == null) {
                System.err.println("StagePanel.verifyStage(...): Error: condition not found\n" + I18n.getString("evaluationMessage02"));
                string = I18n.getString("evaluationMessage02");
            }
            stringBuffer.append("ERRO--->");
            stringBuffer.append(string);
            MessageFrame.showMessage(string, this.painelConstrucao);
            ObjectManager.getInstance().registraAcao(stringBuffer);
            System.err.println("Erro: em painel de estagios, ao verificar o estagio: " + runtimeException + ": " + string);
            return;
        }
        this.btnVerifyStage.setEnabled(false);
        this.lblFormula.setVisible(true);
        this.chFormula.setVisible(true);
        this.btnOk.setVisible(true);
        this.btnOk.setEnabled(false);
        this.btnAddStage.setVisible(false);
        this.panelFormula.setVisible(true);
        this.panelFormulaEdit.setVisible(true);
        this.panelFormulaCancel.setVisible(false);
        this.panelFormula.add(this.panelFormulaEdit);
        this.panelFormula.remove(this.panelFormulaCancel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnVerifyStage) {
            this.verifyStage();
        } else if (actionEvent.getSource() == this.btnOk) {
            this.lblCancel.setBackground(Configuracoes.CINZA_ESCURO);
            this.lblCancel.setText(this.getFormula());
            this.btnAddStage.setEnabled(true);
            this.panelFormulaEdit.setVisible(false);
            this.panelFormulaCancel.setVisible(true);
            this.panelFormula.remove(this.panelFormulaEdit);
            this.panelFormula.add(this.panelFormulaCancel);
            this.btnAddStage.setVisible(true);
        } else if (actionEvent.getSource() == this.btnCancelFormula) {
            this.inputFormulaMode();
            System.out.println("StagePanel.verifyStage(): 3: dim. panelFormula " + this.panelFormula.getWidth() + "");
        } else if (actionEvent.getSource() == this.btnAddStage) {
            this.addStage();
        } else if (actionEvent.getSource() == this.btnEscolhe1) {
            this.openChoosenFrame(ObjectManager.setMachine.getUniverso().getPredicados(this.chAttributes1.getSelectedKey()), 1);
        } else if (actionEvent.getSource() == this.btnEscolhe2) {
            this.openChoosenFrame(ObjectManager.setMachine.getUniverso().getPredicados(this.chAttributes2.getSelectedKey()), 2);
        }
        this.validate();
    }

    private String getFormula() {
        String string = "";
        if (ObjectManager.setMachine.estagioAtualEstaDefinido() && ObjectManager.setMachine.formulaAtualEstaDefinida()) {
            string = ObjectManager.setMachine.getNomeFormulaAtual();
            if (string.equals("value")) {
                string = "" + ObjectManager.setMachine.getEstagioAtualN();
            } else {
                string = string.replaceAll("n", "" + ObjectManager.setMachine.getEstagioAtualN());
                string = string.replaceAll("p", "" + ObjectManager.setMachine.getEstagioAtualP());
            }
        }
        return string;
    }

    public void updateBtnOk() {
        if (this.chN != null && (!this.chN.isVisible() || this.chN.isVisible() && !this.chN.getSelectedKey().equals("chooseOption")) && this.chP != null && (!this.chP.isVisible() || this.chP.isVisible() && !this.chP.getSelectedKey().equals("chooseOption"))) {
            if (this.chN.isVisible() || this.chP.isVisible()) {
                this.btnOk.setEnabled(true);
            } else {
                this.btnOk.setEnabled(false);
            }
        } else {
            this.btnOk.setEnabled(false);
        }
    }

    private Hashtable getMap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("cboNElementos", this.chNumberOfElements.getSelectedKey());
        hashtable.put("cboPropOptions", this.chNumberOfProp.getSelectedKey());
        if (this.chAttributes1 != null) {
            hashtable.put("cboAttributes1", this.chAttributes1.getSelectedKey());
        }
        if (this.chRelations1 != null) {
            hashtable.put("cboRelations1", this.chRelations1.getSelectedKey());
        }
        if (!this.strListElements1.equals("")) {
            hashtable.put("cboElements1", this.strListElements1);
        } else if (this.chElements1 != null && this.chElements1.getSelectedKey() != null) {
            hashtable.put("cboElements1", this.chElements1.getSelectedKey());
        }
        try {
            if (this.chAttributes2 != null) {
                hashtable.put("cboAttributes2", this.chAttributes2.getSelectedKey());
            }
        }
        catch (Exception exception) {
            System.out.println("Erro: StagePanel.getMap(): chAttributes2: " + exception.toString());
            exception.printStackTrace();
            exception.printStackTrace();
        }
        if (this.chRelations2 != null) {
            hashtable.put("cboRelations2", this.chRelations2.getSelectedKey());
        }
        try {
            if (!this.strListElements2.equals("")) {
                hashtable.put("cboElements2", this.strListElements2);
            } else if (this.chElements2 != null && this.chElements2.getSelectedKey() != null) {
                hashtable.put("cboElements2", this.chElements2.getSelectedKey());
            }
        }
        catch (Exception exception) {
            System.err.println("Erro: StagePanel.getMap(): strListElements2=" + this.strListElements2 + ": " + exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    public void conditionSetted() {
        Hashtable hashtable = this.getMap();
        ObjectManager.setMachine.alimentaEstagioAuxiliar(hashtable);
        this.btnVerifyStage.setEnabled(true);
        this.painelConstrucao.redrawPanel();
    }

    public void updateBtnVerify() {
        if (this.chNumberOfElements.isVisible() && !this.chNumberOfElements.getSelectedKey().equals("chooseOption") && this.chNumberOfProp.isVisible() && !this.chNumberOfProp.getSelectedKey().equals("chooseOption")) {
            String string = this.chNumberOfProp.getSelectedKey();
            if (string.equals("noProperty")) {
                this.conditionSetted();
                return;
            }
            if (string.equals("oneProperty")) {
                if (this.preenchido1()) {
                    this.conditionSetted();
                    return;
                }
            } else if (string.equals("twoProperties") && this.preenchido1() && this.preenchido2()) {
                this.conditionSetted();
                return;
            }
        }
        this.cleanFormula();
        this.btnVerifyStage.setEnabled(false);
    }

    private boolean preenchido1() {
        try {
            return this.chAttributes1.isVisible() && !this.chAttributes1.getSelectedKey().equals("chooseOption") && this.chRelations1.isVisible() && !this.chRelations1.getSelectedKey().equals("chooseOption") && (this.chElements1.isVisible() && !this.chElements1.getSelectedKey().equals("chooseOption") && !this.chElements1.getSelectedKey().equals("") || !this.lblListElements1.getText().equals("") && !this.lblListElements1.getText().equals("{}"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean preenchido2() {
        return this.chAttributes2.isVisible() && !this.chAttributes2.getSelectedKey().equals("chooseOption") && this.chRelations2.isVisible() && !this.chRelations2.getSelectedKey().equals("chooseOption") && (this.chElements2.isVisible() && !this.chElements2.getSelectedKey().equals("chooseOption") && !this.chElements2.getSelectedKey().equals("") || !this.lblListElements2.getText().equals("") && !this.lblListElements2.getText().equals("{}"));
    }

    public void close() {
        String string = "";
        try {
            this.lblIWant.setVisible(false);
        }
        catch (Exception exception) {
            string = string + "close 1: " + exception.toString();
        }
        try {
            this.lblElementsVerifying.setVisible(false);
        }
        catch (Exception exception) {
            string = string + "close 2: " + exception.toString();
        }
        try {
            this.chNumberOfElements.select("chooseOption");
            this.chNumberOfElements.setVisible(false);
        }
        catch (Exception exception) {
            string = string + "close 1: " + exception.toString();
        }
        try {
            this.chNumberOfProp.setVisible(false);
            this.chNumberOfProp.select("chooseOption");
        }
        catch (Exception exception) {
            string = string + "close 1: " + exception.toString();
        }
        try {
            this.btnAddStage.setEnabled(false);
            this.btnVerifyStage.setEnabled(false);
        }
        catch (Exception exception) {
            string = string + "close 1: " + exception.toString();
        }
        if (string != "") {
            System.err.println("Erro: " + string);
        }
        this.panelFormula.setVisible(false);
        this.invisible();
        this.chAttributes1.select("");
        this.chElements1.populate(new Vector());
        this.chRelations1.select("chooseOption");
        this.chRelations2.select("chooseOption");
        this.chAttributes2.select("");
        this.chElements2.populate(new Vector());
        this.chFormula.select("chooseOption");
        this.chP.select("chooseOption");
        this.chN.select("chooseOption");
        this.lblListElements1.setText("");
        this.lblListElements2.setText("");
        this.strListElements1 = "";
        this.strListElements2 = "";
    }

    public void cleanFormula() {
        this.chFormula.select("chooseOption");
        this.chP.select("chooseOption");
        this.chN.select("chooseOption");
        this.chP.setVisible(false);
        this.chN.setVisible(false);
        this.lblN.setVisible(false);
        this.lblP.setVisible(false);
        this.btnOk.setVisible(false);
        this.panelFormula.setVisible(false);
    }

    public void open() {
        this.lblIWant.setVisible(true);
        this.lblElementsVerifying.setVisible(true);
        this.chNumberOfElements.setVisible(true);
        this.chNumberOfProp.setVisible(true);
        this.panelFormula.setVisible(false);
        this.invisible();
    }

    private void inputFormulaMode() {
        this.btnAddStage.setEnabled(false);
        this.panelFormulaEdit.setVisible(true);
        this.panelFormulaCancel.setVisible(false);
        this.panelFormula.add(this.panelFormulaEdit);
    }

    public void addStage() {
        try {
            Hashtable hashtable = this.getMap();
            ObjectManager.setMachine.alteraEstagioAtual(hashtable);
            ObjectManager.setMachine.validaEstagioAtual();
            this.painelConstrucao.addStagePanel();
            this.close();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("AdicionaEstagio(" + ObjectManager.setMachine.getEstagioAtualId() + ")" + "$" + " " + ObjectManager.setMachine.getEstagioAtualTextoFormula());
            System.out.println("StagePanel.addStage(): " + stringBuffer);
            ObjectManager.getInstance().registraAcao(stringBuffer);
        }
        catch (RuntimeException runtimeException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("AdicionaEstagio$ " + ObjectManager.setMachine.getEstagioAtualTextoFormula() + "ERRO--->" + runtimeException.getMessage());
            ObjectManager.getInstance().registraAcao(stringBuffer);
            MessageFrame.showMessage(runtimeException.getMessage(), this.painelConstrucao);
        }
    }

    public void openChoosenFrame(Vector vector, int n) {
        this.listFrame.removeListeners();
        this.listFrame.changeModel(vector);
        if (n == 1) {
            this.listFrame.mark(this.strListElements1);
            this.listFrame.addListFrameListener(new IListFrameListener(){

                public void setStringList(String string) {
                    StagePanel.this.strListElements1 = string;
                    StagePanel.this.lblListElements1.setText(Util.translateSetString(string));
                    StagePanel.this.updateBtnVerify();
                    StagePanel.this.validate();
                }
            });
        } else if (n == 2) {
            this.listFrame.mark(this.strListElements2);
            this.listFrame.addListFrameListener(new IListFrameListener(){

                public void setStringList(String string) {
                    StagePanel.this.strListElements2 = string;
                    StagePanel.this.lblListElements2.setText(Util.translateSetString(string));
                    StagePanel.this.updateBtnVerify();
                    StagePanel.this.validate();
                }
            });
        }
        this.listFrame.setLocationRelativeTo(this);
        ((Component)this.listFrame).setVisible(true);
    }
}

