/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import base.MontaFace;
import icomb.events.ObjectManager;
import icomb.machine.SetMachine;
import icomb.ui.ConstructionPanel;
import icomb.ui.MessageFrame;
import icomb.ui.SetMachinePanel;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.I18n;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class NewStageButtonPanel
extends Panel
implements ItemListener,
ActionListener {
    private final ConstructionPanel pai;
    private final Label lblLabel;
    private final Button btnNewStage;
    private final Button btnIAmDone;
    private final Button btnEraseStage;
    private final Button btnResetConstruction;

    public NewStageButtonPanel(ConstructionPanel constructionPanel) {
        this.pai = constructionPanel;
        this.setLayout(new BorderLayout());
        this.setBackground(Configuracoes.CINZA);
        this.btnNewStage = ObjectManager.criaBotao(this, I18n.getString("newStage"), I18n.getString("newStage-dica"));
        this.btnIAmDone = ObjectManager.criaBotao(this, I18n.getString("iAmDone"), I18n.getString("iAmDone-dica"));
        this.btnEraseStage = ObjectManager.criaBotao(this, I18n.getString("eraseThisStage"), I18n.getString("eraseThisStage-dica"));
        this.btnResetConstruction = ObjectManager.criaBotao(this, I18n.getString("resetConstruction"), I18n.getString("resetConstruction-dica"));
        this.lblLabel = new Label(I18n.getString("stage"));
        this.lblLabel.setForeground(this.btnEraseStage.getForeground());
        Font font = new Font(this.btnEraseStage.getFont().getName(), this.btnEraseStage.getFont().getStyle(), 13);
        this.lblLabel.setFont(font);
        this.btnEraseStage.setEnabled(false);
        this.btnEraseStage.addActionListener(this);
        this.btnResetConstruction.setEnabled(false);
        this.btnResetConstruction.addActionListener(this);
        this.btnIAmDone.setEnabled(false);
        this.btnNewStage.setEnabled(ObjectManager.setMachine.getEstado() == SetMachine.ESTADO_CONSTRUCAO_INICIADA);
        Panel panel = new Panel(new FlowLayout());
        panel.add(this.lblLabel);
        panel.add(this.btnNewStage);
        panel.add(this.btnEraseStage);
        panel.add(this.btnResetConstruction);
        this.add((Component)panel, "West");
        Panel panel2 = new Panel(new FlowLayout());
        panel2.add(this.btnIAmDone);
        this.add((Component)panel2, "East");
        this.btnNewStage.addActionListener(this);
        this.btnIAmDone.addActionListener(this);
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH - 10, 30);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnResetConstruction) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ReiniciaConstrucao$");
            ObjectManager.getInstance().registraAcao(stringBuffer);
            ObjectManager.setMachine.reiniciaConstrucao();
            this.pai.apagaEstagioAtual();
            this.pai.addStagePanel();
            this.btnResetConstruction.setEnabled(false);
        } else if (actionEvent.getSource() == this.btnEraseStage) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ApagaEstagio$");
            ObjectManager.getInstance().registraAcao(stringBuffer);
            ObjectManager.setMachine.apagarEstagio();
            this.pai.apagaEstagioAtual();
            this.pai.addStagePanel();
        } else if (actionEvent.getSource() == this.btnNewStage) {
            ObjectManager.setMachine.mudaDic(I18n.getString("msgStgFirst"));
            this.btnNewStage.setEnabled(false);
            ObjectManager.setMachine.inicialEstagioAtual();
            this.pai.openStagePanel();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NovoEstagio$");
            ObjectManager.getInstance().registraAcao(stringBuffer);
            this.btnEraseStage.setEnabled(true);
            this.btnResetConstruction.setEnabled(true);
            this.pai.redraw();
            this.repaint();
        } else {
            if (ObjectManager.setMachine.isModoCriacao()) {
                try {
                    boolean bl = this.pai.criarExercicio();
                    String string = "";
                    if (bl) {
                        string = MontaFace.staticApplet ? I18n.getString("msgLMSsuc_sent") : I18n.getString("msgLMSsuc_store");
                    } else {
                        string = I18n.getString("msgLMSfail_sent");
                        System.err.println("Error: in NewStageButtonPanel.actionPerformed(...): " + string);
                        System.err.println("Error: in SetMachinePanel.criarExercicio(): " + SetMachinePanel.staticErrSent);
                    }
                    MessageFrame.showMessage(string, this.pai);
                }
                catch (Exception exception) {
                    System.err.println("Error: in SetMachinePanel.criarExercicio(): " + SetMachinePanel.staticErrSent);
                    MessageFrame.showMessage(exception.getMessage(), this.pai);
                    return;
                }
            }
            try {
                ObjectManager.setMachine.validaConstrucao();
                this.pai.validateConstruction();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ValidaConstrucao$");
                stringBuffer.append(I18n.getString(ObjectManager.setMachine.getOperacao()));
                ObjectManager.getInstance().registraAcao(stringBuffer);
                this.pai.redraw();
            }
            catch (RuntimeException runtimeException) {
                MessageFrame.showMessage(runtimeException.getMessage(), this.pai);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ValidaConstrucao$");
                stringBuffer.append(I18n.getString(ObjectManager.setMachine.getOperacao()));
                stringBuffer.append("ERRO--->" + runtimeException.getMessage());
                ObjectManager.getInstance().registraAcao(stringBuffer);
                return;
            }
        }
    }

    public String btnNewStage() {
        return this.btnNewStage.getLabel() + ", " + this.btnNewStage.isEnabled();
    }

    public void open() {
        this.btnNewStage.setEnabled(true);
        this.btnIAmDone.setEnabled(false);
        this.btnEraseStage.setEnabled(false);
    }

    public void habilitaBotao(boolean bl) {
        this.btnIAmDone.setEnabled(bl);
    }

    public void enabledResetConstruction(boolean bl) {
        this.btnResetConstruction.setEnabled(bl);
    }

    public void criarExercicio() {
        this.pai.criarExercicio();
    }
}

