/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import base.MontaFace;
import icomb.events.ObjectManager;
import icomb.objects.Element;
import icomb.objects.Universo;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.GerenciadorRecursos;
import icomb.util.I18n;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class DrawingPanel
extends Panel
implements MouseListener {
    private static int staticID = 0;
    private int ID = staticID++;
    private Universo universo = null;
    private Element[] handElement;
    private Image[] handImage;
    private final MontaFace mf;
    private boolean mouseOver = false;
    private Graphics goff;
    private Image offscreen;
    private boolean pinta = true;
    private static int count = 0;

    public static int SgetID() {
        return staticID;
    }

    public int getID() {
        return this.ID;
    }

    public DrawingPanel(MontaFace montaFace) {
        System.out.println("\n\nDrawingPanel.DrawingPanel");
        for (Container container = this; container != null; container = container.getParent()) {
            System.out.println(" - " + container);
        }
        if (montaFace == null) {
            System.err.println("DrawingPanel.DrawingPanel: Error: MontaFace mf empty: " + montaFace + " ------------- ");
        }
        this.mf = montaFace;
        this.addMouseListener(this);
        this.recalcula();
    }

    public void recalcula() {
        if (ObjectManager.setMachine.getUniverso() == null) {
            this.handElement = new Element[0];
        } else {
            this.universo = ObjectManager.setMachine.getUniverso();
            this.handElement = this.universo.getPossivelColecao(ObjectManager.setMachine.getEstagiosParaDesenhar());
        }
    }

    public void myPaint() {
        System.out.print(".");
        this.pinta = true;
        this.update(this.goff);
    }

    public void repaint() {
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getWidth(), this.getHeight());
        }
        this.goff = this.offscreen.getGraphics();
        if (this.goff == null || this.offscreen == null) {
            System.err.println("icomb/ui/DrawingPanel.java: Error: update(Graphics g): goff==null || offscreen==null: " + this.goff + "," + this.offscreen);
            return;
        }
        if (this.handElement == null || this.handElement.length == 0) {
            this.recalcula();
        }
        if (this.handElement.length > 0 && this.mouseOver) {
            this.goff.setColor(new Color(255, 255, 128));
        } else {
            this.goff.setColor(Color.WHITE);
        }
        this.goff.fillRect(2, 2, this.getWidth() - 4, this.getSize().height - 19);
        this.goff.setColor(new Color(180, 180, 180));
        this.goff.drawRect(2, 2, this.getWidth() - 4, this.getSize().height - 19);
        int n = 3;
        int n2 = 3;
        String string = "";
        String string2 = "";
        Universo universo = this.universo;
        if (universo == null) {
            this.universo = universo = ObjectManager.setMachine.getUniverso();
        }
        if (universo != null) {
            string = universo.getArquivo();
            string2 = string.substring(0, string.lastIndexOf("/")) + "/imagens/";
        }
        if (this.handElement.length > 0 && this.mouseOver) {
            this.goff.setColor(Configuracoes.FACE_DARK1);
            this.goff.drawString(I18n.getString("drawingClickImage1"), 3, 120);
        }
        String string3 = "";
        for (int i = 0; i < this.handElement.length; ++i) {
            try {
                string3 = string2 + this.handElement[i].getImagem();
                Image image = GerenciadorRecursos.getImagem(this.mf, string3);
                if (image == null) {
                    System.err.println("Error: in 'DrawingPanel.paint': " + string3);
                    continue;
                }
                if (n + image.getWidth(this) > Constants.PANEL_WIDTH) {
                    n = 3;
                    n2 += image.getHeight(this);
                }
                this.goff.drawImage(image, n, n2, image.getWidth(this), image.getHeight(this), this);
                n += image.getWidth(this);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error: failed in image drawing " + i + ": " + string3 + ": " + exception);
                exception.printStackTrace();
            }
        }
        if (graphics != null && this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        } else {
            System.err.println("icomb/ui/DrawingPanel.java: Error: update(Graphics g): g==null || offscreen==null: " + graphics + "," + this.offscreen);
        }
        this.pinta = false;
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH, 125);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.handElement.length > 0) {
            this.recalcula();
            this.pinta = true;
            this.myPaint();
            this.pinta = false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.recalcula();
        this.pinta = true;
        this.myPaint();
        this.pinta = false;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.pinta = true;
        this.myPaint();
        this.pinta = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

