/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import ajuda.Help;
import icomb.events.ObjectManager;
import icomb.machine.SetMachine;
import icomb.ui.SetMachinePanel;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.I18n;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DefinedExercisePanel
extends Panel
implements ActionListener {
    private String title;
    private final TextArea label;
    private final SetMachinePanel painelSetMachine;
    private final Button btnIniciar;
    private final Button btnAjuda;
    private final Button btnBack;

    public void setEnabled() {
        this.btnIniciar.setEnabled(true);
    }

    public void setDisabled() {
        this.btnIniciar.setEnabled(false);
    }

    public DefinedExercisePanel(SetMachinePanel setMachinePanel) {
        this.painelSetMachine = setMachinePanel;
        this.setLayout(new BorderLayout());
        String string = "";
        if (ObjectManager.setMachine.getExercicioAtual() != null) {
            string = ObjectManager.setMachine.getExercicioAtual().getLongDescription();
        }
        this.label = new TextArea(string, 2, 5, 3);
        this.label.setBackground(new Color(255, 255, 128));
        this.label.setForeground(Color.BLACK);
        this.label.setEditable(false);
        this.setBackground(Configuracoes.corBarraSupInf);
        Panel panel = new Panel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        panel.setBackground(Configuracoes.corBarraSupInf);
        panel.add((Component)this.label, "Center");
        this.add((Component)panel, "Center");
        Panel panel2 = new Panel(new BorderLayout());
        panel2.setBackground(Configuracoes.corBarraSupInf);
        this.btnIniciar = ObjectManager.criaBotao(panel2, I18n.getString("startExercise"), I18n.getString("startExercise-dica"));
        if (ObjectManager.setMachine.getEstado() == SetMachine.ESTADO_CONSTRUCAO_FINALIZADA) {
            this.btnIniciar.setEnabled(false);
        } else {
            this.btnIniciar.setEnabled(true);
        }
        this.btnIniciar.addActionListener(this);
        System.out.println("DefinedExercisePanel: btnIniciar.isEnabled=" + this.btnIniciar.isEnabled());
        this.btnAjuda = ObjectManager.criaBotao(panel2, I18n.getString("help"), I18n.getString("help-dica"));
        this.btnAjuda.addActionListener(this);
        this.btnBack = ObjectManager.criaBotao(panel2, I18n.getString("back2start"), I18n.getString("back2start-dica"));
        this.btnBack.addActionListener(this);
        Panel panel3 = new Panel(new BorderLayout());
        panel3.setBackground(Configuracoes.corBarraSupInf);
        panel3.add((Component)this.btnAjuda, "South");
        panel2.add((Component)this.btnIniciar, "North");
        panel2.add((Component)panel3, "Center");
        panel2.add((Component)this.btnBack, "South");
        this.add((Component)panel2, "East");
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH, 100);
    }

    public void paint(Graphics graphics) {
        if (ObjectManager.setMachine.getExercicioAtual() != null) {
            this.label.setText(ObjectManager.setMachine.getExercicioAtual().getLongDescription());
        }
        graphics.setColor(Color.white);
        graphics.drawString(I18n.getString("exercises"), 5, 15);
        graphics.setColor(Color.black);
        graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
    }

    public Insets getInsets() {
        return new Insets(20, 5, 5, 5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnBack) {
            ObjectManager.setMachine.reinicia();
            this.painelSetMachine.redraw();
        } else if (actionEvent.getSource() == this.btnAjuda) {
            Help help = new Help();
        } else {
            this.btnIniciar.setEnabled(false);
            ObjectManager.setMachine.confirmaExercicio();
            String string = "Acione o bot\u00e3o \"Novo Est\u00e1gio\" para iniciar constru\u00e7\u00e3o. Para ver detalhes do Universo acione o bot\u00e3o \"Mostrar Universo\" ao lado. O bot\u00e3o \"Ajuda\" abrir\u00e1 o sistema de Help do iComb.";
            ObjectManager.setMachine.mudaDic(string);
            ObjectManager.setMachine.loadUniverso(this.painelSetMachine.getMf());
            this.painelSetMachine.habilitarNovoEstagio();
        }
    }
}

