/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import icomb.events.ObjectManager;
import icomb.ui.ConstructionPanel;
import icomb.ui.MessageFrame;
import icomb.util.Constants;
import icomb.util.I18n;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ConstructionFooterPanel
extends Panel
implements ItemListener,
ActionListener {
    private static final int ALT = 24;
    private ConstructionPanel pai;
    private Button btnIAmDone;

    public ConstructionFooterPanel(ConstructionPanel constructionPanel) {
        this.pai = constructionPanel;
        this.setLayout(new FlowLayout(2));
        this.btnIAmDone = ObjectManager.criaBotao(this, I18n.getString("iAmDone"), I18n.getString("iAmDone-dica"));
        this.btnIAmDone.addActionListener(this);
        this.btnIAmDone.setEnabled(false);
        this.add(this.btnIAmDone);
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH - 10, 24);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (ObjectManager.setMachine.isModoCriacao()) {
            try {
                this.pai.criarExercicio();
                MessageFrame.showMessage("Exerc\u00edcio enviado com sucesso!", this.pai);
            }
            catch (Exception exception) {
                MessageFrame.showMessage(exception.getMessage(), this.pai);
                return;
            }
        }
        try {
            ObjectManager.setMachine.validaConstrucao();
            this.pai.validateConstruction();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ValidaConstrucao$");
            stringBuffer.append(I18n.getString(ObjectManager.setMachine.getOperacao()));
            ObjectManager.getInstance().registraAcao(stringBuffer);
            this.pai.redraw();
        }
        catch (RuntimeException runtimeException) {
            MessageFrame.showMessage(runtimeException.getMessage(), this.pai);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ValidaConstrucao$");
            stringBuffer.append(I18n.getString(ObjectManager.setMachine.getOperacao()));
            stringBuffer.append("ERRO--->" + runtimeException.getMessage());
            ObjectManager.getInstance().registraAcao(stringBuffer);
            return;
        }
    }

    public void habilitaBotao(boolean bl) {
        this.btnIAmDone.setEnabled(bl);
    }

    public boolean criarExercicio() {
        return this.pai.criarExercicio();
    }
}

