/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import icomb.components.CustomChoice;
import icomb.events.ObjectManager;
import icomb.objects.Universo;
import icomb.ui.MessageFrame;
import icomb.ui.SetMachinePanel;
import icomb.ui.UniversoFrame;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.GerenciadorRecursos;
import icomb.util.I18n;
import icomb.util.Parse;
import icomb.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ChooseUniversePanel
extends Panel
implements ActionListener {
    private String title;
    private final CustomChoice choiceNumbers;
    private CustomChoice choiceUniverses;
    private final TextArea txtArea;
    private final SetMachinePanel pai;
    private final Button btnMudarUniverso;
    private final Button btnHelp;

    public ChooseUniversePanel(SetMachinePanel setMachinePanel) {
        this.pai = setMachinePanel;
        Panel panel = new Panel(new FlowLayout(0));
        panel.setBackground(Configuracoes.corBarraSupInf);
        this.choiceNumbers = ObjectManager.criaCombo(panel, Util.getListNumbers(50), I18n.getString("choiceNumbers-dica"));
        this.setLayout(new BorderLayout());
        this.txtArea = new TextArea(ObjectManager.setMachine.getDica(), 2, 5, 3);
        this.txtArea.setBackground(Configuracoes.COR_DICA);
        this.txtArea.setForeground(Color.BLACK);
        this.txtArea.setEditable(false);
        panel.add(this.txtArea);
        Panel panel2 = new Panel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        panel2.add((Component)this.txtArea, "Center");
        panel2.setBackground(Configuracoes.corBarraSupInf);
        this.add((Component)panel2, "Center");
        this.setBackground(Configuracoes.corBarraSupInf);
        Panel panel3 = new Panel(new BorderLayout());
        panel3.setBackground(Configuracoes.corBarraSupInf);
        this.btnMudarUniverso = ObjectManager.criaBotao(panel3, I18n.getString("solve"), I18n.getString("solve-dica"));
        this.btnMudarUniverso.addActionListener(this);
        panel3.add((Component)this.btnMudarUniverso, "North");
        this.btnHelp = ObjectManager.criaBotao(panel3, I18n.getString("help"), I18n.getString("help-dica"));
        this.btnHelp.addActionListener(this);
        this.add((Component)panel3, "East");
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH, 80);
    }

    public void paint(Graphics graphics) {
        this.txtArea.setText(ObjectManager.setMachine.getDica());
        graphics.setColor(Color.white);
        graphics.drawString(I18n.getString("help"), 5, 15);
        graphics.setColor(Color.black);
        graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
    }

    public Insets getInsets() {
        return new Insets(20, 5, 5, 5);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("\n---------------------\nsrc/icomb/ui/ChooseUniversePanel: " + actionEvent.getSource() + ", " + this.btnMudarUniverso + " ******************* ");
        if (actionEvent.getSource() == this.btnMudarUniverso) {
            String string = "Acione o bot\u00e3o \"Novo Est\u00e1gio\" para iniciar constru\u00e7\u00e3o. Para ver detalhes do Universo acione o bot\u00e3o \"Mostrar Universo\" ao lado. O bot\u00e3o \"Ajuda\" abrir\u00e1 o sistema de Help do iComb.";
            ObjectManager.setMachine.mudaDic(string);
            this.pai.redraw();
        } else if (actionEvent.getSource() == this.btnHelp) {
            String string = this.choiceNumbers.getSelectedKey();
            String string2 = this.choiceUniverses.getSelectedKey();
            String string3 = this.choiceUniverses.getSelectedItem();
            Universo universo = null;
            try {
                universo = Parse.parseUniverso(GerenciadorRecursos.getInputStream(this.pai.getMf(), string2), string2);
            }
            catch (Exception exception) {
                String string4 = I18n.getString("invalid_universe");
                MessageFrame.showMessage(string4, this.pai);
                System.err.println("Erro: " + string4 + ": " + exception);
                return;
            }
            universo.setNome(string3);
            universo.setArquivo("icomb/", string2);
            UniversoFrame universoFrame = new UniversoFrame(this.pai.getMf());
            universoFrame.setUniverso(universo);
            ((Component)universoFrame).setVisible(true);
        }
    }
}

