/*
 * Decompiled with CFR 0.152.
 */
package icomb.objects;

import icomb.objects.Condicao;
import icomb.objects.Element;
import icomb.objects.Estagio;
import icomb.objects.Expressao;
import icomb.objects.SetElement;
import icomb.util.Util;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Universo {
    private Set attributes;
    private Hashtable predicates;
    private Vector elementos = new Vector();
    private String nome;
    private String arquivo;
    private String directory;

    public String getArquivo() {
        return this.arquivo;
    }

    public String getDirectory() {
        return this.directory;
    }

    private static String clearDirectoryFromName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public void setArquivo(String string, String string2) {
        System.out.println("Universo.java: setArquivo: directory=" + string + "->" + this.directory + ", arquivo=" + string2);
        this.arquivo = string2;
        this.directory = Universo.clearDirectoryFromName(string2) + "/imagens/";
        System.out.println("Universo.java: setArquivo: this.directory=" + this.directory);
    }

    public Universo() {
        this.attributes = new HashSet();
        this.predicates = new Hashtable();
    }

    public Vector getElementos() {
        return this.elementos;
    }

    public Vector getPredicados(String string) {
        Set set = (Set)this.predicates.get(string);
        Vector<String> vector = new Vector<String>();
        vector.add("");
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                vector.add((String)iterator.next());
            }
        }
        return vector;
    }

    public Vector getAtributos() {
        Vector<String> vector = new Vector<String>();
        vector.add("");
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            vector.add((String)iterator.next());
        }
        return vector;
    }

    public void addElemento(Element element) {
        Set set = element.getAttributes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = element.getAttribute(string);
            this.addAtributo(string, string2, element.getPredicates(string));
        }
        this.elementos.add(element);
    }

    private void addAtributo(String string, String string2, Set set) {
        Vector vector = new Vector();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        this.addAtributo(string, string2, vector);
    }

    private void addAtributo(String string, String string2, Vector vector) {
        this.attributes.add(string);
        if (vector == null) {
            return;
        }
        HashSet<String> hashSet = (HashSet<String>)this.predicates.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        hashSet.add(string2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                hashSet.add((String)vector.get(i));
            }
        }
        this.predicates.put(string, hashSet);
    }

    public Element[] getPossivelColecao(Vector vector) {
        Object object;
        Element[] elementArray;
        Object object2;
        int n;
        SetElement setElement = new SetElement(this.elementos.size());
        int n2 = 0;
        for (int i = 0; i < this.elementos.size(); ++i) {
            setElement.addElement(n2++, (Element)this.elementos.get(i));
        }
        Vector<Object> vector2 = new Vector<Object>();
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Estagio estagio = (Estagio)vector.get(i);
            n = estagio.getNElementos();
            object2 = new Expressao[estagio.getNPropriedades()];
            for (int j = 0; j < estagio.getNPropriedades(); ++j) {
                if (j == 0) {
                    elementArray = Util.produceStringSet(estagio.getElemento1());
                    object2[j] = new Expressao(estagio.getAtributo1(), estagio.getRelacao1().equals("is") || estagio.getRelacao1().equals("isIn"), (Set)elementArray);
                    continue;
                }
                elementArray = Util.produceStringSet(estagio.getElemento2());
                object2[j] = new Expressao(estagio.getAtributo2(), estagio.getRelacao2().equals("is") || estagio.getRelacao2().equals("isIn"), (Set)elementArray);
            }
            object = new HashSet();
            object = setElement.extract(n, (Expressao[])object2);
            n3 += object.size();
            vector2.add(object);
        }
        Element[] elementArray2 = new Element[n3];
        int n4 = 0;
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Set)vector2.get(n);
            object = object2.iterator();
            elementArray = new Element[object2.size()];
            int n5 = 0;
            while (object.hasNext()) {
                Element element = (Element)object.next();
                elementArray[n5++] = element;
            }
            this.permutacao(elementArray);
            for (int i = 0; i < elementArray.length; ++i) {
                elementArray2[n4++] = elementArray[i];
            }
        }
        return elementArray2;
    }

    public void permutacao(Element[] elementArray) {
        for (int i = 0; i < elementArray.length; ++i) {
            int n = (int)(Math.random() * (double)elementArray.length);
            Element element = elementArray[n];
            elementArray[n] = elementArray[i];
            elementArray[i] = element;
        }
    }

    public boolean compativel(Condicao[] condicaoArray) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = this.predicates.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            treeSet.addAll((Set)this.predicates.get(string));
        }
        for (int i = 0; i < condicaoArray.length; ++i) {
            Condicao condicao = condicaoArray[i];
            Vector vector = condicao.getExpressoes();
            for (int j = 0; j < vector.size(); ++j) {
                Expressao expressao = (Expressao)vector.get(j);
                String string = expressao.getAttributeName();
                Set set = expressao.getElements();
                if (!this.attributes.contains(string)) {
                    return false;
                }
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (treeSet.contains(string2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Condicao[] interpretaCondicao(String string) {
        int n;
        Condicao[] condicaoArray;
        if (string == null || string == "") {
            return null;
        }
        Pattern pattern = null;
        Matcher matcher = null;
        try {
            pattern = Pattern.compile("([^;]*)");
            matcher = pattern.matcher(string);
        }
        catch (Exception exception) {
            System.err.println("Erro: em universo, ao tentar tratar condicao " + string + ": " + exception);
        }
        if (matcher == null) {
            return null;
        }
        Vector<Condicao> vector = new Vector<Condicao>();
        while (matcher.find()) {
            condicaoArray = matcher.group(0);
            n = condicaoArray.indexOf(":");
            if (n <= 0) continue;
            String string2 = condicaoArray.substring(0, n);
            Condicao condicao = new Condicao(Integer.parseInt(string2));
            String string3 = condicaoArray.substring(n + 1);
            Pattern pattern2 = Pattern.compile("([^ #=]*)([#=])(\\{[^\\}]*\\})");
            Matcher matcher2 = pattern2.matcher(string3);
            while (matcher2.find()) {
                String string4 = matcher2.group(1);
                String string5 = matcher2.group(2);
                String string6 = matcher2.group(3);
                Expressao expressao = new Expressao(string4, string5.equals("="), Util.produceStringSet(string6));
                condicao.addExpressao(expressao);
            }
            vector.add(condicao);
        }
        condicaoArray = new Condicao[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            condicaoArray[n] = (Condicao)vector.get(n);
        }
        return condicaoArray;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String string) {
        this.nome = string;
    }
}

