/*
 * Decompiled with CFR 0.152.
 */
package icomb.objects;

import icomb.formula.Formula;
import icomb.objects.Condicao;
import icomb.objects.Expressao;
import icomb.util.I18n;
import icomb.util.Util;
import java.util.Hashtable;

public class Estagio {
    private static int static_cont = 0;
    private int cont = static_cont++;
    private String atributo1;
    private String relacao1;
    private String elemento1;
    private String atributo2;
    private String relacao2;
    private String elemento2;
    private int nElementos;
    private int nPropriedades;
    private String propriedades;
    private Formula formula;
    private int n;
    private int p;

    public int getCont() {
        return this.cont;
    }

    public void alimentaEstagio(Hashtable hashtable) {
        this.nElementos = Integer.parseInt("" + hashtable.get("cboNElementos"));
        this.propriedades = (String)hashtable.get("cboPropOptions");
        this.nPropriedades = this.propriedades.equals("oneProperty") ? 1 : (this.propriedades.startsWith("twoProperties") ? 2 : 0);
        this.atributo1 = (String)hashtable.get("cboAttributes1");
        this.relacao1 = (String)hashtable.get("cboRelations1");
        this.elemento1 = (String)hashtable.get("cboElements1");
        this.atributo2 = (String)hashtable.get("cboAttributes2");
        this.relacao2 = (String)hashtable.get("cboRelations2");
        this.elemento2 = (String)hashtable.get("cboElements2");
    }

    public String getAtributo1() {
        return this.atributo1;
    }

    public String getAtributo2() {
        return this.atributo2;
    }

    public String getElemento1() {
        return this.elemento1;
    }

    public String getElemento2() {
        return this.elemento2;
    }

    public int getNElementos() {
        return this.nElementos;
    }

    public int getNPropriedades() {
        return this.nPropriedades;
    }

    public String getPropriedades() {
        return this.propriedades;
    }

    public String getRelacao1() {
        return this.relacao1;
    }

    public String getRelacao2() {
        return this.relacao2;
    }

    public Condicao criaCondicao() {
        Expressao expressao;
        boolean bl;
        Condicao condicao = new Condicao(this.getNElementos());
        if (this.getNPropriedades() >= 1) {
            bl = this.relacao1.equals("isIn") || this.relacao1.equals("is");
            expressao = new Expressao(this.atributo1, bl, Util.produceStringSet(this.elemento1));
            condicao.addExpressao(expressao);
        }
        if (this.getNPropriedades() >= 2) {
            bl = this.relacao2.equals("isIn") || this.relacao2.equals("is");
            expressao = new Expressao(this.atributo2, bl, Util.produceStringSet(this.elemento2));
            condicao.addExpressao(expressao);
        }
        return condicao;
    }

    public void defineNeP(int n, int n2) {
        this.n = n;
        this.p = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("nElements :" + this.nElementos);
        stringBuffer.append("nProperties :" + this.nPropriedades);
        stringBuffer.append("attribute1: " + this.atributo1);
        stringBuffer.append("relation1: " + this.relacao1);
        stringBuffer.append("element1: " + this.elemento1);
        stringBuffer.append("attribute2: " + this.atributo2);
        stringBuffer.append("relation2: " + this.relacao2);
        stringBuffer.append("element2: " + this.elemento2);
        return stringBuffer.toString();
    }

    public String getDescricao() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nElementos + " " + I18n.getString("elements"));
        if (this.nPropriedades >= 1) {
            stringBuffer.append(" " + I18n.getString("suchThat") + " " + I18n.getString(this.atributo1) + " " + I18n.getString(this.relacao1) + " " + Util.translateSetString(this.elemento1));
        }
        if (this.nPropriedades == 2) {
            stringBuffer.append(" " + I18n.getString("and") + " " + I18n.getString(this.atributo2) + " " + I18n.getString(this.relacao2) + " " + Util.translateSetString(this.elemento2));
        }
        stringBuffer.append(" ");
        System.out.println("Estagio.getDescricao(): cont=" + this.cont + ": " + stringBuffer);
        return stringBuffer.toString();
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public String getTextoFormula() {
        String string = this.formula.getNome();
        if (string.equals("value")) {
            return "" + this.n;
        }
        string = string.replaceAll("n", "" + this.n);
        string = string.replaceAll("p", "" + this.p);
        return string;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public int getN() {
        return this.n;
    }

    public int getP() {
        return this.p;
    }

    public long getValorFinal() {
        return this.formula.calcula(this.n, this.p);
    }
}

