/*
 * Decompiled with CFR 0.152.
 */
package icomb.machine;

import base.MontaFace;
import icomb.IComb;
import icomb.erro.Avaliador;
import icomb.events.ObjectManager;
import icomb.formula.Formula;
import icomb.objects.Condicao;
import icomb.objects.Estagio;
import icomb.objects.Exercicio;
import icomb.objects.Universo;
import icomb.ui.MessageFrame;
import icomb.util.GerenciadorRecursos;
import icomb.util.I18n;
import icomb.util.Parse;
import java.util.Hashtable;
import java.util.Vector;

public class SetMachine {
    private static int contadorStatic = 0;
    public int contador = contadorStatic++;
    public static int ESTADO_INICIAL = 0;
    public static int ESTADO_ESCOLHENDO_EXERCICIO = 1;
    public static int ESTADO_EXERCICIO_CONFIRMADO = 2;
    public static int ESTADO_CRIANDO_EXERCICIO = -1;
    public static int ESTADO_CONSTRUCAO_INICIADA = 3;
    public static int ESTADO_EDITANDO_ESTAGIO = 4;
    public static int ESTADO_EDITANDO_FORMULA = 5;
    public static int ESTADO_FORMULA_DEFINIDA = 6;
    public static int ESTADO_OPERACAO_DEFINIDA = 7;
    public static int ESTADO_VALIDA_CONSTRUCAO = 8;
    public static int ESTADO_CONSTRUCAO_FINALIZADA = 9;
    private boolean modoCriacao = false;
    private int estado;
    private Exercicio exercicioAtual;
    private int nElementos;
    private Estagio estagioAtual;
    private Estagio estagioAuxiliar;
    private Formula formulaAtual;
    private Vector estagios;
    private String operacao;
    private String directory;
    private String arquivoUniverso;
    private String dica;
    private boolean corrige;
    private Universo universo;
    private Avaliador avaliador;
    private boolean online;
    private String respostaEnviada;

    public void setOnline(boolean bl) {
        this.online = bl;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isModoCriacao() {
        return this.modoCriacao;
    }

    public static Exercicio[] getExercicios() {
        I18n i18n = I18n.getInstance();
        Exercicio[] exercicioArray = new Exercicio[10];
        for (int i = 0; i < exercicioArray.length; ++i) {
            exercicioArray[i] = new Exercicio(i + 1);
        }
        return exercicioArray;
    }

    public SetMachine() {
        this.reinicia();
    }

    public void setExerciseInitiated() {
        this.estado = ESTADO_EXERCICIO_CONFIRMADO;
    }

    public boolean isExerciseInitiated() {
        return this.estado == ESTADO_EXERCICIO_CONFIRMADO;
    }

    public int getEstado() {
        return this.estado;
    }

    public void iniciar() {
        this.estado = ESTADO_INICIAL;
    }

    public void reinicia() {
        this.estagioAuxiliar = null;
        this.exercicioAtual = null;
        this.estagioAtual = null;
        this.operacao = null;
        this.formulaAtual = null;
        this.estagios = new Vector();
        this.estado = ESTADO_INICIAL;
    }

    public void setExercicio(Exercicio exercicio) {
        this.exercicioAtual = exercicio;
        this.estagioAtual = null;
        this.operacao = null;
        this.formulaAtual = null;
        this.estagios = new Vector();
        this.estado = ESTADO_EXERCICIO_CONFIRMADO;
    }

    public void reiniciaConstrucao() {
        this.exercicioAtual = null;
        this.estagioAtual = null;
        this.operacao = null;
        this.formulaAtual = null;
        this.estagios = new Vector();
        this.estado = ESTADO_CONSTRUCAO_INICIADA;
    }

    public void notExerciseCreation() {
        this.modoCriacao = false;
    }

    public void confirmaExercicio() {
        this.estado = ESTADO_EXERCICIO_CONFIRMADO;
    }

    public Exercicio getExercicioAtual() {
        return this.exercicioAtual;
    }

    public void inicialEstagioAtual() {
        this.estagioAtual = new Estagio();
        this.estado = ESTADO_EDITANDO_ESTAGIO;
    }

    public void criandoExercicio() {
        this.estado = ESTADO_CRIANDO_EXERCICIO;
        this.modoCriacao = true;
    }

    public void alteraEstagioAtual(Hashtable hashtable) {
        this.estagioAtual.alimentaEstagio(hashtable);
    }

    public void alimentaEstagioAuxiliar(Hashtable hashtable) {
        this.estagioAuxiliar = new Estagio();
        this.estagioAuxiliar.alimentaEstagio(hashtable);
    }

    public boolean estagioAtualEstaDefinido() {
        return this.estagioAtual != null;
    }

    public int getEstagioAtualId() {
        if (this.estagioAtual == null) {
            throw new RuntimeException("Estagio atual n\u00e3o definido!");
        }
        return this.estagioAtual.hashCode();
    }

    public int getEstagioAtualN() {
        if (this.estagioAtual == null) {
            throw new RuntimeException("Estagio atual n\u00e3o definido!");
        }
        return this.estagioAtual.getN();
    }

    public int getEstagioAtualP() {
        if (this.estagioAtual == null) {
            throw new RuntimeException("Estagio atual n\u00e3o definido!");
        }
        return this.estagioAtual.getP();
    }

    public String getEstagioAtualTextoFormula() {
        if (this.estagioAtual == null) {
            throw new RuntimeException("Estagio atual n\u00e3o definido!");
        }
        return this.estagioAtual.getTextoFormula();
    }

    public void setFormulaAtual(String string) {
        System.out.println("SetMachine.setFormulaAtual -------------------- " + string);
        this.formulaAtual = Formula.getStaticMapFormula(string);
        this.estado = ESTADO_EDITANDO_FORMULA;
    }

    public void validaEstagioAtual() {
        this.estagioAtual.setFormula(this.formulaAtual);
        if (this.corrige) {
            Avaliador.deteccaoDeErroFormula(this.universo, this.estagioAtual);
        }
        this.estagioAuxiliar = null;
        this.estagios.add(this.estagioAtual);
        System.out.println("\nSetMachine.java: validaEstagioAtual(): #estagios=" + this.estagios.size());
    }

    public void defineNeP(String string, String string2) {
        int n = -1;
        int n2 = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (this.estagioAtual != null) {
            this.estagioAtual.defineNeP(n, n2);
        }
        this.estado = ESTADO_FORMULA_DEFINIDA;
    }

    public boolean formulaAtualEstaDefinida() {
        return this.formulaAtual != null;
    }

    public boolean formulaAtualTemParametroN() {
        if (this.formulaAtual == null) {
            throw new RuntimeException("Formula n\u00e3o est\u00e1 definida!");
        }
        return this.formulaAtual.temParametroN();
    }

    public boolean formulaAtualTemParametroP() {
        if (this.formulaAtual == null) {
            throw new RuntimeException("Formula n\u00e3o est\u00e1 definida!");
        }
        return this.formulaAtual.temParametroP();
    }

    public String getNomeFormulaAtual() {
        if (this.formulaAtual == null) {
            throw new RuntimeException("Formula n\u00e3o est\u00e1 definida!");
        }
        return this.formulaAtual.getNome();
    }

    public Vector getEstagios() {
        return this.estagios;
    }

    public void apagarEstagio() {
        this.estagioAuxiliar = null;
    }

    public Vector getEstagiosParaDesenhar() {
        Vector vector = (Vector)this.estagios.clone();
        if (this.estagioAuxiliar != null) {
            vector.add(this.estagioAuxiliar);
        }
        return vector;
    }

    public void setOperacao(String string) {
        if (string != null) {
            this.operacao = string;
        }
        this.estado = ESTADO_OPERACAO_DEFINIDA;
    }

    public void defineResposta(String string) {
        this.respostaEnviada = string;
        this.estado = ESTADO_CONSTRUCAO_FINALIZADA;
    }

    public String getExpressaoFinal() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.estagios.size(); ++i) {
            Estagio estagio = (Estagio)this.estagios.get(i);
            String string = estagio.getFormula().temParametroP() ? estagio.getTextoFormula() : estagio.getTextoFormula();
            if (i == 0) {
                stringBuffer.append(string);
                continue;
            }
            if (this.operacao == null) continue;
            if (this.operacao.equals("add")) {
                stringBuffer.append(" + " + string);
                continue;
            }
            if (!this.operacao.equals("multiply")) continue;
            stringBuffer.append(" * " + string);
        }
        return stringBuffer.toString();
    }

    public long getResultadoFinal() {
        long l = 0L;
        if (this.operacao == null) {
            return 0L;
        }
        if (this.operacao.equals("multiply")) {
            l = 1L;
        }
        for (int i = 0; i < this.estagios.size(); ++i) {
            Estagio estagio = (Estagio)this.estagios.get(i);
            long l2 = 0L;
            l2 = estagio.getFormula().temParametroP() ? estagio.getFormula().calcula(estagio.getN(), estagio.getP()) : estagio.getFormula().calcula(estagio.getN());
            if (this.operacao.equals("add")) {
                l += l2;
                continue;
            }
            if (!this.operacao.equals("multiply")) continue;
            l *= l2;
        }
        return l;
    }

    public String toFormatoReduzido() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.estagios.size(); ++i) {
            Estagio estagio = (Estagio)this.estagios.get(i);
            Condicao condicao = estagio.criaCondicao();
            String string = condicao.toFormatoReduzido();
            if (i == 0) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(";" + string);
        }
        return stringBuffer.toString();
    }

    public String getEstagioString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.estagios.size(); ++i) {
            Estagio estagio = (Estagio)this.estagios.get(i);
            long l = 0L;
            l = estagio.getFormula().temParametroP() ? estagio.getFormula().calcula(estagio.getN(), estagio.getP()) : estagio.getFormula().calcula(estagio.getN());
            if (i == 0) {
                stringBuffer.append(l);
                continue;
            }
            stringBuffer.append(" ; " + l);
        }
        return stringBuffer.toString();
    }

    public String getOperacaoTexto() {
        String string = this.getEstagioString();
        if (this.operacao == null) {
            return string;
        }
        if (this.operacao.equals("add")) {
            return string.replaceAll(";", "+");
        }
        if (this.operacao.equals("multiply")) {
            return string.replaceAll(";", "*");
        }
        return string;
    }

    public String getOperacao() {
        return this.operacao;
    }

    public void finaliza() {
        this.estado = ESTADO_CONSTRUCAO_FINALIZADA;
    }

    public int getAvaliacao() {
        if (this.estado != ESTADO_VALIDA_CONSTRUCAO) {
            return -1;
        }
        try {
            this.verificaResposta();
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    public String getAnswer() {
        return this.getConjuntoEstagioString().toString();
    }

    public String montaResposta() {
        int n = ObjectManager.setMachine.getAvaliacao();
        String string = ObjectManager.setMachine.getAnswer();
        String string2 = ObjectManager.getInstance().tracePilhaDeAcoes();
        if (n > 0) {
            return string + "\n" + "RESPOSTA CORRETA!" + "\n" + string2;
        }
        return string + "\n" + "RESPOSTA INCORRETA!" + "\n" + string2;
    }

    public String getStringFinal() {
        if (this.respostaEnviada != null) {
            return this.respostaEnviada;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(I18n.getString("hereIsYourSolution")).append("\n\n").append(I18n.getString("universe")).append("\n").append(I18n.getString("theSetOfSubsetsWith")).append(this.nElementos).append(I18n.getString("elementsTakenIn")).append(I18n.getString(this.universo.getNome())).append("\n\n").append(I18n.getString("construction")).append("\n").append(this.getConjuntoEstagioString());
        return stringBuffer.toString();
    }

    public String getConjuntoEstagioString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getEstagios() != null && this.getEstagios().size() > 0) {
            for (int i = 0; i < this.getEstagios().size(); ++i) {
                Estagio estagio = (Estagio)this.getEstagios().get(i);
                stringBuffer.append(estagio.getDescricao());
                stringBuffer.append(I18n.getString("numberOfPossibilities") + ":" + estagio.getTextoFormula() + "=" + estagio.getValorFinal() + "\n");
            }
            stringBuffer.append("\n" + I18n.getString("numberOfPossibilities") + ":" + this.getExpressaoFinal() + "=" + this.getResultadoFinal());
        }
        return stringBuffer.toString();
    }

    public void setNElementos(int n) {
        this.nElementos = n;
    }

    public void defineDica(String string) {
        this.dica = string;
        if (ObjectManager.getInstance().getSetMachinePanel() != null) {
            ObjectManager.getInstance().getSetMachinePanel().drawDica();
        }
    }

    public void mudaDic(String string) {
        if (this.modoCriacao) {
            return;
        }
        this.dica = string;
        if (ObjectManager.getInstance().getSetMachinePanel() != null) {
            ObjectManager.getInstance().getSetMachinePanel().drawDica();
        }
    }

    public Universo getUniverso() {
        return this.universo;
    }

    public String getArquivoUniverso() {
        return this.arquivoUniverso;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setArquivoUniverso(String string, String string2) {
        try {
            String string3 = "";
            System.out.println(string3.charAt(3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!IComb.isApplet()) {
            string = GerenciadorRecursos.getPath(this);
        }
        System.out.println("\n\nSetMachine.setArquivoUniverso: directory=" + string + ", arquivo=" + string2);
        this.directory = string;
        this.arquivoUniverso = string + string2;
    }

    public void loadUniverso(MontaFace montaFace) {
        Universo universo = null;
        try {
            universo = Parse.parseUniverso(GerenciadorRecursos.getInputStream(montaFace, this.arquivoUniverso), this.arquivoUniverso);
        }
        catch (Exception exception) {
            String string = I18n.getString("invalid_universe");
            MessageFrame.showMessage(string, montaFace);
            System.err.println(IComb.debugMsg(this) + "Error: in SetMachine: " + exception + "Error msg: " + string + " - in arquivoUniverso: " + this.arquivoUniverso);
            return;
        }
        universo.setArquivo(this.directory, this.arquivoUniverso);
        ObjectManager.setMachine.setUniverso(universo);
    }

    public void setUniverso(Universo universo) {
        this.formulaAtual = null;
        this.estagios = new Vector();
        this.universo = universo;
        if (!this.modoCriacao) {
            this.avaliador = new Avaliador(universo, this.exercicioAtual.getSolucao());
        } else if (universo != null) {
            this.arquivoUniverso = universo.getArquivo();
        }
        this.estado = ESTADO_CONSTRUCAO_INICIADA;
        if (universo != null) {
            ObjectManager.getInstance().getSetMachinePanel().setEnabledStartDUPanel();
            System.out.println("SetMachine.java: setUniverso: OK - modoCriacao=" + this.modoCriacao + ", estado=" + this.estado);
        } else {
            System.out.println("SetMachine.java: setUniverso: NAO - modoCriacao=" + this.modoCriacao + ", estado=" + this.estado);
        }
    }

    public void verificaResposta() {
        if (this.corrige) {
            this.avaliador.valida();
        }
        if (this.getResultadoFinal() != this.getExercicioAtual().getResposta()) {
            throw new RuntimeException("Resultado Incorreto!");
        }
    }

    public void validaConstrucao() {
        this.verificaResposta();
        this.estado = ESTADO_VALIDA_CONSTRUCAO;
    }

    public void verificaErro(Condicao condicao) {
        if (!this.corrige) {
            return;
        }
        this.avaliador.reset();
        for (int i = 0; i < this.estagios.size(); ++i) {
            Estagio estagio = (Estagio)this.estagios.get(i);
            this.avaliador.adicionaCondicao(estagio.criaCondicao());
        }
        this.avaliador.adicionaCondicao(condicao);
    }

    public int getNElementos() {
        return this.nElementos;
    }

    public String getDica() {
        return this.dica;
    }

    public boolean isCorrige() {
        return this.corrige;
    }

    public void setCorrige(boolean bl) {
        this.corrige = bl;
    }
}

