/*
 * Decompiled with CFR 0.152.
 */
package ajuda.visao.navegador;

import ajuda.visao.navegador.ItemNavigator;
import base.EsquemaVisual;
import icomb.util.Configuracoes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class NavigatorLabel
extends Label
implements MouseListener,
EsquemaVisual {
    ItemNavigator in;
    int index;
    private boolean selecionado;

    public NavigatorLabel(String string, int n, ItemNavigator itemNavigator) {
        super("   " + string);
        this.index = n;
        this.in = itemNavigator;
        this.setFont(EsquemaVisual.fontHB12);
        this.esquemaPadrao();
        this.addMouseListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 30);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.in.setConteudoAjuda(this.index);
        this.selecionaLabel(this.index);
    }

    void selecionaLabel(int n) {
        if (n == this.index) {
            this.setBackground(Configuracoes.CLEAR_BG1);
            this.setForeground(Configuracoes.FACE_DARK1);
            this.selecionado = true;
        } else {
            this.esquemaPadrao();
            this.selecionado = false;
        }
    }

    private void esquemaPadrao() {
        this.setForeground(Configuracoes.FACE_CLEAR2);
        this.setBackground(Configuracoes.DARK_BLUE2BG);
    }

    public void paint(Graphics graphics) {
        if (this.selecionado) {
            Color color = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            graphics.setColor(Color.gray);
            graphics.drawLine(1, 1, this.getSize().width - 2, 1);
            graphics.drawLine(1, 1, 1, this.getSize().height - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.getSize().width - 2, 1, this.getSize().width - 2, this.getSize().height - 2);
            graphics.drawLine(1, this.getSize().height - 2, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(color);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.selecionado) {
            this.setForeground(Configuracoes.FACE_CLEAR1);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.selecionado) {
            this.setForeground(Configuracoes.FACE_CLEAR2);
            this.setBackground(Configuracoes.DARK_BLUE2BG);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

