/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.DataOutputStream;
import java.io.IOException;
import model.Constantes;
import model.Cor;
import model.Posicao;
import model.Reta;
import model.Vetor;
import view.Tela;

public class Folha
implements Constantes {
    private double x;
    private double y;
    private double zoom;
    private double largJan;
    private double altJan;
    public double largFolha;
    public double altFolha;
    private Posicao foco;
    private Vetor pan;
    Tela sistema;

    public Folha(Tela sistema) {
        this.sistema = sistema;
        this.largJan = sistema.getWidth();
        this.altJan = sistema.getHeight() - 25;
        this.largFolha = 21.0 * sistema.unidade;
        this.altFolha = 29.7 * sistema.unidade;
        Vetor vet = new Vetor((this.largJan - this.largFolha) / 2.0, (this.altJan - this.altFolha) / 2.0);
        Posicao pos = new Posicao(0.0, 0.0);
        pos = pos.soma(vet);
        this.x = pos.x;
        this.y = pos.y;
        this.pan = new Vetor(0.0, 0.0);
        this.foco = new Posicao(0.0, 0.0);
        this.zoom = 1.0;
    }

    public Posicao centro() {
        Posicao pos = new Posicao(this.x, this.y);
        Vetor vet = new Vetor(this.largFolha / 2.0, this.altFolha / 2.0);
        return pos.soma(vet);
    }

    public Posicao focoAtual() {
        return this.foco;
    }

    public void atualizaPanSimples(Vetor mov) {
        this.pan = this.pan.soma(mov);
    }

    public void atualizaPan(Posicao ant, Posicao atual) {
        Vetor mov = new Vetor(ant, atual);
        this.atualizaPan(mov);
    }

    public void atualizaPan(Vetor mov) {
        boolean todasVisiveis;
        double largJan = this.sistema.getWidth();
        double altJan = this.sistema.getHeight() - 25;
        Posicao janela = new Posicao(0.0, 25.0);
        Posicao folha = this.posRelativa(this.x, this.y);
        double difLarg = this.largFolha * this.zoom < largJan ? (largJan - this.largFolha * this.zoom) / 2.0 : 20.0 * this.zoom;
        double difAlt = this.altFolha * this.zoom < altJan ? (altJan - this.altFolha * this.zoom) / 2.0 : 20.0 * this.zoom;
        double janEsq = janela.x;
        double janDir = janela.x + largJan;
        double janSup = janela.y;
        double janInf = janela.y + altJan;
        double folhaEsq = folha.x - difLarg;
        double folhaDir = folha.x + this.largFolha * this.zoom + difLarg;
        double folhaSup = folha.y - difAlt;
        double folhaInf = folha.y + this.altFolha * this.zoom + difAlt;
        boolean margEsqVisivel = folhaEsq >= janEsq && folhaEsq <= janDir;
        boolean margDirVisivel = folhaDir >= janEsq && folhaDir <= janDir;
        boolean margSupVisivel = folhaSup >= janSup && folhaSup <= janInf;
        boolean margInfVisivel = folhaInf >= janSup && folhaInf <= janInf;
        boolean bl = todasVisiveis = margEsqVisivel && margDirVisivel && margSupVisivel && margInfVisivel;
        if (!todasVisiveis) {
            if (margEsqVisivel) {
                if (mov.x > 0.0) {
                    mov.x = 0.0;
                }
            } else {
                mov.x = Math.min(mov.x, janEsq - folhaEsq);
            }
            if (margDirVisivel) {
                if (mov.x < 0.0) {
                    mov.x = 0.0;
                }
            } else {
                mov.x = Math.max(mov.x, janDir - folhaDir);
            }
            if (margSupVisivel) {
                if (mov.y > 0.0) {
                    mov.y = 0.0;
                }
            } else {
                mov.y = Math.min(mov.y, janSup - folhaSup);
            }
            if (margInfVisivel) {
                if (mov.y < 0.0) {
                    mov.y = 0.0;
                }
            } else {
                mov.y = Math.max(mov.y, janInf - folhaInf);
            }
            this.pan = this.pan.soma(mov);
        }
    }

    public void alteraZoomFator(double fator) {
        if (fator * this.zoom >= 0.1 && fator * this.zoom <= 8.0) {
            this.zoom *= fator;
        }
    }

    public void alteraZoom(double novoZoom) {
        if (novoZoom >= 0.1 && novoZoom <= 8.0) {
            this.zoom = novoZoom;
        }
    }

    public Reta margensVisiveis() {
        Reta apontaRetas;
        double largJan = this.sistema.getWidth();
        double altJan = this.sistema.getHeight() - 25;
        Posicao janela = new Posicao(0.0, 25.0);
        Posicao folha = this.posRelativa(this.x, this.y);
        double janEsq = janela.x;
        double janDir = janela.x + largJan;
        double janSup = janela.y;
        double janInf = janela.y + altJan;
        double folhaEsq = folha.x;
        double folhaDir = folha.x + this.largFolha * this.zoom;
        double folhaSup = folha.y;
        double folhaInf = folha.y + this.altFolha * this.zoom;
        boolean margEsqVisivel = folhaEsq >= janEsq && folhaEsq <= janDir;
        boolean margSupVisivel = folhaSup >= janSup && folhaSup <= janInf;
        boolean margDirVisivel = folhaDir >= janEsq && folhaDir <= janDir;
        boolean margInfVisivel = folhaInf >= janSup && folhaInf <= janInf;
        Reta reta = apontaRetas = new Reta(this);
        if (margEsqVisivel) {
            reta = reta.proximo = new Reta(folhaEsq, folhaSup, folhaEsq, folhaInf, this);
        }
        if (margSupVisivel) {
            reta = reta.proximo = new Reta(folhaEsq, folhaSup, folhaDir, folhaSup, this);
        }
        if (margDirVisivel) {
            reta = reta.proximo = new Reta(folhaDir, folhaSup, folhaDir, folhaInf, this);
        }
        if (margInfVisivel) {
            reta = reta.proximo = new Reta(folhaEsq, folhaInf, folhaDir, folhaInf, this);
        }
        return apontaRetas;
    }

    public void alteraFoco(double x, double y) {
        this.foco = new Posicao(x, y);
    }

    public void alteraFoco(Posicao pos) {
        this.foco = new Posicao(pos);
    }

    public double zoom() {
        return this.zoom;
    }

    public Posicao posAbsoluta(Posicao pos) {
        return this.posAbsoluta(pos.x, pos.y);
    }

    public Posicao posAbsoluta(double x, double y) {
        Posicao pos = new Posicao(x, y);
        pos = pos.soma(this.pan.invert());
        pos = this.posSemZoom(pos);
        return pos;
    }

    public Posicao posRelativa(Posicao pos) {
        return this.posRelativa(pos.x, pos.y);
    }

    public Posicao posRelativa(double x, double y) {
        Posicao pos = new Posicao(x, y);
        Vetor vet = new Vetor(this.foco, pos);
        vet = vet.vetorPar(vet.norma() * this.zoom);
        pos = this.foco.soma(vet);
        pos = pos.soma(this.pan);
        return pos;
    }

    public Posicao posSemZoom(Posicao pos) {
        return this.posSemZoom(pos.x, pos.y);
    }

    public Posicao posSemZoom(double x, double y) {
        Posicao pos = new Posicao(x, y);
        Vetor vet = new Vetor(this.foco, pos);
        vet = vet.vetorPar(vet.norma() / this.zoom);
        pos = this.foco.soma(vet);
        return pos;
    }

    public Posicao posComZoom(Posicao pos) {
        return this.posComZoom(pos.x, pos.y);
    }

    public Posicao posComZoom(double x, double y) {
        Posicao pos = new Posicao(x, y);
        Vetor vet = new Vetor(this.foco, pos);
        vet = vet.vetorPar(vet.norma() * this.zoom);
        pos = this.foco.soma(vet);
        return pos;
    }

    public Posicao posPan(Posicao pos) {
        return this.posPan(pos.x, pos.y);
    }

    public Posicao posPan(double x, double y) {
        Posicao pos = new Posicao(x, y);
        pos = pos.soma(this.pan);
        return pos;
    }

    public Posicao posSemPan(Posicao pos) {
        return this.posSemPan(pos.x, pos.y);
    }

    public Posicao posSemPan(double x, double y) {
        Posicao pos = new Posicao(x, y);
        pos = pos.soma(this.pan.invert());
        return pos;
    }

    public Polygon poligono(int[] X, int[] Y, int n) {
        Posicao pos = new Posicao(0.0, 0.0);
        int i = 0;
        while (i < n) {
            pos.defPosicao(X[i], Y[i]);
            pos = this.posPan(pos);
            X[i] = pos.intX();
            Y[i] = pos.intY();
            ++i;
        }
        return new Polygon(X, Y, n);
    }

    public Posicao vertSupEsq() {
        Posicao pos = new Posicao(this.x, this.y);
        return this.posRelativa(pos);
    }

    public Posicao vertInfDir() {
        Vetor vet = new Vetor(this.largFolha, this.altFolha);
        Posicao pos = new Posicao(this.x, this.y);
        pos = pos.soma(vet);
        return this.posRelativa(pos);
    }

    public boolean posicaoDentro(Posicao pos) {
        Posicao pos1 = this.vertSupEsq();
        Posicao pos2 = this.vertInfDir();
        return pos.x > pos1.x + 2.0 && pos.x < pos2.x - 2.0 && pos.y > pos1.y + 2.0 && pos.y < pos2.y - 2.0;
    }

    public void desenha(Graphics g) {
        Polygon fundo;
        int[] X = new int[4];
        int[] Y = new int[4];
        double largJan = this.sistema.getWidth();
        double altJan = this.sistema.getHeight();
        Posicao posJan1 = new Posicao(0.0, 0.0);
        Posicao posJan2 = new Posicao(posJan1.x + largJan, posJan1.y + altJan);
        Posicao posFolha1 = new Posicao(this.x, this.y);
        Posicao posFolha2 = new Posicao(posFolha1.x + this.largFolha, posFolha1.y + this.altFolha);
        posFolha1 = this.posRelativa(posFolha1);
        posFolha2 = this.posRelativa(posFolha2);
        Color cor = g.getColor();
        switch (this.sistema.fundo) {
            case 0: {
                g.setColor(Cor.folFundo0);
                break;
            }
            case 1: {
                g.setColor(Cor.folFundo1);
                break;
            }
            case 2: {
                g.setColor(Cor.folFundo2);
                break;
            }
            case 3: {
                g.setColor(Cor.folFundo3);
            }
        }
        if (posFolha1.x > posJan1.x) {
            X[0] = posJan1.intX();
            Y[0] = posFolha1.intY();
            X[1] = posFolha1.intX();
            Y[1] = posFolha1.intY();
            X[2] = posFolha1.intX();
            Y[2] = posFolha2.intY();
            X[3] = posJan1.intX();
            Y[3] = posFolha2.intY();
            fundo = new Polygon(X, Y, 4);
            g.fillPolygon(fundo);
        }
        if (posFolha2.x < posJan2.x) {
            X[0] = posFolha2.intX();
            Y[0] = posFolha1.intY();
            X[1] = posJan2.intX();
            Y[1] = posFolha1.intY();
            X[2] = posJan2.intX();
            Y[2] = posFolha2.intY();
            X[3] = posFolha2.intX();
            Y[3] = posFolha2.intY();
            fundo = new Polygon(X, Y, 4);
            g.fillPolygon(fundo);
        }
        if (posFolha1.y > posJan1.y) {
            X[0] = posJan1.intX();
            Y[0] = posJan1.intY();
            X[1] = posJan2.intX();
            Y[1] = posJan1.intY();
            X[2] = posJan2.intX();
            Y[2] = posFolha1.intY();
            X[3] = posJan1.intX();
            Y[3] = posFolha1.intY();
            fundo = new Polygon(X, Y, 4);
            g.fillPolygon(fundo);
        }
        if (posFolha2.y < posJan2.y) {
            X[0] = posJan1.intX();
            Y[0] = posFolha2.intY();
            X[1] = posJan2.intX();
            Y[1] = posFolha2.intY();
            X[2] = posJan2.intX();
            Y[2] = posJan2.intY();
            X[3] = posJan1.intX();
            Y[3] = posJan2.intY();
            fundo = new Polygon(X, Y, 4);
            g.fillPolygon(fundo);
        }
        X[0] = Math.max(posFolha1.intX(), posJan1.intX());
        Y[0] = Math.max(posFolha1.intY(), posJan1.intY());
        X[1] = Math.min(posFolha2.intX(), posJan2.intX());
        Y[1] = Math.max(posFolha1.intY(), posJan1.intY());
        X[2] = Math.min(posFolha2.intX(), posJan2.intX());
        Y[2] = Math.min(posFolha2.intY(), posJan2.intY());
        X[3] = Math.max(posFolha1.intX(), posJan1.intX());
        Y[3] = Math.min(posFolha2.intY(), posJan2.intY());
        Polygon folha = new Polygon(X, Y, 4);
        g.setColor(Cor.folPapel);
        g.fillPolygon(folha);
        g.setColor(Cor.folContorno);
        g.drawPolygon(folha);
        g.setColor(cor);
    }

    public void salva(DataOutputStream saida) throws IOException {
        saida.writeBytes("F " + this.zoom + " " + this.foco.x + " " + this.foco.y + " " + this.pan.x + " " + this.pan.y + "\n");
    }
}

