/*
 * Decompiled with CFR 0.152.
 */
package model;

import control.Calculos;
import control.Impressao;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import model.Constantes;
import model.Cor;
import model.Folha;
import model.Posicao;
import model.Vetor;

public class Arco
implements Constantes {
    public int serialUID;
    public double anguloInicial;
    public double anguloArco;
    public double raio;
    public Posicao centro;
    public Arco proximo;
    private Folha folha;
    private int tolerancia;
    public boolean destaque;
    public int tipoLinha;
    public float espessuraLinha;
    public Color corLinha;

    public Arco(Folha folha) {
        this.folha = folha;
        this.serialUID = -1;
        this.destaque = false;
        this.proximo = null;
        this.tolerancia = 6;
        this.tipoLinha = Cor.tipoLinha;
        this.espessuraLinha = Cor.espessuraLinha;
        this.corLinha = Cor.arcNormal;
    }

    public Arco(double x, double y, double r, double i, double a, Folha folha) {
        this(folha);
        this.centro = new Posicao(x, y);
        this.centro.x = x;
        this.centro.y = y;
        this.raio = r;
        this.anguloInicial = i;
        this.anguloArco = a;
        this.tipoLinha = Cor.tipoLinha;
    }

    public Arco(Posicao centro, double raio, double inicial, double varredura, Folha folha) {
        this(centro.x, centro.y, raio, inicial, varredura, folha);
    }

    public Arco arcoRel() {
        int raioInt = Calculos.valInt(this.raio() * this.folha.zoom());
        return new Arco(this.folha.posComZoom(this.centro), raioInt, this.anguloInicial, this.anguloArco, this.folha);
    }

    public void defAnguloInicial(double angulo) {
        this.anguloInicial = angulo;
    }

    public void defAnguloVarredura(double angulo) {
        this.anguloArco = angulo;
    }

    public double cantoEsquerdo() {
        return this.centro.x - this.raio;
    }

    public double cantoSuperior() {
        return this.centro.y - this.raio;
    }

    public double raio() {
        return this.raio;
    }

    public int angIniInt() {
        return (int)Math.round(this.anguloInicial);
    }

    public int angVarrInt() {
        return (int)Math.round(this.anguloArco);
    }

    public double anguloInicial() {
        return this.anguloInicial;
    }

    public double anguloVarredura() {
        return this.anguloArco;
    }

    public double anguloFinal() {
        return this.anguloInicial + this.anguloArco;
    }

    public boolean fechado() {
        return this.anguloArco == 360.0;
    }

    public Posicao posicaoInicio() {
        Posicao inicio = new Posicao(0.0, 0.0);
        inicio.x = this.centro.x + this.raio * Math.cos(this.anguloInicial * (Math.PI / 180));
        inicio.y = this.centro.y - this.raio * Math.sin(this.anguloInicial * (Math.PI / 180));
        return inicio;
    }

    public Posicao posicaoFim() {
        Posicao fim = new Posicao(0.0, 0.0);
        fim.x = this.centro.x + this.raio * Math.cos((this.anguloInicial + this.anguloArco) * (Math.PI / 180));
        fim.y = this.centro.y - this.raio * Math.sin((this.anguloInicial + this.anguloArco) * (Math.PI / 180));
        return fim;
    }

    public boolean dentroRegiao(Posicao pos) {
        double d = this.raio + (double)this.tolerancia;
        Posicao vertSupEsq = new Posicao(this.centro.x - d, this.centro.y - d);
        Posicao vertInfDir = new Posicao(this.centro.x + d, this.centro.y + d);
        return pos.x >= vertSupEsq.x && pos.y >= vertSupEsq.y && pos.x <= vertInfDir.x && pos.y <= vertInfDir.y;
    }

    public boolean interceptaPosicao(Posicao pos) {
        double tol = 6.0;
        Vetor vet1 = new Vetor(1.0, 0.0);
        Vetor vet2 = new Vetor(this.centro, pos);
        if (vet2.norma() < this.raio - tol || vet2.norma() > this.raio + tol) {
            return false;
        }
        if (this.fechado()) {
            return true;
        }
        double angulo = Calculos.anguloVetores360(vet1, vet2);
        if ((angulo -= this.anguloInicial) < 0.0) {
            angulo += 360.0;
        } else if (angulo > 360.0) {
            angulo -= 360.0;
        }
        return angulo >= 0.0 && angulo <= this.anguloArco;
    }

    public boolean interceptaPosRel(Posicao pos) {
        double tol = 6.0;
        Vetor vet1 = new Vetor(1.0, 0.0);
        Vetor vet2 = new Vetor(this.folha.posComZoom(this.centro), pos);
        if (vet2.norma() < this.raio * this.folha.zoom() - tol || vet2.norma() > this.raio * this.folha.zoom() + tol) {
            return false;
        }
        if (this.fechado()) {
            return true;
        }
        double angulo = Calculos.anguloVetores360(vet1, vet2);
        double dif = 0.0 - this.anguloInicial;
        if ((angulo += dif) < 0.0) {
            angulo += 360.0;
        } else if (angulo > 360.0) {
            angulo -= 360.0;
        }
        return angulo >= 0.0 && angulo <= this.anguloArco;
    }

    public void desenha(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        Posicao local = this.folha.posRelativa(this.cantoEsquerdo(), this.cantoSuperior());
        int raioInt = Calculos.valInt(this.raio() * this.folha.zoom());
        if (this.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f));
        } else if (this.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (this.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (this.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        Color cor = g2d.getColor();
        if (this.destaque) {
            g2d.setColor(Cor.arcDest);
        } else {
            g2d.setColor(this.corLinha);
        }
        if (this.fechado()) {
            g2d.drawOval(local.intX(), local.intY(), 2 * raioInt, 2 * raioInt);
        } else {
            g2d.drawArc(local.intX(), local.intY(), 2 * raioInt, 2 * raioInt, this.angIniInt(), this.angVarrInt());
        }
        g2d.setColor(cor);
    }

    public void imprime(Graphics g, Impressao impressao) {
        Graphics2D g2d = (Graphics2D)g.create();
        Posicao local = impressao.posRelativa(this.cantoEsquerdo(), this.cantoSuperior());
        int raioInt = Calculos.valInt(this.raio() * impressao.escala());
        if (this.tipoLinha == 0) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f));
        } else if (this.tipoLinha == 1) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
        } else if (this.tipoLinha == 2) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f));
        } else if (this.tipoLinha == 3) {
            g2d.setStroke(new BasicStroke(this.espessuraLinha, 0, 0, 10.0f, new float[]{21.0f, 9.0f, 3.0f, 9.0f}, 10.0f));
        }
        Color cor = g2d.getColor();
        g2d.setPaint(this.corLinha);
        if (this.fechado()) {
            g2d.drawOval(local.intX(), local.intY(), 2 * raioInt, 2 * raioInt);
        } else {
            g2d.drawArc(local.intX(), local.intY(), 2 * raioInt, 2 * raioInt, this.angIniInt(), this.angVarrInt());
        }
        g2d.setColor(cor);
    }

    public String salva() {
        String result = "A " + this.centro.x + " " + this.centro.y + " " + this.raio + " " + this.anguloInicial + " " + this.anguloArco;
        result = String.valueOf(result) + " CL " + this.corLinha.getRed() + " " + this.corLinha.getGreen() + " " + this.corLinha.getBlue();
        result = String.valueOf(result) + " TL " + this.tipoLinha;
        result = String.valueOf(result) + " EL " + this.espessuraLinha;
        result = String.valueOf(result) + " !\n";
        return result;
    }
}

