/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Calculos;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import model.Constantes;
import model.Posicao;
import model.Vetor;
import view.Tela;

public class Impressao
implements Printable,
Constantes {
    double largPapel = 0.0;
    double altPapel = 0.0;
    double largUtil = 0.0;
    double altUtil = 0.0;
    double escala;
    Posicao origemUtil = null;
    Vetor desloc = null;
    Tela sistema;

    public Impressao(Tela risko) {
        this.sistema = risko;
    }

    public double escala() {
        return this.escala;
    }

    public Posicao centroPapel() {
        Vetor vet = new Vetor(this.largUtil / 2.0, this.altUtil / 2.0);
        Posicao centro = this.origemUtil.soma(vet);
        return centro;
    }

    public Posicao posRelativa(Posicao pos) {
        return this.posRelativa(pos.x, pos.y);
    }

    public Posicao posRelativa(double x, double y) {
        Posicao centro = this.sistema.folha.centro();
        Posicao pos = new Posicao(x, y);
        Vetor vet = new Vetor(centro, pos);
        vet = vet.vetorPar(vet.norma() * this.escala);
        pos = centro.soma(vet);
        pos = pos.soma(this.desloc);
        return pos;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setPaint(Color.BLACK);
        this.origemUtil = new Posicao(Calculos.valInt(pageFormat.getImageableX()), Calculos.valInt(pageFormat.getImageableY()));
        this.altPapel = pageFormat.getHeight();
        this.largPapel = pageFormat.getWidth();
        this.altUtil = pageFormat.getImageableHeight();
        this.largUtil = pageFormat.getImageableWidth();
        this.escala = 0.9641651936365098;
        this.desloc = new Vetor(this.sistema.folha.centro(), this.centroPapel());
        this.sistema.imprime(g, this);
        if (page == 0) {
            return 0;
        }
        return 1;
    }
}

