/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

import ilm.line.itangram2.TangramPiece;
import ilm.line.itangram2.TangramPositionCoder;

class TangramPosition {
    private TangramPiece[] tangramPieces = new TangramPiece[7];
    private int[][] composingUnits;
    static int count = 0;
    private static int countGetXY = 0;
    private static int idS = 0;
    public final int id = idS++;

    static int[][] getComposingUnits(TangramPiece[] tangramPieceArray) {
        Object object = new int[32][];
        int n = 0;
        for (int i = 0; i < tangramPieceArray.length; ++i) {
            int[][] nArray = tangramPieceArray[i].getComposingUnits();
            for (int j = 0; j < nArray.length; ++j) {
                object[n++] = nArray[j];
            }
        }
        object = TangramPosition.translateToOrigin(object);
        return object;
    }

    static int pieceByBasicTriangles(int n) {
        if (n < 8) {
            return 0;
        }
        if (n < 16) {
            return 1;
        }
        if (n < 20) {
            return 2;
        }
        if (n < 22) {
            return 3;
        }
        if (n < 24) {
            return 4;
        }
        if (n < 28) {
            return 5;
        }
        return 6;
    }

    static int[][] translateToOrigin(int[][] nArray) {
        int n;
        int n2 = nArray[0][0];
        int n3 = nArray[0][1];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n][0] < n2) {
                n2 = nArray[n][0];
            }
            if (nArray[n][1] >= n3) continue;
            n3 = nArray[n][1];
        }
        for (n = 0; n < nArray.length; ++n) {
            int[] nArray2 = nArray[n];
            nArray2[0] = nArray2[0] - n2;
            int[] nArray3 = nArray[n];
            nArray3[1] = nArray3[1] - n3;
        }
        return nArray;
    }

    public TangramPiece[] getTangramPieces() {
        return this.tangramPieces;
    }

    public int[][] getComposingUnits() {
        return this.composingUnits;
    }

    public TangramPosition() {
        this.tangramPieces[0] = new TangramPiece("LargeTriangle");
        this.tangramPieces[1] = new TangramPiece("LargeTriangle");
        this.tangramPieces[2] = new TangramPiece("MediumTriangle");
        this.tangramPieces[3] = new TangramPiece("SmallTriangle");
        this.tangramPieces[4] = new TangramPiece("SmallTriangle");
        this.tangramPieces[5] = new TangramPiece("Square");
        this.tangramPieces[6] = new TangramPiece("Lozange");
    }

    public static String getCorners(TangramPiece tangramPiece) {
        String string = "";
        int[] nArray = tangramPiece.getXpoints();
        int[] nArray2 = tangramPiece.getYpoints();
        for (int i = 0; i < nArray.length; ++i) {
            string = string + "(" + nArray[i] + "," + nArray2[i] + ") ";
        }
        return string;
    }

    public static int getMinCoordX(TangramPiece tangramPiece) {
        int[] nArray = tangramPiece.getXpoints();
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int getMinCoordY(TangramPiece tangramPiece) {
        int[] nArray = tangramPiece.getYpoints();
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private static int[] getMinXY(int[][] nArray, TangramPiece[] tangramPieceArray, boolean bl) {
        ++countGetXY;
        if (nArray == null) {
            return new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        }
        int n = nArray.length;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int[] nArray2 = tangramPieceArray[0].getXpoints();
        int[] nArray3 = tangramPieceArray[0].getYpoints();
        n2 = nArray2[0];
        n3 = nArray3[0];
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i][0];
            int n5 = nArray[i][1];
            int n6 = nArray[i][2];
            tangramPieceArray[i].translate(n4, n5);
            tangramPieceArray[i].rotate(n6);
            nArray2 = tangramPieceArray[i].getXpoints();
            nArray3 = tangramPieceArray[i].getYpoints();
            int n7 = TangramPosition.getMinCoordX(tangramPieceArray[i]);
            int n8 = TangramPosition.getMinCoordY(tangramPieceArray[i]);
            if (n7 < n2) {
                n2 = n7;
            }
            if (n8 >= n3) continue;
            n3 = n8;
            if (n5 != 102) continue;
            n3 -= 35;
        }
        return new int[]{n2, n3};
    }

    protected static int[] findCorrectTopCorner(int[][] nArray, TangramPiece[] tangramPieceArray, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0};
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        nArray2 = TangramPosition.getMinXY(nArray, tangramPieceArray, bl);
        n = nArray2[0];
        n2 = nArray2[1];
        int n3 = 0 - n;
        int n4 = 0 - n2;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray3 = nArray[i];
            nArray3[0] = nArray3[0] + n3;
            int[] nArray4 = nArray[i];
            nArray4[1] = nArray4[1] + n4;
            nArray2[0] = n;
            nArray2[1] = n2;
        }
        return nArray2;
    }

    public void loadFromString(String string, String string2) throws Exception {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        int[][] nArray = TangramPositionCoder.decodePosition(string);
        int n = 0;
        int n2 = 0;
        if (nArray == null) {
            System.err.println("TangramPosition.java: ERROR: position null...\ndecode=" + string);
            throw new Exception("Invalid String Code Argument");
        }
        int[] nArray2 = string2 != null && string2.equals("position0") ? TangramPosition.findCorrectTopCorner(nArray, this.tangramPieces, true) : TangramPosition.findCorrectTopCorner(nArray, this.tangramPieces, false);
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int[] nArray3 = new int[]{0 - n3, 0 - n4};
        n += 5;
        n2 += 5;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray4 = nArray[i];
            int n5 = nArray4[0] + n;
            int n6 = nArray4[1] + n2;
            this.tangramPieces[i].setTranslation(n5, n6);
            this.tangramPieces[i].setRotation(nArray4[2]);
        }
        this.updateComposingUnits();
    }

    public void updateComposingUnits() {
        this.composingUnits = TangramPosition.getComposingUnits(this.tangramPieces);
    }

    public String writeToString() {
        int[][] nArray = new int[7][3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i][0] = this.tangramPieces[i].getXOffset();
            nArray[i][1] = this.tangramPieces[i].getYOffset();
            nArray[i][2] = this.tangramPieces[i].getRotation();
        }
        nArray = TangramPosition.translateToOrigin(nArray);
        return TangramPositionCoder.encodePosition(nArray);
    }

    public boolean equals(TangramPosition tangramPosition, boolean bl) {
        int[][] nArray = this.composingUnits;
        int[][] nArray2 = tangramPosition.composingUnits;
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = true;
        if (nArray == null) {
            return false;
        }
        if (bl) {
            System.out.println("TangramPosition.java: equals(...): thisUnits.length=" + nArray.length);
        }
        boolean bl3 = false;
        block0: for (int i = 0; i < nArray.length; ++i) {
            int n;
            f = Float.POSITIVE_INFINITY;
            for (n = 0; n < nArray2.length; ++n) {
                float f2 = Math.abs(nArray[i][0] - nArray2[n][0]) + Math.abs(nArray[i][1] - nArray2[n][1]) + Math.abs(nArray[i][2] - nArray2[n][2]);
                if (f2 < f) {
                    f = f2;
                }
                if (f2 != 0.0f) continue;
                if (!bl) continue block0;
                int n2 = TangramPosition.pieceByBasicTriangles(i);
                int n3 = TangramPosition.pieceByBasicTriangles(n);
                System.out.println("TangramPosition.java: [" + i + "," + n + "] : piece " + n2 + " = " + n3 + " (" + this.tangramPieces[n2].getName() + "=" + this.tangramPieces[n3].getName() + ")");
                continue block0;
            }
            if (bl) {
                n = TangramPosition.pieceByBasicTriangles(i);
                System.out.println("TangramPosition.java: not equals to piece " + n + " (" + this.tangramPieces[n].getName() + "): " + f + "");
            }
            bl3 = true;
        }
        System.out.println("TangramPosition.java: equals: " + f);
        return !bl3;
    }
}

