/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

import ilm.line.itangram2.TangramProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class TangramPiece {
    protected static final String TANGRAM_FORM_LARGE_TRIANGE = "LargeTriangle";
    protected static final String TANGRAM_FORM_MEDIUM_TRIANGE = "MediumTriangle";
    protected static final String TANGRAM_FORM_SMALL_TRIANGE = "SmallTriangle";
    protected static final String TANGRAM_FORM_SQUARE = "Square";
    protected static final String TANGRAM_FORM_LOZENGE = "Lozange";
    private int[] xPoints;
    private int[] yPoints;
    private int xOffset = 0;
    private int yOffset = 0;
    private float rotation = 0.0f;
    private Polygon tangramPiecePolygon;
    private boolean isSelected = false;
    private int[] xSnappingPoints = null;
    private int[] ySnappingPoints = null;
    private int[] xRotatedSnappingPoints = null;
    private int[] yRotatedSnappingPoints = null;
    private int[][] composingUnits;
    String name = "";

    protected int[] getXpoints() {
        return this.xPoints;
    }

    protected int[] getYpoints() {
        return this.yPoints;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getRotation() {
        return (int)this.rotation;
    }

    private void multiplyArraysByUnit() {
        int n = 24;
        int n2 = 0;
        while (n2 < this.xPoints.length) {
            int n3 = n2;
            this.xPoints[n3] = this.xPoints[n3] * n;
            int n4 = n2++;
            this.yPoints[n4] = this.yPoints[n4] * n;
        }
        n2 = 0;
        while (n2 < this.xSnappingPoints.length) {
            int n5 = n2;
            this.xSnappingPoints[n5] = this.xSnappingPoints[n5] * n;
            int n6 = n2++;
            this.ySnappingPoints[n6] = this.ySnappingPoints[n6] * n;
        }
        for (n2 = 0; n2 < this.composingUnits.length; ++n2) {
            int[] nArray = this.composingUnits[n2];
            nArray[0] = nArray[0] * n;
            int[] nArray2 = this.composingUnits[n2];
            nArray2[1] = nArray2[1] * n;
        }
    }

    public String getName() {
        return this.name;
    }

    public TangramPiece(String string) {
        this.name = string;
        if (string.equals(TANGRAM_FORM_LARGE_TRIANGE)) {
            this.xPoints = TangramProperties.largeTriangle_xPoints;
            this.yPoints = TangramProperties.largeTriangle_yPoints;
            this.xSnappingPoints = TangramProperties.largeTriangle_xSnappingPoints;
            this.ySnappingPoints = TangramProperties.largeTriangle_ySnappingPoints;
            this.composingUnits = TangramProperties.largeTriangle_composingUnits;
        } else if (string.equals(TANGRAM_FORM_MEDIUM_TRIANGE)) {
            this.xPoints = TangramProperties.mediumTriangle_xPoints;
            this.yPoints = TangramProperties.mediumTriangle_yPoints;
            this.xSnappingPoints = TangramProperties.mediumTriangle_xSnappingPoints;
            this.ySnappingPoints = TangramProperties.mediumTriangle_ySnappingPoints;
            this.composingUnits = TangramProperties.mediumTriangle_composingUnits;
        } else if (string.equals(TANGRAM_FORM_SMALL_TRIANGE)) {
            this.xPoints = TangramProperties.smallTriangle_xPoints;
            this.yPoints = TangramProperties.smallTriangle_yPoints;
            this.xSnappingPoints = TangramProperties.smallTriangle_xSnappingPoints;
            this.ySnappingPoints = TangramProperties.smallTriangle_ySnappingPoints;
            this.composingUnits = TangramProperties.smallTriangle_composingUnits;
        } else if (string.equals(TANGRAM_FORM_SQUARE)) {
            this.xPoints = TangramProperties.square_xPoints;
            this.yPoints = TangramProperties.square_yPoints;
            this.xSnappingPoints = TangramProperties.square_xSnappingPoints;
            this.ySnappingPoints = TangramProperties.square_ySnappingPoints;
            this.composingUnits = TangramProperties.square_composingUnits;
        } else if (string.equals(TANGRAM_FORM_LOZENGE)) {
            this.xPoints = TangramProperties.lozenge_xPoints;
            this.yPoints = TangramProperties.lozenge_yPoints;
            this.xSnappingPoints = TangramProperties.lozenge_xSnappingPoints;
            this.ySnappingPoints = TangramProperties.lozenge_ySnappingPoints;
            this.composingUnits = TangramProperties.lozenge_composingUnits;
        } else {
            System.err.println("Error: Invalid type for Tangram Piece consutructor");
            return;
        }
        this.rotatePoints();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.isSelected ? TangramProperties.PIECE_SELECTED_FILL_COLOR : TangramProperties.PIECE_FILL_COLOR);
        graphics.fillPolygon(this.tangramPiecePolygon);
        graphics.setColor(this.isSelected ? TangramProperties.PIECE_SELECTED_OUTLINE_COLOR : TangramProperties.PIECE_OUTLINE_COLOR);
        graphics.drawPolygon(this.tangramPiecePolygon);
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.tangramPiecePolygon.getBounds());
    }

    public boolean contains(int n, int n2) {
        return this.tangramPiecePolygon.contains(n, n2);
    }

    public void rotate(float f) {
        this.rotation += f;
        while (this.rotation < 0.0f) {
            this.rotation += 360.0f;
        }
        while (this.rotation >= 360.0f) {
            this.rotation -= 360.0f;
        }
        this.rotatePoints();
    }

    public void translate(int n, int n2) {
        this.xOffset += n;
        this.yOffset += n2;
        this.tangramPiecePolygon.translate(n, n2);
    }

    public void setRotation(float f) {
        this.rotation = f;
        this.rotatePoints();
    }

    public void setTranslation(int n, int n2) {
        this.tangramPiecePolygon.translate(n - this.xOffset, n2 - this.yOffset);
        this.xOffset = n;
        this.yOffset = n2;
    }

    public Point snap(TangramPiece tangramPiece) {
        Point point = null;
        double d = 100.0;
        if (tangramPiece == null) {
            System.err.println(this.getClass().getName() + ": error, no other piece!");
            return null;
        }
        for (int i = 0; i < this.xRotatedSnappingPoints.length; ++i) {
            for (int j = 0; j < tangramPiece.xRotatedSnappingPoints.length; ++j) {
                double d2;
                int n = this.xRotatedSnappingPoints[i] + this.xOffset;
                n -= tangramPiece.xRotatedSnappingPoints[j] + tangramPiece.xOffset;
                int n2 = this.yRotatedSnappingPoints[i] + this.yOffset;
                if (!((d2 = (double)(n * n + (n2 -= tangramPiece.yRotatedSnappingPoints[j] + tangramPiece.yOffset) * n2)) <= d)) continue;
                d = d2;
                point = new Point(n, n2);
            }
        }
        return point;
    }

    public int[][] getComposingUnits() {
        int[][] nArray = new int[this.composingUnits.length][3];
        double d = Math.PI * (double)this.rotation / 180.0;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int[] nArray2 = null;
        for (int i = 0; i < this.composingUnits.length; ++i) {
            nArray2 = this.composingUnits[i];
            nArray[i][0] = this.xOffset + (int)Math.round(d2 * (double)nArray2[0] + d3 * (double)nArray2[1]);
            nArray[i][1] = this.yOffset + (int)Math.round(-d3 * (double)nArray2[0] + d2 * (double)nArray2[1]);
            nArray[i][2] = (int)((float)nArray2[2] + this.rotation + 720.0f) % 360;
        }
        return nArray;
    }

    private void rotatePoints() {
        int n;
        double d = Math.PI * (double)this.rotation / 180.0;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int[] nArray = new int[this.xPoints.length];
        int[] nArray2 = new int[this.xPoints.length];
        for (n = 0; n < this.xPoints.length; ++n) {
            nArray[n] = (int)Math.round(d2 * (double)this.xPoints[n] + d3 * (double)this.yPoints[n]);
            nArray2[n] = (int)Math.round(-d3 * (double)this.xPoints[n] + d2 * (double)this.yPoints[n]);
        }
        this.tangramPiecePolygon = new Polygon(nArray, nArray2, this.xPoints.length);
        this.tangramPiecePolygon.translate(this.xOffset, this.yOffset);
        if (this.xSnappingPoints == null || this.ySnappingPoints == null) {
            System.err.println("Snapping Points Not Defined for: " + this.name);
            this.xRotatedSnappingPoints = nArray;
            this.yRotatedSnappingPoints = nArray2;
            return;
        }
        this.xRotatedSnappingPoints = new int[this.xSnappingPoints.length];
        this.yRotatedSnappingPoints = new int[this.xSnappingPoints.length];
        for (n = 0; n < this.xSnappingPoints.length; ++n) {
            this.xRotatedSnappingPoints[n] = (int)Math.round(d2 * (double)this.xSnappingPoints[n] + d3 * (double)this.ySnappingPoints[n]);
            this.yRotatedSnappingPoints[n] = (int)Math.round(-d3 * (double)this.xSnappingPoints[n] + d2 * (double)this.ySnappingPoints[n]);
        }
    }
}

