/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

import ilm.line.itangram2.Tangram;
import java.io.IOException;
import java.util.ResourceBundle;

class TangramModelData {
    private static final String RESOURCE_FILE = "modelset";
    public static String start_position = "RVNk0JrUZDrGAUmUlO90o6E1xgXV";
    public static String[] positions = new String[]{"AHYFqMO00000mIdUqWBk6t40kTJ0", "aGi70MZcMTScLqccRlbrsJi7EkFN", "Z5QNPSyMlK3sE6mrox28Tcs79occ"};
    public static String[] descriptions = new String[]{"square", "rectangle", "triangle"};
    public int positionIndex = 0;
    private static final String PROPERTIES_LOCATION = "./Models/";
    private static final String KEY_FILE_TYPE = "fileType";
    private static final String TANGRAM_MODEL_SET_TYPE = "TangramModelSet";
    private static final String KEY_NUMBER_OF_MODELS = "NumberOfModels";
    private static final String KEY_MODEL_PREFIX = "Model";
    private static final String KEY_MODELCODE_POSTFIX = "";
    private static final String KEY_MODEL_SEPARATOR = " % ";

    public String getCurrentModel() {
        return positions[this.positionIndex];
    }

    public String getModelDescription() {
        return " " + (this.positionIndex + 1) + ":  " + descriptions[this.positionIndex];
    }

    public String getPrevModel() {
        --this.positionIndex;
        if (this.positionIndex < 0) {
            this.positionIndex = positions.length - 1;
        }
        return positions[this.positionIndex];
    }

    public String getNextModel() {
        ++this.positionIndex;
        if (this.positionIndex >= positions.length) {
            this.positionIndex = 0;
        }
        return positions[this.positionIndex];
    }

    public static void setPosition(String string) {
        TangramModelData.positions[0] = string;
    }

    public static void setDescription(String string) {
        TangramModelData.descriptions[0] = string;
    }

    public static void loadFromProperties(Tangram tangram) throws IOException, NumberFormatException {
        String string = KEY_MODELCODE_POSTFIX;
        try {
            String string2 = "ilm.line.itangram2/modelset";
            ResourceBundle resourceBundle = null;
            if (!tangram.isApplication() && !tangram.isAuthor()) {
                System.err.println("\n\nilm/line/itangram2/TangramModelData.java: loadFromProperties(): NAO autoria => NAO carrega as centenas de modelos de 'src/ilm/line/itangram2/modelset.properties'");
                return;
            }
            try {
                resourceBundle = ResourceBundle.getBundle(string2);
            }
            catch (Exception exception) {
                System.err.println("ilm/line/itangram2/TangramModelData.java: loadFromProperties(): resources = ResourceBundle.getBundle(" + string2 + ")");
                System.err.println("Exception Number Convertion in resource file <" + string2 + ">: " + exception);
                exception.printStackTrace();
                return;
            }
            String string3 = resourceBundle.getString(KEY_FILE_TYPE);
            if (!TANGRAM_MODEL_SET_TYPE.equals(string3)) {
                System.err.println("Bad file type in resource file: <modelset> is not a TangramModelSet");
                return;
            }
            int n = Integer.parseInt(resourceBundle.getString(KEY_NUMBER_OF_MODELS));
            System.out.println("numberOfModels = " + n);
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 1; i <= n; ++i) {
                String string4 = resourceBundle.getString(KEY_MODEL_PREFIX + i + KEY_MODELCODE_POSTFIX);
                int n2 = string4.indexOf(KEY_MODEL_SEPARATOR);
                stringArray[i - 1] = string = string4.substring(0, n2);
                stringArray2[i - 1] = string4.substring(n2 + KEY_MODEL_SEPARATOR.length());
            }
            positions = stringArray;
            descriptions = stringArray2;
            System.out.println("*** All models Loaded ***");
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("ilm/line/itangram2/TangramModelData.java: loadFromProperties(): failed in define position: last model read '" + string + "'");
            System.err.println("Exception Number Convertion in resource file <modelset>: " + numberFormatException);
            throw numberFormatException;
        }
    }
}

