/*
 * Decompiled with CFR 0.152.
 */
package ilm.framework;

import ilm.framework.assignment.AssignmentControl;
import ilm.framework.assignment.IAssignment;
import ilm.framework.assignment.model.AssignmentState;
import ilm.framework.comm.CommControl;
import ilm.framework.comm.ICommunication;
import ilm.framework.config.SystemConfig;
import ilm.framework.domain.DomainConverter;
import ilm.framework.domain.DomainGUI;
import ilm.framework.domain.DomainModel;
import ilm.framework.gui.AuthoringGUI;
import ilm.framework.gui.BaseGUI;
import ilm.framework.gui.IlmBaseGUI;
import ilm.framework.modules.IlmModule;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class SystemFactory {
    private DomainModel model;
    private DomainConverter converter;

    public final DomainModel getDomainModel(SystemConfig systemConfig) {
        if (this.model == null) {
            this.model = this.createDomainModel();
        }
        return this.model;
    }

    protected abstract DomainModel createDomainModel();

    public final DomainConverter getDomainConverter() {
        if (this.converter == null) {
            this.converter = this.createDomainConverter();
        }
        return this.converter;
    }

    protected abstract DomainConverter createDomainConverter();

    public abstract DomainGUI createDomainGUI(SystemConfig var1, DomainModel var2);

    public BaseGUI createBaseGUI(SystemConfig systemConfig, IAssignment iAssignment, SystemFactory systemFactory) {
        IlmBaseGUI ilmBaseGUI = new IlmBaseGUI();
        ilmBaseGUI.setComponents(systemConfig, iAssignment, systemFactory);
        return ilmBaseGUI;
    }

    public abstract AuthoringGUI createAuthoringGUI(DomainGUI var1, String var2, AssignmentState var3, AssignmentState var4, AssignmentState var5, HashMap var6, HashMap var7);

    public JFrame createConfigGUI(HashMap hashMap, String string) {
        return null;
    }

    public JFrame createMetadataGUI(HashMap hashMap, String string) {
        return null;
    }

    public final CommControl createCommControl(SystemConfig systemConfig) {
        return new CommControl(systemConfig);
    }

    public final AssignmentControl createAssignmentControl(SystemConfig systemConfig, ICommunication iCommunication, DomainModel domainModel, DomainConverter domainConverter) {
        AssignmentControl assignmentControl = new AssignmentControl(systemConfig, iCommunication, domainModel, domainConverter);
        for (int i = 0; i < this.getIlmModuleList().size(); ++i) {
            assignmentControl.addModule((IlmModule)this.getIlmModuleList().get(i));
        }
        return assignmentControl;
    }

    protected Vector getIlmModuleList() {
        return new Vector();
    }
}

