/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

import ilm.line.itangram2.Tangram;
import ilm.line.itangram2.TangramModelData;
import ilm.line.itangram2.TangramPiece;
import ilm.line.itangram2.TangramPosition;
import ilm.line.itangram2.TangramProperties;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class TangramPanel
extends Panel {
    private TangramPosition tangramPosition;
    private boolean onDrag = false;
    private boolean onMove = false;
    private boolean isDragging = false;
    private int xcoorArea = 0;
    private int ycoordArea = 0;
    private int xcoorArea0 = 0;
    private int ycoordArea0 = 0;
    private TangramPiece tangramPieceOnMove = null;
    private int _onMoveX0;
    private int _onMoveY0;
    private TangramPiece[] zAxisOrder;
    private TangramPiece selectedPiece = null;
    private Tangram tangram = null;
    private Applet applet = null;
    private Image offscreenImage;
    private Graphics offscreenGraphics;
    private int mouseListenerX = 0;
    private int mouseListenerY = 0;

    public TangramPosition getTangramPosition() {
        return this.tangramPosition;
    }

    protected void positionPieces(boolean bl) {
        this.tangramPosition = new TangramPosition();
        try {
            this.tangramPosition.loadFromString(TangramModelData.start_position, "position0");
        }
        catch (Exception exception) {
            System.err.println("TangramPanel.java: positionPieces(): error: " + exception);
        }
        TangramPiece[] tangramPieceArray = this.tangramPosition.getTangramPieces();
        this.zAxisOrder = new TangramPiece[7];
        for (int i = 0; i < 7; ++i) {
            this.zAxisOrder[i] = tangramPieceArray[i];
        }
    }

    public TangramPanel(Tangram tangram) {
        this.applet = tangram;
        this.tangram = tangram;
        this.setBackground(TangramProperties.TANGRAM_PANEL_BACKGROUND_COLOR);
        this.addMouseListener(new TangramPanelMouseListener());
        this.addMouseMotionListener(new TangramPanelMouseMotionListener());
        this.addKeyListener(new TangramPanelKeyListener());
        this.addFocusListener(new TangramPanelFocusListener());
        this.addComponentListener(new TangramPanelComponentListener());
        this.positionPieces(false);
    }

    public void updateOffscreenImage() {
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        if (dimension.width < 0) {
            dimension = new Dimension(280, 280);
            System.err.println("TangramPanel.updateOffscreenImage(): correcao size=" + dimension);
        }
        try {
            this.offscreenImage = this.createImage(dimension.width, dimension.height);
            this.offscreenGraphics = this.offscreenImage.getGraphics();
        }
        catch (Exception exception) {
            System.err.println("TangramPanel.updateOffscreenImage(): size=" + dimension);
            exception.printStackTrace();
        }
    }

    private void repaint(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null && rectangle2 == null) {
            return;
        }
        Rectangle rectangle3 = rectangle == null ? rectangle2 : (rectangle2 == null ? rectangle : rectangle.union(rectangle2));
        this.repaint(rectangle3.x, rectangle3.y, rectangle3.width + 1, rectangle3.height + 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.offscreenGraphics.setColor(TangramProperties.TANGRAM_PANEL_BACKGROUND_COLOR);
        this.offscreenGraphics.fillRect(0, 0, dimension.width, dimension.height);
        for (int i = 0; i < this.zAxisOrder.length; ++i) {
            if (this.isDragging) {
                this.zAxisOrder[i].translate(this.xcoorArea, this.ycoordArea);
            }
            this.zAxisOrder[i].paint(this.offscreenGraphics);
        }
        this.offscreenGraphics.setColor(TangramProperties.TANGRAM_PANEL_BACKGROUND_BORDER);
        this.offscreenGraphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawImage(this.offscreenImage, 0, 0, this);
    }

    private void selectPiece(TangramPiece tangramPiece) {
        if (this.selectedPiece != null) {
            this.selectedPiece.setSelected(false);
        }
        this.selectedPiece = tangramPiece;
        if (tangramPiece == null) {
            return;
        }
        tangramPiece.setSelected(true);
        boolean bl = false;
        for (int i = 0; i < this.zAxisOrder.length - 1; ++i) {
            if (this.zAxisOrder[i] == tangramPiece) {
                bl = true;
            }
            if (!bl) continue;
            this.zAxisOrder[i] = this.zAxisOrder[i + 1];
        }
        this.zAxisOrder[this.zAxisOrder.length - 1] = tangramPiece;
    }

    private void rotatePiece(float f) {
        if (this.selectedPiece != null) {
            Rectangle rectangle = this.selectedPiece.getBounds();
            this.selectedPiece.rotate(f);
            Rectangle rectangle2 = this.selectedPiece.getBounds();
            this.repaint(rectangle, rectangle2);
        }
    }

    private void translatePiece(TangramPiece tangramPiece, int n, int n2) {
        System.out.println("\n\n\nTangramPanel.java: translatePiece: " + tangramPiece.getName());
        if (this.selectedPiece != null) {
            this.selectedPiece.translate(n, n2);
        }
    }

    public void loadPosition0() {
        String string = this.tangram.getProperties("position0");
        if (string == null || string == "") {
            return;
        }
        TangramModelData.start_position = string;
        this.repaint();
    }

    class TangramPanelComponentListener
    extends ComponentAdapter {
        TangramPanelComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            TangramPanel.this.updateOffscreenImage();
        }
    }

    class TangramPanelFocusListener
    extends FocusAdapter {
        TangramPanelFocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            Rectangle rectangle = null;
            if (TangramPanel.this.selectedPiece == null) {
                return;
            }
            rectangle = TangramPanel.this.selectedPiece.getBounds();
            TangramPanel.this.selectPiece(null);
            TangramPanel.this.repaint(rectangle, null);
        }
    }

    class TangramPanelKeyListener
    extends KeyAdapter {
        TangramPanelKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 37) {
                if (TangramPanel.this.tangram.getTangramControls().getRotationCheckState()) {
                    TangramPanel.this.rotatePiece(15.0f);
                } else {
                    TangramPanel.this.rotatePiece(45.0f);
                }
            } else if (n == 39) {
                if (TangramPanel.this.tangram.getTangramControls().getRotationCheckState()) {
                    TangramPanel.this.rotatePiece(-15.0f);
                } else {
                    TangramPanel.this.rotatePiece(-45.0f);
                }
            }
        }
    }

    class TangramPanelMouseMotionListener
    extends MouseMotionAdapter {
        TangramPanelMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (TangramPanel.this.tangramPieceOnMove == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TangramPanel.this.tangramPieceOnMove.translate(n - TangramPanel.this._onMoveX0, n2 - TangramPanel.this._onMoveY0);
            TangramPanel.this._onMoveX0 = n;
            TangramPanel.this._onMoveY0 = n2;
            TangramPanel.this.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = 4;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (n2 < n) {
                n2 = n;
            }
            if (n3 < n) {
                n3 = n;
            }
            if (TangramPanel.this.selectedPiece == null) {
                TangramPanel.this.xcoorArea = n2 - TangramPanel.this.xcoorArea0;
                TangramPanel.this.ycoordArea = n3 - TangramPanel.this.ycoordArea0;
                TangramPanel.this.xcoorArea0 = n2;
                TangramPanel.this.ycoordArea0 = n3;
                TangramPanel.this.isDragging = true;
                TangramPanel.this.repaint();
                return;
            }
            TangramPanel.this.isDragging = false;
            TangramPanel.this.onDrag = true;
            TangramPanel.this.tangramPieceOnMove = null;
            Dimension dimension = TangramPanel.this.getSize();
            if (n2 > dimension.width - n) {
                n2 = dimension.width - n;
            }
            if (n3 > dimension.height - n) {
                n3 = dimension.height - n;
            }
            Rectangle rectangle = TangramPanel.this.selectedPiece.getBounds();
            TangramPanel.this.translatePiece(TangramPanel.this.selectedPiece, n2 - TangramPanel.this.mouseListenerX, n3 - TangramPanel.this.mouseListenerY);
            Rectangle rectangle2 = TangramPanel.this.selectedPiece.getBounds();
            TangramPanel.this.repaint(rectangle, rectangle2);
            TangramPanel.this.mouseListenerX = n2;
            TangramPanel.this.mouseListenerY = n3;
            if (TangramPanel.this.tangramPieceOnMove != null) {
                TangramPanel.this.tangramPieceOnMove = null;
            }
        }
    }

    class TangramPanelMouseListener
    extends MouseAdapter {
        TangramPanelMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TangramPanel.this.isDragging = false;
            TangramPanel.this.xcoorArea0 = n;
            TangramPanel.this.ycoordArea0 = n2;
            for (int i = TangramPanel.this.zAxisOrder.length - 1; i >= 0; --i) {
                TangramPiece tangramPiece = TangramPanel.this.zAxisOrder[i];
                if (!tangramPiece.contains(n, n2)) continue;
                TangramPanel.this.mouseListenerX = n;
                TangramPanel.this.mouseListenerY = n2;
                if (tangramPiece == TangramPanel.this.selectedPiece) {
                    if (TangramPanel.this.tangramPieceOnMove != null) {
                        TangramPanel.this.tangramPieceOnMove = null;
                    } else {
                        TangramPanel.this.tangramPieceOnMove = tangramPiece;
                        TangramPanel.this.onMove = true;
                        TangramPanel.this._onMoveX0 = n;
                        TangramPanel.this._onMoveY0 = n2;
                    }
                    return;
                }
                Rectangle rectangle = null;
                if (TangramPanel.this.selectedPiece != null) {
                    rectangle = TangramPanel.this.selectedPiece.getBounds();
                }
                TangramPanel.this.selectPiece(tangramPiece);
                Rectangle rectangle2 = TangramPanel.this.selectedPiece.getBounds();
                TangramPanel.this.repaint(rectangle, rectangle2);
                TangramPanel.this.tangramPieceOnMove = tangramPiece;
                TangramPanel.this.onMove = true;
                TangramPanel.this._onMoveX0 = n;
                TangramPanel.this._onMoveY0 = n2;
                return;
            }
            Rectangle rectangle = null;
            if (TangramPanel.this.tangramPieceOnMove != null) {
                TangramPanel.this.tangramPieceOnMove = null;
                TangramPanel.this.onMove = false;
            }
            if (TangramPanel.this.selectedPiece == null) {
                return;
            }
            rectangle = TangramPanel.this.selectedPiece.getBounds();
            TangramPanel.this.selectPiece(null);
            TangramPanel.this.repaint(rectangle, null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            int n;
            if (TangramPanel.this.selectedPiece == null && TangramPanel.this.tangramPieceOnMove == null) {
                TangramPanel.this.onMove = false;
                TangramPanel.this.onDrag = false;
                return;
            }
            if (TangramPanel.this.tangramPieceOnMove != null && !TangramPanel.this.onDrag && TangramPanel.this.onMove) {
                return;
            }
            if (TangramPanel.this.tangramPieceOnMove == null && !TangramPanel.this.onDrag && TangramPanel.this.onMove) {
                TangramPanel.this.tangram.setCountPC();
            } else if (TangramPanel.this.selectedPiece != null && TangramPanel.this.onDrag) {
                TangramPanel.this.tangram.setCountDD();
            }
            Point point = null;
            for (n = TangramPanel.this.zAxisOrder.length - 1; n >= 0; --n) {
                object = TangramPanel.this.zAxisOrder[n];
                if (object == TangramPanel.this.selectedPiece) continue;
                if (TangramPanel.this.selectedPiece != null) {
                    point = ((TangramPiece)object).snap(TangramPanel.this.selectedPiece);
                }
                if (point != null) break;
            }
            if (point != null) {
                Rectangle rectangle = null;
                if (TangramPanel.this.selectedPiece != null) {
                    rectangle = TangramPanel.this.selectedPiece.getBounds();
                }
                TangramPanel.this.translatePiece(TangramPanel.this.selectedPiece, point.x, point.y);
                object = TangramPanel.this.selectedPiece.getBounds();
                TangramPanel.this.repaint(rectangle, (Rectangle)object);
            }
            if ((n = (int)(TangramPanel.this.tangram.comparePositionWithModel(false, true) ? 1 : 0)) != 0) {
                TangramPanel.this.tangramPieceOnMove = null;
            }
            if (TangramPanel.this.tangramPieceOnMove != null && !TangramPanel.this.onDrag && TangramPanel.this.onMove) {
                TangramPanel.this.onMove = false;
            } else if (TangramPanel.this.selectedPiece != null && TangramPanel.this.onDrag) {
                TangramPanel.this.onDrag = false;
            }
        }
    }
}

