/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

import ilm.line.itangram2.Tangram;
import ilm.line.itangram2.TangramModelData;
import ilm.line.itangram2.TangramPosition;
import ilm.line.itangram2.TangramProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Polygon;

class TangramModel
extends Panel {
    private static final int WIDTH = 260;
    private static final int HEIGHT = 320;
    private static final int DX = 2;
    private static final int DY = 2;
    private Tangram tangram;
    private TangramPosition modelPosition;
    private TangramModelData modelData;
    private int xmargin = 0;
    private int ymargin = 0;
    private Image offscreenImage = null;
    private Graphics offscreenGraphics;
    private Dimension lastDimension = null;

    public TangramPosition getTangramPosition() {
        return this.modelPosition;
    }

    public TangramModel(Tangram tangram) {
        this.tangram = tangram;
        this.modelData = new TangramModelData();
        try {
            TangramModelData.loadFromProperties(tangram);
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ": TangramModel(Tangram): modelData.loadFromProperties()");
            System.err.println("Exception Caught Loading the Models: " + exception);
            exception.printStackTrace();
        }
        this.modelPosition = new TangramPosition();
        this.setBackground(TangramProperties.MODEL_BACKGROUND_COLOR);
    }

    public String getCurrentModel() throws Exception {
        return this.modelData.getCurrentModel();
    }

    public String getModelDescription() throws Exception {
        return this.modelData.getModelDescription();
    }

    public void setCurrentModel(String string, String string2) throws Exception {
        TangramModelData.setPosition(string);
        TangramModelData.setDescription(string2);
    }

    public void loadModelPosition(String string) throws Exception {
        this.modelPosition.loadFromString(string, "model");
        this.computeMargin();
        String string2 = null;
        if (this.tangram.getProperties("model") == null) {
            System.out.println("TangramModel.java: loadModelPosition(" + string + "): property model undefined");
            this.tangram.setProperties("model", "");
        }
        string2 = this.tangram.getProperties("model");
        this.tangram.setProperties("model", string);
        System.out.println("TangramModel.java: loadModelPosition(" + string + "): getProperties(\"model\") changed from: " + string2 + ", to: " + this.tangram.getProperties("model") + "\n----------");
        this.repaint();
    }

    public String loadCurrentModel() throws Exception {
        this.loadModelPosition(this.modelData.getCurrentModel());
        return this.modelData.getModelDescription();
    }

    public String loadPrevModel() throws Exception {
        this.loadModelPosition(this.modelData.getPrevModel());
        return this.modelData.getModelDescription();
    }

    public String loadNextModel() throws Exception {
        this.loadModelPosition(this.modelData.getNextModel());
        return this.modelData.getModelDescription();
    }

    private void computeMargin() {
        int[] nArray = TangramModel.findCorrectTopCorner(this.modelPosition.getComposingUnits());
        if (nArray == null) {
            return;
        }
        this.xmargin = 4 - nArray[0] + 2;
        this.ymargin = 4 - nArray[1] + 2;
    }

    private static int[] findCorrectTopCorner(int[][] nArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray2 = new int[]{0, 0, 0, 0};
        if (nArray == null) {
            return null;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2][0];
            int n7 = nArray[n2][1];
            int n8 = nArray[n2][2];
            double d = Math.PI * (double)n8 / 180.0;
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            n5 = n / 2;
            n6 = n7 / 2;
            if (n5 < n3) {
                n3 = n5;
            }
            if (n6 < n4) {
                n4 = n6;
            }
            n5 = (n + (int)Math.round(d2 * 2.0 * 24.0)) / 2;
            n6 = (n7 + (int)Math.round(-d3 * 2.0 * 24.0)) / 2;
            if (n5 < n3) {
                n3 = n5;
            }
            if (n6 < n4) {
                n4 = n6;
            }
            n5 = (n + (int)Math.round(d3 * 2.0 * 24.0)) / 2;
            n6 = (n7 + (int)Math.round(d2 * 2.0 * 24.0)) / 2;
            if (n5 < n3) {
                n3 = n5;
            }
            if (n6 >= n4) continue;
            n4 = n6;
        }
        n2 = 4 - n3;
        n = 4 - n4;
        nArray2[0] = n3;
        nArray2[1] = n4;
        return nArray2;
    }

    private void paintUnitaryTriangle(int n, int n2, int n3, Graphics graphics) {
        double d = Math.PI * (double)n3 / 180.0;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n / 2;
        nArray2[0] = n2 / 2;
        nArray[1] = (n + (int)Math.round(d2 * 2.0 * 24.0)) / 2;
        nArray2[1] = (n2 + (int)Math.round(-d3 * 2.0 * 24.0)) / 2;
        nArray[2] = (n + (int)Math.round(d3 * 2.0 * 24.0)) / 2;
        nArray2[2] = (n2 + (int)Math.round(d2 * 2.0 * 24.0)) / 2;
        Polygon polygon = new Polygon(nArray, nArray2, 3);
        polygon.translate(this.xmargin, this.ymargin);
        this.offscreenGraphics.setColor(TangramProperties.MODEL_FILL_COLOR);
        this.offscreenGraphics.fillPolygon(polygon);
    }

    public void paint(Graphics graphics) {
        this.setSize(260, 260);
        Dimension dimension = this.getSize();
        int[][] nArray = this.modelPosition.getComposingUnits();
        if (nArray == null) {
            return;
        }
        if (this.offscreenImage == null) {
            try {
                this.offscreenImage = this.createImage(dimension.width, dimension.height);
                this.lastDimension = dimension;
                this.offscreenGraphics = this.offscreenImage.getGraphics();
            }
            catch (Exception exception) {
                System.err.println("TangramPanel.updateOffscreenImage(): size=" + dimension);
                exception.printStackTrace();
            }
        } else if (!dimension.equals(this.lastDimension)) {
            this.lastDimension = dimension;
            this.offscreenImage = this.createImage(dimension.width, dimension.height);
            this.offscreenGraphics = this.offscreenImage.getGraphics();
        }
        this.offscreenGraphics.setColor(TangramProperties.MODEL_BACKGROUND_COLOR);
        this.offscreenGraphics.fillRect(1, 1, dimension.width - 1, dimension.height - 1);
        this.offscreenGraphics.setColor(TangramProperties.TANGRAM_PANEL_BACKGROUND_BORDER);
        this.offscreenGraphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        for (int i = 0; i < nArray.length; ++i) {
            this.paintUnitaryTriangle(nArray[i][0], nArray[i][1], nArray[i][2], graphics);
        }
        graphics.drawImage(this.offscreenImage, 0, 0, this);
    }
}

