/*
 * Decompiled with CFR 0.152.
 */
package ilm.line.itangram2;

import ilm.line.itangram2.DialogHidingActionListener;
import ilm.line.itangram2.DialogHidingWindowListener;
import ilm.line.itangram2.Tangram;
import ilm.line.itangram2.TangramButton;
import ilm.line.itangram2.TangramImage;
import ilm.line.itangram2.TangramModel;
import ilm.line.itangram2.TangramProperties;
import ilm.line.util.Bundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class TangramControls
extends Panel {
    private static final int POS1 = 0;
    private static final int POS2 = 96;
    private static final int POS3 = 132;
    private static final int POS4 = 168;
    private static final boolean TRYTOSEND = false;
    private static final String strAddressToSendName = "answer";
    private static final String strAddressToSendTXT = "answer.txt";
    private static final String strAddressToSendZIP = "answer.zip";
    private static final String strAddressInServer = "http://localhost/itangram2/php/";
    private static final String CAPTION_CONTROL_PREV_BUTTON = "CAPTION_CONTROL_PREV_BUTTON";
    private static final String IMG_PREV = "img/button_prev.gif";
    private static final String CAPTION_CONTROL_NEXT_BUTTON = "CAPTION_CONTROL_NEXT_BUTTON";
    private static final String IMG_NEXT = "img/button_next.gif";
    private static final String IMG_GETCODE = "img/button_getcode.gif";
    private static final String IMG_ENTERCODE = "img/button_entercode.gif";
    private static final String CAPTION_CONTROL_GETCODE_BUTTON = "CAPTION_CONTROL_GETCODE_BUTTON";
    private static final String CAPTION_CONTROL_ENTERCODE_BUTTON = "CAPTION_CONTROL_ENTERCODE_BUTTON";
    private static final String EXPLAIN_CONTROL_GETCODE = "EXPLAIN_CONTROL_GETCODE";
    private static final String EXPLAIN_CONTROL_ENTERCODE = "EXPLAIN_CONTROL_ENTERCODE";
    private static String strNewCode = "";
    private Tangram tangram;
    private Tangram staticTangram;
    private Dialog helpDialog;
    private TextArea helpTextArea = new TextArea("", 40, 10, 1);
    private Dialog getCodeDialog;
    private TextArea getCodeTextField = null;
    private Dialog enterCodeDialog;
    private TextField enterCodeTextField = new TextField(35);
    private Checkbox rotationCheck;
    private TangramButton evaluateButton;
    private TangramButton helpButton;
    private TangramImage logoTop;
    private TangramButton prevButton;
    private TangramButton nextButton;
    private TangramButton getCodeButton;
    private TangramButton enterCodeButton;
    private Label labelPrevButton;
    private Label labelNextButton;
    private Label labelGetCodeButton;
    private Label labelEnterCodeButton;
    private String currentPositionDescription;
    private Label modelLabel;
    private Label labelButtons1;
    private Label labelButtons2;

    public boolean getRotationCheckState() {
        return this.rotationCheck.getState();
    }

    public String getCurrentPositionDescription() {
        return this.currentPositionDescription;
    }

    public String getCodePositioning(boolean bl) {
        String string = this.tangram.isAuthor() ? this.tangram.getAnswer() : this.tangram.getPosition();
        this.getCodeTextField.setText(string);
        this.tangram.centerOnFrame(this.getCodeDialog);
        this.getCodeTextField.selectAll();
        this.getCodeTextField.requestFocus();
        ((Component)this.getCodeDialog).setVisible(true);
        System.out.println("TangramControls.java: getCodePositioning(...): positioning - copy this code: " + string);
        return string;
    }

    private static void transfer() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        Object object = null;
        try {
            object = transferable.getTransferData(DataFlavor.stringFlavor);
            String string = String.valueOf(object);
            System.out.println("TangramControls.java: java.awt.datatransfer.Transferable = " + string);
        }
        catch (Exception exception) {
            System.err.println("TangramControls.java: error java.awt.datatransfer: " + exception);
        }
    }

    private Dialog buildDialog(String string, String string2, TextComponent textComponent) {
        Dialog dialog = new Dialog(this.tangram.getFrame(), string, true);
        Button button = new Button("OK");
        button.addActionListener(new DialogHidingActionListener(dialog));
        dialog.addWindowListener(new DialogHidingWindowListener(dialog));
        dialog.add("South", button);
        dialog.add("Center", textComponent);
        dialog.add("North", new Label(string2));
        ((Component)dialog).setBackground(TangramProperties.HELP_PANEL_BACKGROUND_COLOR);
        textComponent.setBackground(TangramProperties.HELP_TEXT_BACKGROUND_COLOR);
        button.setBackground(TangramProperties.HELP_TEXT_BACKGROUND_COLOR);
        textComponent.setEditable(false);
        dialog.pack();
        return dialog;
    }

    protected void treatMouseClick(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.evaluateButton) {
            System.out.println("\n-------------------------\nTangramControls.java: TangramControls: Tangram.EVALUATEBUTTON\n" + this.tangram.getAnswer() + "\n-------------------------\n");
            this.evaluateButton.setSelected(true);
            boolean bl = this.tangram.getEvaluation() == 1.0;
            String string = Bundle.msg("evalResultIs") + ": " + (bl ? Bundle.msg("evalCorrect") : Bundle.msg("evalWrong"));
            String string2 = this.tangram.getAnswer();
            System.out.println("TangramControls.java: treatMouseClick: value=" + bl + ", file=" + string2);
            String string3 = "iTangram2: " + Bundle.msg("evaluate");
            String string4 = Bundle.msg("Evaluate") + " - " + string;
            TextArea textArea = this.tangram.isAuthor() ? new TextArea(9, 80) : new TextArea(3, 80);
            textArea.setText(string);
            textArea.setEditable(true);
            Dialog dialog = this.buildDialog(string3, string4, textArea);
            ((Component)dialog).setVisible(true);
            System.out.println("TangramControls.java: ActionListener: clicou no botao avaliar!");
            this.evaluateButton.setSelected(false);
            TangramControls tangramControls = this;
            if (!tangramControls.tangram.isApplication()) {
                // empty if block
            }
        } else if (object == this.helpButton) {
            this.tangram.centerOnFrame(this.helpDialog);
            this.helpButton.setSelected(true);
            ((Component)this.helpDialog).setVisible(true);
            this.helpButton.setSelected(false);
        } else if (object == this.prevButton) {
            this.loadPrevModel();
            this.prevButton.myPaint();
        } else if (object == this.nextButton) {
            this.loadNextModel();
            this.nextButton.myPaint();
        } else if (object == this.getCodeButton) {
            this.getCodePositioning(true);
            this.getCodeButton.myPaint();
        } else if (object == this.enterCodeButton) {
            this.enterCodeTextField.setText("Z5QNPSyMlK3sE6mrox28Tcs79occ");
            System.out.println("TangramControls.java: Dialog enterCodeDialog: enterCodeTextField.setText=Z5QNPSyMlK3sE6mrox28Tcs79occ");
            this.tangram.centerOnFrame(this.enterCodeDialog);
            this.enterCodeTextField.requestFocus();
            ((Component)this.enterCodeDialog).setVisible(true);
            this.enterCodeButton.myPaint();
        }
    }

    public void loadCurrentModel() {
        try {
            String string = this.tangram.getProperties("model");
            String string2 = this.tangram.getProperties("shortname");
            if (string == null) {
                this.currentPositionDescription = this.tangram.getTangramModel().loadCurrentModel();
            } else {
                this.tangram.getTangramModel().setCurrentModel(string, string2);
                this.currentPositionDescription = this.tangram.getTangramModel().loadCurrentModel();
            }
            this.modelLabel.setText(Bundle.msg("CAPTION_CONTROL_MODEL_LABEL") + this.currentPositionDescription);
        }
        catch (Exception exception) {
            System.err.println("ilm/line/itangram2/TangramControls.java: error in loadCurrentModel(): currentPositionDescription=" + this.currentPositionDescription);
            System.err.println("Error: in current model load: " + exception);
        }
    }

    public void loadPrevModel() {
        try {
            this.currentPositionDescription = this.tangram.getTangramModel().loadPrevModel();
            this.modelLabel.setText(Bundle.msg("CAPTION_CONTROL_MODEL_LABEL") + this.currentPositionDescription);
            this.tangram.getTangramPanel().loadPosition0();
            String string = this.tangram.getTangramModel().getCurrentModel();
            this.tangram.setProperties("model", string);
        }
        catch (Exception exception) {
            System.err.println("TangramControls.java: Error: Exception: " + exception);
        }
    }

    public void loadNextModel() {
        try {
            this.currentPositionDescription = this.tangram.getTangramModel().loadNextModel();
            this.modelLabel.setText(Bundle.msg("CAPTION_CONTROL_MODEL_LABEL") + this.currentPositionDescription);
            this.tangram.getTangramPanel().loadPosition0();
            String string = this.tangram.getTangramModel().getCurrentModel();
            this.tangram.setProperties("model", string);
        }
        catch (Exception exception) {
            System.err.println("Error in control: load model: " + exception);
        }
    }

    public Insets getInsets() {
        return TangramProperties.TANGRAM_CONTROL_PANEL_INSETS;
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 10);
    }

    private static Label buildLabelSimple(String string) {
        String string2 = Bundle.msg(string);
        Label label = new Label(string2);
        label.setFont(TangramProperties.FONT_DEFAULT);
        label.setBackground(TangramProperties.TANGRAM_PANEL_BACKGROUND_BUTTONS);
        return label;
    }

    private static TangramButton buildSpecialButton(Tangram tangram, Frame frame, TangramControls tangramControls, String string, String string2) {
        TangramButton tangramButton = new TangramButton(tangram, frame, tangramControls, Bundle.msg(string), string2);
        tangramButton.setLocation(32, 32);
        tangramButton.setBackground(TangramProperties.COR_FUNDO_LOGO);
        tangramButton.setFont(TangramProperties.FONT_DEFAULT);
        return tangramButton;
    }

    private static Label buildLabel2Button(String string) {
        Label label = new Label(Bundle.msg(string));
        label.setBackground(TangramProperties.COR_FUNDO_LOGO);
        label.setFont(TangramProperties.FONT_DEFAULT);
        return label;
    }

    private static void addLocSize(Container container, Component component, int n, int n2, int n3) {
        container.add(component);
        component.setLocation(n, n2);
        if (n3 == 0) {
            component.setSize(32, 34);
        } else if (n3 == 1) {
            component.setSize(96, 34);
        } else if (n3 == 2) {
            component.setSize(276, 30);
        } else if (n3 == 3) {
            component.setSize(260, 80);
        } else {
            component.setSize(260, 80);
        }
    }

    private static Button buildButtonSimple(String string) {
        Button button = new Button(string);
        int n = string == null ? 150 : 10 + string.length() * 5;
        button.setBackground(TangramProperties.COR_FUNDO_LOGO);
        button.setFont(TangramProperties.FONT_DEFAULT);
        button.setSize(n, 50);
        return button;
    }

    public TangramControls(final Tangram tangram, TangramModel tangramModel, Frame frame) {
        this.tangram = tangram;
        this.staticTangram = tangram;
        this.setBackground(TangramProperties.CONTROLS_PANEL_BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.modelLabel = TangramControls.buildLabelSimple(Bundle.msg("CAPTION_CONTROL_MODEL_LABEL"));
        this.labelButtons1 = TangramControls.buildLabelSimple(Bundle.msg("CAPTION_CONTROL_BUTTON1"));
        this.labelButtons2 = TangramControls.buildLabelSimple(Bundle.msg("CAPTION_CONTROL_BUTTON2"));
        this.logoTop = new TangramImage(tangram, "img/img_logo_bg.gif");
        this.helpButton = new TangramButton(tangram, frame, this, "CAPTION_CONTROL_HELP_BUTTON", "img/button_help.gif");
        this.evaluateButton = new TangramButton(tangram, frame, this, "CAPTION_CONTROL_EVALUATE_BUTTON", "img/button_exerc_evaluate.gif");
        this.prevButton = TangramControls.buildSpecialButton(tangram, frame, this, CAPTION_CONTROL_PREV_BUTTON, IMG_PREV);
        this.nextButton = TangramControls.buildSpecialButton(tangram, frame, this, CAPTION_CONTROL_NEXT_BUTTON, IMG_NEXT);
        this.getCodeButton = TangramControls.buildSpecialButton(tangram, frame, this, EXPLAIN_CONTROL_GETCODE, IMG_GETCODE);
        this.enterCodeButton = TangramControls.buildSpecialButton(tangram, frame, this, EXPLAIN_CONTROL_ENTERCODE, IMG_ENTERCODE);
        this.labelPrevButton = TangramControls.buildLabel2Button(CAPTION_CONTROL_PREV_BUTTON);
        this.labelNextButton = TangramControls.buildLabel2Button(CAPTION_CONTROL_NEXT_BUTTON);
        this.labelGetCodeButton = TangramControls.buildLabel2Button(CAPTION_CONTROL_GETCODE_BUTTON);
        this.labelEnterCodeButton = TangramControls.buildLabel2Button(CAPTION_CONTROL_ENTERCODE_BUTTON);
        if (!tangram.isApplication() && !tangram.isAuthor()) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
        this.rotationCheck = new Checkbox(Bundle.msg("CAPTION_CONTROL_ROTATIONS_CHECKBOX"));
        this.rotationCheck.setFont(TangramProperties.FONT_DEFAULT);
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        panel4.setBackground(TangramProperties.COR_FUNDO_LOGO);
        panel3.setLayout(new GridLayout(0, 1, 0, 4));
        panel4.setLayout(null);
        panel4.setSize(164, 34);
        this.logoTop.setLocation(0, 0);
        this.logoTop.setSize(60, 32);
        panel4.add(this.logoTop);
        panel4.add(this.helpButton);
        this.helpButton.setLocation(96, 0);
        this.helpButton.setSize(33, 33);
        panel4.add(this.evaluateButton);
        this.evaluateButton.setLocation(132, 0);
        this.evaluateButton.setSize(33, 33);
        panel3.add(panel4);
        panel3.add(this.modelLabel);
        panel.setLayout(new BorderLayout());
        panel.add(panel3);
        Panel panel5 = new Panel(null);
        Panel panel6 = new Panel(null);
        Panel panel7 = new Panel(null);
        TangramControls.addLocSize(panel5, this.labelPrevButton, 0, 0, 1);
        TangramControls.addLocSize(panel5, this.prevButton, 98, 1, 0);
        TangramControls.addLocSize(panel5, this.nextButton, 134, 1, 0);
        TangramControls.addLocSize(panel5, this.labelNextButton, 170, 1, 1);
        TangramControls.addLocSize(panel6, this.labelGetCodeButton, 0, 0, 1);
        TangramControls.addLocSize(panel6, this.getCodeButton, 98, 1, 0);
        TangramControls.addLocSize(panel6, this.enterCodeButton, 134, 1, 0);
        TangramControls.addLocSize(panel6, this.labelEnterCodeButton, 170, 0, 1);
        TangramControls.addLocSize(panel7, this.rotationCheck, 0, 0, 2);
        panel5.setSize(256, 34);
        panel6.setSize(256, 34);
        Panel panel8 = new Panel();
        Panel panel9 = new Panel();
        Panel panel10 = new Panel();
        panel8.setLayout(new GridLayout(0, 1, 0, 0));
        panel8.setSize(260, 300);
        panel9.setLayout(new GridLayout(0, 1, 0, 0));
        panel10.setLayout(new GridLayout(0, 1, 0, 0));
        panel9.setBackground(TangramProperties.COR_FUNDO_LOGO);
        panel10.setBackground(TangramProperties.COR_FUNDO_LOGO);
        panel9.add(this.labelButtons1);
        panel9.add(panel5);
        panel10.add(this.labelButtons2);
        panel10.add(panel6);
        panel8.add(new Label(""));
        panel8.add(panel9);
        panel8.add(panel10);
        panel8.add(panel7);
        panel2.setLayout(new BorderLayout());
        panel2.add(panel8);
        this.add("North", panel);
        this.add("Center", tangramModel);
        this.add("South", panel2);
        if (this.getCodeTextField == null) {
            this.getCodeTextField = tangram.isAuthor() ? new TextArea(9, 80) : new TextArea(3, 80);
        }
        this.getCodeTextField.setEditable(true);
        String string = Bundle.msg("DIALOG_GETCODE_TITLE");
        String string2 = Bundle.msg("DIALOG_GETCODE_MESSAGE");
        TextArea textArea = this.getCodeTextField;
        this.getCodeDialog = this.buildDialog(string, string2, textArea);
        this.enterCodeDialog = new Dialog(tangram.getFrame(), Bundle.msg("DIALOG_ENTERCODE_TITLE"), true);
        Button button = TangramControls.buildButtonSimple("OK");
        Button button2 = TangramControls.buildButtonSimple(Bundle.msg("cancel"));
        button2.addActionListener(new DialogHidingActionListener(this.enterCodeDialog));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TangramModel tangramModel = TangramControls.this.staticTangram.getTangramModel();
                    strNewCode = TangramControls.this.enterCodeTextField.getText();
                    System.out.println("TangramControls.java: Model changed! From: |" + tangramModel.getCurrentModel() + "|, To: |" + strNewCode + "|");
                    tangramModel.loadModelPosition(strNewCode);
                    ((Component)TangramControls.this.enterCodeDialog).setVisible(false);
                }
                catch (Exception exception) {
                    System.err.println("TangramControls.java: TangramControls(...): error, staticTangram=" + TangramControls.this.staticTangram + ", tangram.tangrammodel=" + TangramControls.this.staticTangram.getTangramModel() + ", code=" + strNewCode + ": " + exception);
                    ((Component)TangramControls.this.enterCodeDialog).setVisible(false);
                    Dialog dialog = new Dialog(tangram.getFrame(), Bundle.msg("DIALOG_ENTERCODE_ERROR_TITLE"), true);
                    Button button = TangramControls.buildButtonSimple("OK");
                    Panel panel = new Panel();
                    panel.setBackground(TangramProperties.COR_FUNDO_LOGO);
                    button.addActionListener(new DialogHidingActionListener(dialog));
                    dialog.setLayout(new GridLayout(2, 1));
                    panel.add(button);
                    dialog.add(TangramControls.buildLabelSimple("DIALOG_ENTERCODE_ERROR_MESSAGE"));
                    dialog.add(panel);
                    dialog.pack();
                    tangram.centerOnFrame(dialog);
                    ((Component)dialog).setVisible(true);
                }
            }
        });
        this.enterCodeDialog.addWindowListener(new DialogHidingWindowListener(this.enterCodeDialog));
        Panel panel11 = new Panel(new GridLayout());
        panel11.add(button);
        panel11.add(button2);
        this.enterCodeDialog.add("South", panel11);
        this.enterCodeDialog.add("Center", this.enterCodeTextField);
        this.enterCodeDialog.add("North", TangramControls.buildLabelSimple("DIALOG_ENTERCODE_MESSAGE"));
        this.enterCodeDialog.pack();
        this.helpDialog = new Dialog(tangram.getFrame(), Bundle.msg("DIALOG_HELP_TITLE"), true);
        Button button3 = TangramControls.buildButtonSimple("OK");
        ((Component)this.helpDialog).setBackground(TangramProperties.HELP_PANEL_BACKGROUND_COLOR);
        this.helpTextArea.setBackground(TangramProperties.HELP_TEXT_BACKGROUND_COLOR);
        button3.setBackground(TangramProperties.HELP_TEXT_BACKGROUND_COLOR);
        button3.addActionListener(new DialogHidingActionListener(this.helpDialog));
        this.helpDialog.addWindowListener(new DialogHidingWindowListener(this.helpDialog));
        this.helpDialog.add("South", button3);
        this.helpDialog.add("Center", this.helpTextArea);
        this.helpDialog.pack();
        ((Component)this.helpDialog).setSize(450, 300);
        this.helpTextArea.setText(Bundle.msg("tangramVersion") + ":" + "0.4.6" + "\n" + TangramProperties.buildHelpMessage());
        this.helpTextArea.setEditable(false);
    }
}

