/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.visao;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloExercicio.visao.JanelaExercicio;
import igraf.moduloExercicio.visao.PainelBasico;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PainelComentario
extends PainelBasico
implements MouseListener,
KeyListener,
LanguageUpdatable {
    private static final Font FONTE = new Font("Arial", 1, 12);
    private static final Color COLORBACKCOMMENT = Color.white;
    private static final Color COLORBUTTONENTER = Color.darkGray;
    private static final Color COLORBUTTONFACE = Color.white;
    private static final Color COLORBUTTON = Color.gray;
    private JTextArea textArea;
    private JButton buttonTopHelp;
    private JButton buttonTopInsertComment;
    private JButton buttonTopMsgTeacher;
    private String strDiscursiveAnswer;
    private String strHelpAboutDiscursiveAnswer;
    private String textoUsuario = "";
    private String comentario;
    boolean clicked;
    private JPanel northPanel;
    private String comentarioRecebido;
    int modo;

    public PainelComentario(JanelaExercicio janelaExercicio) {
        this.janelaExercicio = janelaExercicio;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(FONTE);
        this.textArea.setBackground(EsquemaVisual.corAreaDesenho);
        this.textArea.setForeground(EsquemaVisual.corLetraAreaTexto);
        this.textArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
        this.textArea.setToolTipText(ResourceReader.msg("exercPainelComentResp2"));
        this.textArea.addKeyListener(this);
        this.add("Center", this.textArea);
        this.northPanel = new JPanel(new BorderLayout());
        this.northPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
        JPanel jPanel = this.configureMenu();
        this.northPanel.add("West", jPanel);
        this.add("North", this.northPanel);
        this.setMode(1);
    }

    private JPanel configureMenu() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 3, 2));
        this.buttonTopHelp = this.getNewButtonTop("menuAjuda", "menuAjudaTooltip");
        this.buttonTopInsertComment = this.getNewButtonTop("exercPainelComentInsComent", "exercPainelComentInsComentTooltip");
        this.buttonTopMsgTeacher = this.getNewButtonTop("exercPainelComentRec", "exercPainelComentRecTooltip");
        this.buttonTopHelp.addMouseListener(this);
        this.buttonTopInsertComment.addMouseListener(this);
        this.buttonTopMsgTeacher.addMouseListener(this);
        jPanel.add(this.buttonTopHelp);
        jPanel.add(this.buttonTopInsertComment);
        jPanel.add(this.buttonTopMsgTeacher);
        return jPanel;
    }

    private JButton getNewButtonTop(String string, String string2) {
        JButton jButton = new JButton(ResourceReader.msg(string));
        jButton.setBackground(COLORBUTTON);
        jButton.setForeground(COLORBUTTONFACE);
        jButton.setOpaque(true);
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        jButton.setToolTipText(ResourceReader.msg(string2));
        return jButton;
    }

    public void setMode(int n) {
        if (n == 1) {
            this.strHelpAboutDiscursiveAnswer = ResourceReader.msg("exercPainelComentCriar1");
            this.strDiscursiveAnswer = ResourceReader.msg("exercPainelComentCriar1");
        } else if (n == 0) {
            this.strHelpAboutDiscursiveAnswer = ResourceReader.msg("exercPainelComentResp1");
            this.strDiscursiveAnswer = "";
        }
        this.textArea.setText(this.strDiscursiveAnswer);
        this.textArea.selectAll();
        this.modo = n;
    }

    void exibeAjuda() {
        this.textArea.setText(this.strHelpAboutDiscursiveAnswer);
        this.textArea.setEditable(false);
        this.textArea.setBackground(COLORBACKCOMMENT);
    }

    void exibeComentarioEnviar() {
        this.textArea.setBackground(COLORBACKCOMMENT);
        this.textArea.setText(this.textoUsuario);
        this.textArea.setEditable(true);
    }

    public void setComentario(String string) {
        this.comentarioRecebido = string;
    }

    void exibeComentarioRecebido() {
        if (this.comentarioRecebido == null) {
            this.comentarioRecebido = ResourceReader.msg("exercPainelComentProfNaoComent");
        }
        this.textArea.setText(this.comentarioRecebido);
        this.textArea.setBackground(COLORBACKCOMMENT);
        this.textArea.setEditable(false);
    }

    public String getComentario() {
        return this.textoUsuario;
    }

    public Dimension getPreferredSize() {
        return new Dimension(630, 250);
    }

    public void reset() {
        this.textArea.setText("");
        this.textoUsuario = "";
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        jButton.setBackground(COLORBUTTONENTER);
        jButton.setForeground(COLORBUTTONFACE);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        String string = jButton.getText();
        this.clicked = true;
        if (string.equals(ResourceReader.msg("menuAjuda"))) {
            this.exibeAjuda();
        } else if (string.equals(ResourceReader.msg("exercPainelComentInsComent"))) {
            this.exibeComentarioEnviar();
        } else if (string.equals(ResourceReader.msg("exercPainelComentRec"))) {
            this.exibeComentarioRecebido();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        jButton.setBackground(COLORBUTTON);
        jButton.setForeground(COLORBUTTONFACE);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.textoUsuario = this.textArea.getText();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void updateLabels() {
        this.buttonTopHelp.setText(ResourceReader.msg("menuAjuda"));
        this.buttonTopInsertComment.setText(ResourceReader.msg("exercPainelComentInsComent"));
        this.buttonTopMsgTeacher.setText(ResourceReader.msg("exercPainelComentRec"));
        this.textArea.setToolTipText(ResourceReader.msg("exercPainelComentResp2"));
        this.buttonTopHelp.setToolTipText(ResourceReader.msg("menuAjudaTooltip"));
        this.buttonTopInsertComment.setToolTipText(ResourceReader.msg("exercPainelComentInsComentTooltip"));
        this.buttonTopMsgTeacher.setToolTipText(ResourceReader.msg("exercPainelComentRecTooltip"));
    }
}

