/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.controle;

import difusor.CommunicationFacade;
import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloExercicio.eventos.DiagnosticEvent;
import igraf.moduloExercicio.eventos.RespostaDiscursivaEvent;
import igraf.moduloExercicio.eventos.RespostaEvent;
import igraf.moduloExercicio.visao.resposta.AnswerVisualizerFrame;
import igraf.moduloExercicio.visao.resposta.Attempt;
import igraf.moduloExercicio.visao.resposta.DiscursiveAnswer;
import igraf.moduloExercicio.visao.resposta.ObjectiveAnswer;
import java.util.Vector;

public class JanelaRespostaController
extends CommunicationController {
    public static final String IGCLASSPATH = "igraf/moduloExercicio/controle/JanelaRespostaController.java";
    private Vector attemptList;
    private Vector answerList;
    private Vector gabarito;
    private AnswerVisualizerFrame avf;
    private int item;
    private int k = 1;

    public JanelaRespostaController(CommunicationFacade communicationFacade, boolean bl) {
        super(communicationFacade, bl);
        this.reset();
    }

    private void reset() {
        this.attemptList = new Vector();
        this.answerList = new Vector();
        this.gabarito = new Vector();
        this.item = 1;
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        String string = communicationEvent.getCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals(ResourceReader.msg("mexExercEval"))) {
            this.avf = new AnswerVisualizerFrame(this.attemptList);
        }
        if (communicationEvent instanceof DiagnosticEvent) {
            this.trataDiagnostico(communicationEvent);
        } else if (communicationEvent instanceof RespostaEvent && string.equals("read exercise") && !(communicationEvent instanceof RespostaDiscursivaEvent)) {
            RespostaEvent respostaEvent = (RespostaEvent)communicationEvent;
            this.gabarito.add(respostaEvent.getRespostaGabarito());
        }
    }

    private void trataDiagnostico(CommunicationEvent communicationEvent) {
        DiagnosticEvent diagnosticEvent = (DiagnosticEvent)communicationEvent;
        if (diagnosticEvent.getCommand().equals("load result")) {
            switch (diagnosticEvent.getCodigoAcao()) {
                case 607: {
                    String string = (String)this.gabarito.get(this.item - 1);
                    ObjectiveAnswer objectiveAnswer = new ObjectiveAnswer(this.item++, diagnosticEvent.getTentativa(), string, diagnosticEvent.getStatus());
                    this.answerList.add(objectiveAnswer);
                    break;
                }
                case 608: {
                    DiscursiveAnswer discursiveAnswer = new DiscursiveAnswer(diagnosticEvent.getArgumento());
                    this.answerList.add(discursiveAnswer);
                    break;
                }
                case 610: {
                    DiscursiveAnswer discursiveAnswer = new DiscursiveAnswer(diagnosticEvent.getArgumento());
                    this.answerList.add(discursiveAnswer);
                    break;
                }
                case 606: {
                    Attempt attempt = new Attempt(this.answerList, String.valueOf(this.k++));
                    this.answerList = new Vector();
                    this.attemptList.add(attempt);
                    this.item = 1;
                    break;
                }
                default: {
                    System.err.println("igraf/moduloExercicio/controle/JanelaRespostaController.java: trataDiagnostico(CommunicationEvent): ");
                    System.err.println("Error in action code: type=" + diagnosticEvent.getCodigoAcao());
                }
            }
        }
    }
}

