/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloExercicio.controle;

import difusor.CommunicationFacade;
import difusor.controle.CommunicationController;
import difusor.evento.CommunicationEvent;
import igraf.IGraf;
import igraf.basico.event.ChangeLanguageEvent;
import igraf.basico.io.GravadorLeitor;
import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.controle.ArquivoController;
import igraf.moduloCentral.eventos.EstadoTelaEvent;
import igraf.moduloCentral.eventos.GraphicOnScreenChangedEvent;
import igraf.moduloExercicio.ModuloExercicio;
import igraf.moduloExercicio.eventos.DiagnosticEvent;
import igraf.moduloExercicio.eventos.RespostaAlgebricaEvent;
import igraf.moduloExercicio.eventos.RespostaDiscursivaEvent;
import igraf.moduloExercicio.eventos.RespostaIntervaloEvent;
import igraf.moduloExercicio.eventos.RespostaNumericaEvent;
import igraf.moduloExercicio.eventos.RespostaPontoEvent;
import igraf.moduloExercicio.visao.JanelaExercicio;
import igraf.moduloExercicio.visao.PainelComentario;
import igraf.moduloExercicio.visao.PainelListaResposta;
import igraf.moduloExercicio.visao.PainelResposta;
import igraf.moduloExercicio.visao.PainelRespostaAlgebrica;
import igraf.moduloExercicio.visao.PainelRespostaIntervalo;
import igraf.moduloExercicio.visao.PainelRespostaNumerica;
import igraf.moduloExercicio.visao.PainelRespostaPonto;
import igraf.moduloInferior.visao.InfoPane;
import igraf.moduloSuperior.visao.PainelBotoes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class JanelaExercicioController
extends CommunicationController
implements ActionListener {
    public static final String IGCLASSPATH = "igraf/moduloExercicio/controle/JanelaExercicioController.java";
    private IGraf igraf;
    private PainelComentario pc;
    private static JanelaExercicio janelaExercicio;
    private PainelListaResposta painelListaResposta;
    private Vector listaFuncao;
    private PainelBotoes painelBotoes;
    private InfoPane infoPane;

    public void setPainelBotoes(PainelBotoes painelBotoes) {
        this.painelBotoes = painelBotoes;
        janelaExercicio.setPainelBotoes(painelBotoes);
    }

    public JanelaExercicioController(CommunicationFacade communicationFacade, boolean bl) {
        super(communicationFacade, bl);
        this.infoPane = ((ModuloExercicio)communicationFacade).getInfoPane();
        janelaExercicio = new JanelaExercicio(this, this.painelBotoes, this.infoPane);
        this.painelListaResposta = janelaExercicio.getPainelListaResposta();
        this.pc = janelaExercicio.getPainelComentario();
    }

    public void setIGraf(IGraf iGraf) {
        this.igraf = iGraf;
    }

    public static String showAnswerDialog() {
        janelaExercicio.setVisible(true);
        return ArquivoController.getSessao();
    }

    public void tratarEventoRecebido(CommunicationEvent communicationEvent) {
        if (communicationEvent instanceof GraphicOnScreenChangedEvent) {
            try {
                this.listaFuncao = ((GraphicOnScreenChangedEvent)communicationEvent).getListaFuncaoVisivel();
                if (this.listaFuncao == null) {
                    return;
                }
                this.painelListaResposta.setChoiceItens(this.listaFuncao);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (communicationEvent instanceof ChangeLanguageEvent) {
            if (janelaExercicio != null) {
                janelaExercicio.updateLabels();
            }
            return;
        }
        String string = communicationEvent.getCommand();
        if (string.equals("reset tab") || string.equals("reset")) {
            janelaExercicio.reset();
            this.painelListaResposta.reset();
            this.pc.reset();
        } else if (string.equals(ResourceReader.msg("mexExercCriar"))) {
            janelaExercicio.setMode(1);
            janelaExercicio.creatNewExercise();
            janelaExercicio.setVisible(true);
        } else if (string.equals(ResourceReader.msg("mexExercEditar"))) {
            janelaExercicio.setMode(1);
            janelaExercicio.setVisible(true);
        } else {
            if (string.equals(ResourceReader.msg("mexExercResp"))) {
                JanelaExercicioController.showAnswerDialog();
                return;
            }
            if (string.equals("report limits")) {
                EstadoTelaEvent estadoTelaEvent = (EstadoTelaEvent)communicationEvent;
                this.painelListaResposta.setLimits(estadoTelaEvent.getXMin(), estadoTelaEvent.getXMax());
            } else if (string.equals("read exercise")) {
                janelaExercicio.setMode(0);
                if (communicationEvent instanceof RespostaAlgebricaEvent) {
                    RespostaAlgebricaEvent respostaAlgebricaEvent = (RespostaAlgebricaEvent)communicationEvent;
                    PainelRespostaAlgebrica painelRespostaAlgebrica = new PainelRespostaAlgebrica(janelaExercicio, respostaAlgebricaEvent.getNumQuest(), respostaAlgebricaEvent.getStart(), respostaAlgebricaEvent.getEnd(), respostaAlgebricaEvent.getRespostaGabarito());
                    this.painelListaResposta.inserePainelResposta(painelRespostaAlgebrica);
                    janelaExercicio.atualizarDimensoes();
                    this.painelListaResposta.addToNumberOfAnswers(4);
                } else if (communicationEvent instanceof RespostaNumericaEvent) {
                    RespostaNumericaEvent respostaNumericaEvent = (RespostaNumericaEvent)communicationEvent;
                    PainelRespostaNumerica painelRespostaNumerica = new PainelRespostaNumerica(janelaExercicio, respostaNumericaEvent.getRespostaGabarito(), respostaNumericaEvent.getNumQuest());
                    this.painelListaResposta.inserePainelResposta(painelRespostaNumerica);
                    janelaExercicio.atualizarDimensoes();
                    this.painelListaResposta.addToNumberOfAnswers(1);
                } else if (communicationEvent instanceof RespostaIntervaloEvent) {
                    RespostaIntervaloEvent respostaIntervaloEvent = (RespostaIntervaloEvent)communicationEvent;
                    PainelRespostaIntervalo painelRespostaIntervalo = new PainelRespostaIntervalo(janelaExercicio, respostaIntervaloEvent.getNumQuest(), respostaIntervaloEvent.getInf(), respostaIntervaloEvent.getSup(), respostaIntervaloEvent.getX1(), respostaIntervaloEvent.getX2());
                    this.painelListaResposta.inserePainelResposta(painelRespostaIntervalo);
                    janelaExercicio.atualizarDimensoes();
                    this.painelListaResposta.addToNumberOfAnswers(3);
                } else if (communicationEvent instanceof RespostaPontoEvent) {
                    RespostaPontoEvent respostaPontoEvent = (RespostaPontoEvent)communicationEvent;
                    PainelRespostaPonto painelRespostaPonto = new PainelRespostaPonto(janelaExercicio, respostaPontoEvent.getNumQuest(), respostaPontoEvent.getX1(), respostaPontoEvent.getX2());
                    this.painelListaResposta.inserePainelResposta(painelRespostaPonto);
                    janelaExercicio.atualizarDimensoes();
                    this.painelListaResposta.addToNumberOfAnswers(5);
                } else if (communicationEvent instanceof RespostaDiscursivaEvent) {
                    RespostaDiscursivaEvent respostaDiscursivaEvent = (RespostaDiscursivaEvent)communicationEvent;
                    this.pc.setComentario(respostaDiscursivaEvent.getComentario());
                    this.painelListaResposta.addToNumberOfAnswers(2);
                }
            }
        }
    }

    public void actionPerformedItemStateChanged(JComboBox jComboBox, ActionEvent actionEvent) {
        try {
            int n = 0;
            if (jComboBox != null) {
                n = jComboBox.getSelectedIndex();
            } else {
                System.err.println("\nError: in exercise window controller: ItemEvent " + actionEvent.getClass().getName() + ": choice is " + jComboBox + "!!");
            }
            if (n != 0) {
                janelaExercicio.alteraPainelResposta(n);
                if (n == 4) {
                    this.enviarEvento(new RespostaAlgebricaEvent(this));
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error: in exercise window controller: " + actionEvent.getClass().getName() + ": " + exception);
            exception.printStackTrace();
        }
    }

    private void enviaEventoResposta(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            PainelResposta painelResposta = (PainelResposta)vector.get(i);
            if (painelResposta instanceof PainelRespostaAlgebrica) {
                this.enviarEvento(new RespostaAlgebricaEvent(this, painelResposta.getResposta()));
                continue;
            }
            if (painelResposta instanceof PainelRespostaNumerica) {
                this.enviarEvento(new RespostaNumericaEvent(this, painelResposta.getResposta()));
                continue;
            }
            if (painelResposta instanceof PainelRespostaIntervalo) {
                this.enviarEvento(new RespostaIntervaloEvent(this, painelResposta.getResposta()));
                continue;
            }
            if (!(painelResposta instanceof PainelRespostaPonto)) continue;
            this.enviarEvento(new RespostaPontoEvent(this, painelResposta.getResposta()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            this.actionPerformedButtonCliked(((JButton)actionEvent.getSource()).getActionCommand(), actionEvent);
        } else if (object instanceof JComboBox) {
            this.actionPerformedItemStateChanged((JComboBox)actionEvent.getSource(), actionEvent);
        }
    }

    private void actionPerformedButtonCliked(String string, ActionEvent actionEvent) {
        System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: evaluation=" + this.igraf.getEvaluation());
        boolean bl = this.painelListaResposta.dadosValidos();
        System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: validData=" + bl);
        if (!bl) {
            System.err.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: ");
            System.err.println("Error: it is missing some answer... Cancel the evaluation and submission");
            return;
        }
        System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: OK");
        if (string.equals(ResourceReader.msg("exercFQRCGabarito")) && bl) {
            this.enviaEventoResposta(this.painelListaResposta.getListaResposta());
            if (janelaExercicio.getComentario().length() > 0) {
                this.enviarEvento(new RespostaDiscursivaEvent(janelaExercicio.getComentario(), this, 605));
            }
        } else {
            System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: NAO professor");
        }
        System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: strCommandAction=" + string + "=" + ResourceReader.msg("exercFQRCGabarito") + "?");
        if (string.equals(ResourceReader.msg("exercFQRCGabarito")) && bl) {
            System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: entrou confirma");
            DiagnosticEvent diagnosticEvent = new DiagnosticEvent(this, "send result", "", 606);
            diagnosticEvent.setResultado(this.painelListaResposta.responder());
            this.enviaEventoRespostaAluno(this.painelListaResposta.getListaRespostaAluno());
            System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: apos lancar DiagnosticEvent: #" + janelaExercicio.getComentario().length());
            if (janelaExercicio.getComentario().length() > 0) {
                this.enviarEvento(new RespostaDiscursivaEvent(janelaExercicio.getComentario(), this, 610));
            }
            diagnosticEvent.setNumAcertos(this.painelListaResposta.getTotalAcertos());
            diagnosticEvent.setNumErros(this.painelListaResposta.getTotalErros());
            System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: acertos=" + this.painelListaResposta.getTotalAcertos() + ", erros=" + this.painelListaResposta.getTotalErros());
            try {
                this.painelListaResposta.limparCampos();
                System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: limpou. modulo=" + this.getModulo().getClass().getName());
                this.enviarEvento(diagnosticEvent);
                System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: enviou");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string2 = this.igraf.getAnswer(true);
            int n = (int)this.igraf.getEvaluation();
            System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: evaluationInt=" + n + "=" + this.igraf.getEvaluation() + "\nContent=\n" + string2);
            int n2 = GravadorLeitor.enviarResultadoExercicio(this.igraf, string2, n);
            System.out.println("src/igraf/moduloExercicio/controle/JanelaExercicioController.java: resultSend=" + n2);
            System.out.println("igraf/moduloExercicio/controle/JanelaExercicioController.java: evaluation=" + n);
        }
        janelaExercicio.fechaJanela();
    }

    private void enviaEventoRespostaAluno(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            this.enviarEvento(new DiagnosticEvent(this, "send result", string, 607));
        }
    }
}

