/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.plotter;

import difusor.evento.CommunicationEvent;
import igraf.IGraf;
import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.controle.AreaDesenhoController;
import igraf.moduloCentral.eventos.EstadoTelaEvent;
import igraf.moduloCentral.eventos.GraphicOnScreenChangedEvent;
import igraf.moduloCentral.visao.AreaDesenho;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Timer;
import java.util.TimerTask;

public abstract class Plotter
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final String IGCLASSPATH = "igraf/moduloCentral/visao/plotter/Plotter.java";
    private static int staticCounter = 0;
    private int ID = staticCounter++;
    int width = 0;
    int height = 0;
    int zoomDif = 2;
    int oldX;
    int oldY;
    int newX;
    int newY;
    protected int xmin;
    protected int xmax;
    protected int ymin;
    protected int ymax;
    protected int escala = 60;
    protected int passo = 50;
    protected int passoMinimo = 50;
    protected int ordem = 0;
    private int translationX = 0;
    private int translationY = 0;
    private boolean definirOrigemPadrao = true;
    protected static boolean cursorSobreTexto;
    boolean mouseOverPoint = false;
    protected Component father;
    private static final Color laranja;
    private static final Color roxo;
    private static final Color bordo;
    private static final Color marinho;
    private static final Color marrom;
    protected static final Color[] colorList;
    protected static final String[] colorNames;
    public static final int escalaPadrao = 60;
    private int colorIndex = 0;
    protected AreaDesenhoController adc;
    private final int mouseDragging = 0;
    private final int arrowPressed = 1;
    EstadoTelaEvent ete;
    long delay = 500L;
    private float eps = 0.05f;
    protected boolean drawHotPoint;
    protected int hotPointX;
    protected int hotPointY;
    boolean isHotPointOn = true;
    private boolean paintMode = false;
    Timer timer;
    int counter = 0;

    public int getID() {
        return this.ID;
    }

    protected int getTranslationX() {
        return this.translationX;
    }

    protected int getTranslationY() {
        return this.translationY;
    }

    public int getXMax() {
        return this.xmax + this.translationX;
    }

    public int getXMin() {
        return this.xmin + this.translationX;
    }

    public int getEscala() {
        return this.escala;
    }

    protected Color getNextColor() {
        return colorList[this.colorIndex++ % colorList.length];
    }

    protected Color getColor(int n) {
        return colorList[n];
    }

    public void dimensiona(Graphics2D graphics2D, int n, int n2) {
        if (this.definirOrigemPadrao || n != this.width || n2 != this.height) {
            this.width = n;
            this.height = n2;
            this.xmax = n / 2;
            this.xmin = -this.xmax;
            this.ymax = n2 / 2;
            this.ymin = -this.ymax;
        }
        this.definirOrigemPadrao = false;
    }

    public void resetOrigem() {
        this.definirOrigemPadrao = true;
        this.notificaAlteracaoTela();
    }

    public void vertical(int n, int n2) {
        this.translationY -= n;
        if (n2 == 0) {
            this.sendTimedEvent(new SendEventTask());
        }
        if (n2 == 1) {
            this.notificaAlteracaoTela();
        }
    }

    protected void setPosVertical(int n) {
        this.translationY = n;
    }

    public void horizontal(int n, int n2) {
        this.translationX += n;
        if (n2 == 0) {
            this.sendTimedEvent(new SendEventTask());
        }
        if (n2 == 1) {
            this.notificaAlteracaoTela();
        }
    }

    protected void setPosHorizontal(int n) {
        this.translationX = n;
    }

    public void home() {
        this.translationY = 0;
        this.translationX = 0;
        this.resetOrigem();
    }

    public Point getCoordenadasOrigem() {
        return new Point(this.translationX, this.translationY);
    }

    public void zoom(int n) {
        this.sendTimedEvent(new SendEventTask());
        this.escala += n;
        if (this.escala < 20) {
            this.escala = 20;
        }
    }

    protected void setEscala(int n) {
        this.escala = n;
    }

    protected void sendTimedEvent(TimerTask timerTask) {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(timerTask, this.delay, 100L);
        } else if (this.counter > 0) {
            this.counter = 0;
        }
    }

    private void notificaAlteracaoTela() {
        this.ete = new EstadoTelaEvent(this, new Point(this.translationX, this.translationY), this.escala);
        this.ete.setCommand("change cartesian plane");
        this.enviarEvento(this.ete);
    }

    public void zoomPadrao() {
        this.escala = 60;
        this.notificaAlteracaoTela();
    }

    public void mudaEstadoTela(EstadoTelaEvent estadoTelaEvent) {
        if (!IGraf.loading) {
            return;
        }
        Point point = estadoTelaEvent.getCoordenadasOrigem();
        if (point == null) {
            return;
        }
        this.setEscala(estadoTelaEvent.getEscala());
        this.setPosHorizontal(estadoTelaEvent.getCoordenadasOrigem().x);
        this.setPosVertical(estadoTelaEvent.getCoordenadasOrigem().y);
        this.notifyScreenChanged();
    }

    public int normalizaX(int n) {
        int n2 = n + this.width / 2 - this.translationX;
        return n2;
    }

    protected int reverteNormalizaX(int n) {
        int n2 = n + this.translationX - this.width / 2;
        return n2;
    }

    public int normalizaY(int n) {
        int n2 = this.height / 2 - n - this.translationY;
        return n2;
    }

    protected int reverteNormalizaY(int n) {
        int n2 = this.height / 2 - n - this.translationY;
        return -n2;
    }

    public float xPixelToReal(int n) {
        return (float)(n - this.xmax + this.translationX) / (float)this.escala;
    }

    public float yPixelToReal(int n) {
        return (float)(this.ymax - n - this.translationY) / (float)this.escala;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!cursorSobreTexto) {
            if (this.drawHotPoint) {
                this.zoom(n - this.oldX);
                this.setHotCoordinates(mouseEvent);
            } else if (!this.mouseOverPoint) {
                this.horizontal(this.oldX - n, 0);
                this.vertical(n2 - this.oldY, 0);
            }
        }
        this.oldX = n;
        this.oldY = n2;
        this.enviarEvento(new GraphicOnScreenChangedEvent(this, "clear screen"));
        ((AreaDesenho)mouseEvent.getSource()).atualizaDesenho();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.oldX = mouseEvent.getX();
        this.oldY = mouseEvent.getY();
        ((Component)mouseEvent.getSource()).requestFocus();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.mouseOverPoint) {
            if (this.overHotPoint(mouseEvent)) {
                this.setHotCoordinates(mouseEvent);
            } else if (this.drawHotPoint) {
                this.drawHotPoint = false;
            }
        }
        this.refazDesenho();
    }

    public void refazDesenho() {
        if (this.drawHotPoint == this.isHotPointOn) {
            this.isHotPointOn = !this.isHotPointOn;
        }
        this.father.repaint();
    }

    private void setHotCoordinates(MouseEvent mouseEvent) {
        this.hotPointX = this.normalizaX(Math.round(this.xPixelToReal(mouseEvent.getX())) * this.escala);
        this.hotPointY = this.normalizaY(Math.round(this.yPixelToReal(mouseEvent.getY())) * this.escala);
    }

    private boolean overHotPoint(MouseEvent mouseEvent) {
        if (Math.abs((float)Math.round(this.xPixelToReal(mouseEvent.getX())) - this.xPixelToReal(mouseEvent.getX())) < this.eps && Math.abs((float)Math.round(this.yPixelToReal(mouseEvent.getY())) - this.yPixelToReal(mouseEvent.getY())) < this.eps) {
            this.drawHotPoint = true;
            return true;
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 36) {
            this.home();
        } else if (n == 37) {
            this.horizontal(15, 1);
        } else if (n == 39) {
            this.horizontal(-15, 1);
        } else if (n == 38) {
            this.vertical(-15, 1);
        } else if (n == 40) {
            this.vertical(15, 1);
        } else if (n == 107) {
            this.zoom(4);
        } else if (n == 109) {
            this.zoom(-4);
        } else if (n == 78 && keyEvent.isAltDown()) {
            this.zoomPadrao();
        } else {
            keyEvent.consume();
            return;
        }
        this.refazDesenho();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.drawHotPoint = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.father == null) {
            this.father = (Component)mouseEvent.getSource();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void reportLimits() {
        this.adc.enviarEvento(new EstadoTelaEvent(this));
    }

    public void setController(AreaDesenhoController areaDesenhoController) {
        this.adc = areaDesenhoController;
    }

    public void enviarEvento(CommunicationEvent communicationEvent) {
        this.adc.enviarEvento(communicationEvent);
    }

    public abstract void notifyScreenChanged();

    public abstract void desenha(Graphics2D var1, int var2, int var3);

    public abstract int getCorDesenho(String var1);

    public abstract void iniciaAnimacao(boolean var1);

    public void setPaintMode(boolean bl) {
        this.paintMode = bl;
    }

    public boolean isInPaintMode() {
        return this.paintMode;
    }

    static {
        laranja = EsquemaVisual.COLOR_laranja;
        roxo = EsquemaVisual.COLOR_roxo;
        bordo = EsquemaVisual.COLOR_bordo;
        marinho = EsquemaVisual.COLOR_marinho;
        marrom = EsquemaVisual.COLOR_marrom;
        colorList = new Color[]{Color.blue, Color.black, marinho, Color.red, laranja, roxo, Color.darkGray, bordo, marrom};
        colorNames = new String[]{"azul", "preto", "marinho", "vermelho", "laranja", "roxo", "cinza-escuro", "azul-claro", "marrom"};
    }

    class SendEventTask
    extends TimerTask {
        SendEventTask() {
        }

        public void run() {
            ++Plotter.this.counter;
            if (Plotter.this.counter > 4) {
                try {
                    Plotter.this.notificaAlteracaoTela();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                Plotter.this.timer.cancel();
                Plotter.this.timer = null;
            }
        }
    }
}

