/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.visao.desenho;

import igraf.basico.util.EsquemaVisual;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.plotter.Plotter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.StringTokenizer;

public class DesenhoTexto
extends Desenho {
    private static final Font FONT = new Font("Arial", 0, 11);
    private String strTextInArea;
    private int line;
    private int fontSize = 11;
    private int width = 0;
    private int left;
    private int top;
    private int height;
    private int id;
    float x;
    float y;
    private FontMetrics fm;
    private Color colorFont;
    private Color fontColor = Color.black;
    private Color corMoldura = Color.lightGray;
    private Font font = FONT;
    private Font font2;
    private boolean destaca = false;
    boolean borda;

    public DesenhoTexto(Plotter plotter, String string, int n) {
        super(plotter, 1);
        this.setText(string);
        this.id = n;
    }

    public String getText() {
        return this.strTextInArea;
    }

    public void setText(String string) {
        this.strTextInArea = string;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.font = new Font("Arial", 0, n);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFrameColor(Color color) {
        this.corMoldura = color;
    }

    private void setDestaca(boolean bl) {
        this.destaca = bl;
    }

    private void enquadraString(String string, Graphics2D graphics2D) {
        String string2 = string;
        this.fm = graphics2D.getFontMetrics();
        this.line = this.fm.getHeight();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (this.destaca) {
                graphics2D.setColor(EsquemaVisual.corHighlightText);
                graphics2D.drawString(string3, this.left, this.top + this.height);
            } else {
                graphics2D.setColor(this.fontColor);
                graphics2D.drawString(string3, this.left, this.top + this.height);
            }
            this.width = Math.max(this.width, this.fm.stringWidth(string3) + 10);
            this.height += this.line;
        }
        if (this.destaca) {
            this.desenhaBorda(graphics2D);
        }
    }

    private void desenhaBorda(Graphics2D graphics2D) {
        if (this.borda) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(EsquemaVisual.corHighlightTextBorder);
            graphics2D.drawRect(this.left - 4, this.top - this.line + 10, this.width, this.height);
            graphics2D.setColor(color);
        }
    }

    public void atualizaDesenho(Graphics2D graphics2D) {
        this.line = 0;
        this.height = 15;
        this.colorFont = graphics2D.getColor();
        this.font2 = graphics2D.getFont();
        graphics2D.setFont(this.font);
        this.updatePosition();
        this.enquadraString(this.strTextInArea, graphics2D);
        graphics2D.setColor(this.colorFont);
        graphics2D.setFont(this.font2);
    }

    public void updatePosition() {
        this.left = this.plotter.normalizaX((int)(this.x * (float)this.plotter.getEscala()));
        this.top = this.plotter.normalizaY((int)(this.y * (float)this.plotter.getEscala()));
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setFont(Font font) {
        this.font = font != null ? font : font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getFuncaoAtual() {
        return "";
    }

    public boolean matchCoordinates(int n, int n2) {
        n = this.plotter.normalizaX(n);
        n2 = this.plotter.normalizaY(-n2);
        if (n >= this.left - 2 && n < this.left + this.width - 8 && n2 >= this.top + 5 && n2 < this.top + this.height + 2) {
            this.destacar(true);
            return true;
        }
        this.destacar(false);
        return false;
    }

    private void destacar(boolean bl) {
        this.borda = bl;
        this.destaca = bl;
    }

    public void setTextSelected() {
        this.setFontColor(Color.gray);
    }

    public int getTextIndex() {
        return this.id;
    }

    public String toString() {
        return this.strTextInArea;
    }
}

