/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.eventos.menu;

import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloArquivo.eventos.EventoRegistravel;
import igraf.moduloCentral.controle.desenho.DesenhoPoligonoController;
import igraf.moduloCentral.eventos.ModuloCentralDisseminavelEvent;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class IgrafMenuPoligonoEvent
extends CommunicationEvent
implements ModuloCentralDisseminavelEvent,
EventoRegistravel {
    public static final String P_PAINT_MODE = ResourceReader.msg("mepPintaPoli");
    public static final String UNDO = "undo_polygon";
    public static final String REDO = "redo_polygon";
    public static final String DRAW_POLYGON = "draw_polygon";
    public static final String LOAD_POLYGON = "load_polygon";
    private String argumento = "";
    private DesenhoPoligonoController dpc;
    private String polygonType;
    private String fillingMode;
    private String strLineColor;
    private String strFillColor;
    private String vertexList;
    private String vertexMode;

    public IgrafMenuPoligonoEvent(Object object) {
        super(object);
    }

    public IgrafMenuPoligonoEvent(String string, Object object) {
        super(object, string);
    }

    public IgrafMenuPoligonoEvent(Object object, String string) {
        super(object, string);
        this.dpc = (DesenhoPoligonoController)object;
        this.argumento = String.valueOf(this.dpc.getVertexMode()) + "; " + String.valueOf(this.dpc.getPolygonType()) + "; " + this.dpc.getFillingMode() + "; " + this.dpc.getLineColorToStringRGB() + "; " + this.dpc.getFillColorToStringRGB() + "; " + this.dpc.getVertexList();
    }

    public IgrafMenuPoligonoEvent(Object object, String string, String string2) {
        super(object, string);
        this.parseLoadingArgument(string2);
    }

    private void parseLoadingArgument(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        try {
            this.vertexMode = stringTokenizer.nextToken();
            this.polygonType = stringTokenizer.nextToken();
            this.fillingMode = stringTokenizer.nextToken();
            this.strLineColor = stringTokenizer.nextToken();
            this.strFillColor = stringTokenizer.nextToken();
            this.vertexList = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            String string2 = "Arquivo contendo pol\u00edgono com sintaxe de registro incorreta.";
            JOptionPane.showMessageDialog(null, string2, "Erro no carregamento do arquivo", 2);
            return;
        }
        this.argumento = this.polygonType + "; " + this.fillingMode + "; " + this.strLineColor + "; " + this.strFillColor + "; " + this.vertexList;
    }

    public int getVertexMode() {
        int n = 0;
        try {
            n = Integer.parseInt(this.vertexMode.trim());
        }
        catch (Exception exception) {
            System.err.println("O modo de entrada de v\u00e9rtices deve ser 0 (real) ou 1 (inteiro).");
            exception.printStackTrace();
        }
        return n;
    }

    public int getPolygonType() {
        int n = 0;
        try {
            n = Integer.parseInt(this.polygonType.trim());
        }
        catch (Exception exception) {
            System.err.println("O tipo do pol\u00edgono deve ser 0 (irregular) ou 1 (regular).");
            exception.printStackTrace();
        }
        return n;
    }

    public int getFillingMode() {
        int n = 0;
        try {
            n = Integer.parseInt(this.fillingMode.trim());
        }
        catch (Exception exception) {
            System.err.println("O modo de preenchimento do pol\u00edgono deve ser 0 (apenas arestas) ou 1 (preenchido).");
            exception.printStackTrace();
        }
        return n;
    }

    public String getStrFillColor() {
        return this.strFillColor.trim();
    }

    public String getStrLineColor() {
        return this.strLineColor.trim();
    }

    public String getVertexList() {
        return this.vertexList.trim();
    }

    public String getDescription() {
        String[] stringArray = new String[]{"" + this.getSource(), "MenuPoligono"};
        return ResourceReader.msgComVar("msgInternalChangeClickMenu", "OBJ", stringArray);
    }

    public int getCodigoAcao() {
        if (this.getCommand().equals(UNDO)) {
            return 31;
        }
        if (this.getCommand().equals(REDO)) {
            return 32;
        }
        return 30;
    }

    public String getArgumento() {
        return this.argumento;
    }
}

