/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloCentral.controle.desenho;

import difusor.evento.CommunicationEvent;
import igraf.basico.io.ResourceReader;
import igraf.moduloCentral.controle.desenho.DesenhoController;
import igraf.moduloCentral.eventos.IgrafTabUpdateEvent;
import igraf.moduloCentral.eventos.menu.IgrafMenuAnimacaoEvent;
import igraf.moduloCentral.visao.desenho.Desenho;
import igraf.moduloCentral.visao.desenho.DesenhoAnimacao;
import igraf.moduloCentral.visao.plotter.GraphPlotter;
import igraf.moduloJanelasAuxiliares.eventos.AtualizaParametroEvent;
import java.util.Vector;

public class DesenhoAnimacaoController
extends DesenhoController {
    public static final String IGCLASSPATH = "igraf/moduloCentral/controle/desenho/DesenhoAnimacaoController.java";
    protected Vector listaAnimacaoOculta = new Vector();
    private boolean animando = true;
    private int i;
    static int cont = 0;
    double valorA;
    double valorAMin = -1.0;
    double valorAMax = 1.0;
    double valorB;
    double valorBMin = -1.0;
    double valorBMax = 1.0;
    double valorC;
    double valorCMin = -1.0;
    double valorCMax = 1.0;
    double valorK;
    double valorKMin = -1.0;
    double valorKMax = 1.0;
    double valorM;
    double valorMMin = -1.0;
    double valorMMax = 1.0;
    double valorN;
    double valorNMin = -1.0;
    double valorNMax = 1.0;
    double delta = 0.05;
    int A = 1;
    private boolean stateA = true;
    private boolean stateB = false;
    private boolean stateC = false;
    private boolean stateK = false;
    private boolean stateM = false;
    private boolean stateN = false;
    private boolean anim = false;

    public DesenhoAnimacaoController(GraphPlotter graphPlotter) {
        super(graphPlotter);
    }

    public boolean insereDesenho(Desenho desenho) {
        this.i = this.indexOfFunctionOffScreen(desenho.toString());
        if (this.i > -1 & this.ehDesenhoVisivel(desenho.toString())) {
            return false;
        }
        if (this.i < 0) {
            this.listaAnimacaoOculta.addElement(desenho);
            this.listaDesenho.add(desenho);
        } else if (!this.ehDesenhoVisivel(desenho.getFuncaoAtual())) {
            desenho.setColorIndex(this.i);
            this.listaDesenho.add(desenho);
        }
        this.plotter.iniciaAnimacao(true);
        this.notificaAlteracaoEstado();
        return true;
    }

    private int indexOfFunctionOffScreen(String string) {
        for (int i = 0; i < this.listaAnimacaoOculta.size(); ++i) {
            Desenho desenho = (Desenho)this.listaAnimacaoOculta.elementAt(i);
            if (!desenho.toString().equals(string)) continue;
            return desenho.getOrdem();
        }
        return -1;
    }

    public void trataEvento(CommunicationEvent communicationEvent) {
        CommunicationEvent communicationEvent2;
        if (communicationEvent.getCommand().equals("update")) {
            communicationEvent2 = (AtualizaParametroEvent)communicationEvent;
            this.atualizaParametro(((AtualizaParametroEvent)communicationEvent2).getIndex(), ((AtualizaParametroEvent)communicationEvent2).getIni(), ((AtualizaParametroEvent)communicationEvent2).getFim(), ((AtualizaParametroEvent)communicationEvent2).getState());
        }
        if (communicationEvent instanceof IgrafTabUpdateEvent) {
            double d = ((IgrafTabUpdateEvent)communicationEvent).getSliderValue();
            this.atualizaTodasAnimacoes(d);
        }
        if (communicationEvent instanceof IgrafMenuAnimacaoEvent) {
            communicationEvent2 = (IgrafMenuAnimacaoEvent)communicationEvent;
            String string = communicationEvent2.getCommand();
            if (string.equals("sliderAdjustment")) {
                this.atualizaTodasAnimacoes(((IgrafMenuAnimacaoEvent)communicationEvent2).getSliderValue());
            } else if (string.equals("changeAnimationState")) {
                System.err.println("\n\nigraf/moduloCentral/controle/desenho/DesenhoAnimacaoController.java: trataEvento(CommunicationEvent): " + communicationEvent.getClass().getName() + " this melhod is suppossed to be turned off!");
                this.mudaEstadoAnimacao(((IgrafMenuAnimacaoEvent)communicationEvent2).getFuncaoOriginal());
            } else if (string.equals(ResourceReader.msg("maMostraCDesl"))) {
                this.animando = false;
            } else if (string.equals(ResourceReader.msg("maParaAnima"))) {
                boolean bl = this.animando = !this.animando;
                if (((IgrafMenuAnimacaoEvent)communicationEvent2).getFuncaoOriginal().length() == 0) {
                    this.mudaEstadoTodos(this.animando);
                } else {
                    this.mudaEstadoAnimacao(((IgrafMenuAnimacaoEvent)communicationEvent2).getFuncaoOriginal());
                }
            } else if (string.equals(ResourceReader.msg("maMostraControle")) || string.equals(ResourceReader.msg("maVelAmplia")) || string.equals(ResourceReader.msg("maVelDiminui"))) {
                // empty if block
            }
        }
    }

    private void mudaEstadoAnimacao(String string) {
        int n = this.listaDesenho.size();
        for (int i = 0; i < n; ++i) {
            DesenhoAnimacao desenhoAnimacao = (DesenhoAnimacao)this.listaDesenho.elementAt(i);
            if (!desenhoAnimacao.getFuncaoOriginal().equals(string)) continue;
            desenhoAnimacao.mudaEstadoAnimacao();
        }
    }

    private void mudaEstadoTodos(boolean bl) {
        int n = this.listaDesenho.size();
        for (int i = 0; i < n; ++i) {
            DesenhoAnimacao desenhoAnimacao = (DesenhoAnimacao)this.listaDesenho.elementAt(i);
            desenhoAnimacao.animate(bl);
        }
    }

    private void atualizaTodasAnimacoes(double d) {
        this.setValorA(d);
        this.plotter.refazDesenho();
    }

    public void desenharTodasAnimacoes() {
        for (int i = 0; i < this.listaAnimacaoOculta.size(); ++i) {
            this.insereDesenho((Desenho)this.listaAnimacaoOculta.get(i));
        }
    }

    public Vector getListaAnimacaoOculta() {
        return this.listaAnimacaoOculta;
    }

    public int getNumAnimacaoOculta() {
        return this.listaAnimacaoOculta.size();
    }

    public Desenho getAnimacaoOculta(int n) {
        return (Desenho)this.listaAnimacaoOculta.get(n);
    }

    public void apagaTodasAnimacoes() {
        this.listaDesenho.removeAllElements();
        this.notificaAlteracaoEstado();
    }

    public void ocultaAnimacao(Desenho desenho) {
        this.listaDesenho.remove(desenho);
        this.notificaAlteracaoEstado();
    }

    public void removeAnimacao(Desenho desenho) {
        this.listaAnimacaoOculta.remove(desenho);
        this.listaDesenho.remove(desenho);
        this.notificaAlteracaoEstado();
    }

    public void removerAnimacoes() {
        this.listaAnimacaoOculta.removeAllElements();
        this.listaDesenho.removeAllElements();
        this.notificaAlteracaoEstado();
    }

    public void notificaAlteracaoEstado() {
        IgrafTabUpdateEvent igrafTabUpdateEvent = new IgrafTabUpdateEvent(this, "changeAnimationList");
        igrafTabUpdateEvent.notificaDesenhoOculto(this.getNumAnimacaoOculta() > 0);
        igrafTabUpdateEvent.setAnimationList(this.listaDesenho);
        this.enviarEvento(igrafTabUpdateEvent);
    }

    public void reset() {
        super.reset();
        this.listaAnimacaoOculta.removeAllElements();
    }

    private void atualizaParametro(int n, double d, double d2, boolean bl) {
        switch (n) {
            case 0: {
                this.valorAMin = d;
                this.valorAMax = d2;
                this.changeStateA(bl);
                break;
            }
            case 1: {
                this.valorBMin = d;
                this.valorBMax = d2;
                this.changeStateB(bl);
                break;
            }
            case 2: {
                this.valorCMin = d;
                this.valorCMax = d2;
                this.changeStateC(bl);
                break;
            }
            case 3: {
                this.valorKMin = d;
                this.valorKMax = d2;
                this.changeStateK(bl);
                break;
            }
            case 4: {
                this.valorMMin = d;
                this.valorMMax = d2;
                this.changeStateM(bl);
                break;
            }
            case 5: {
                this.valorNMin = d;
                this.valorNMax = d2;
                this.changeStateN(bl);
            }
        }
    }

    public void setValorA() {
        if (this.valorA > this.valorAMax) {
            this.valorA = this.valorAMax;
            this.A *= -1;
        }
        if (this.valorA < this.valorAMin) {
            this.valorA = this.valorAMin;
            this.A *= -1;
        }
        if (this.animando) {
            this.valorA += this.delta * (double)this.A;
        }
    }

    public void setValorA(double d) {
        this.valorA = d;
    }

    public double getValorA() {
        if (this.stateA) {
            return this.valorA;
        }
        return 1.0;
    }

    public double getValorB() {
        if (this.stateB) {
            return this.parte(this.valorBMax, this.valorBMin);
        }
        return 1.0;
    }

    public double getValorC() {
        if (this.stateC) {
            return this.parte(this.valorCMax, this.valorCMin);
        }
        return 1.0;
    }

    public double getValorK() {
        if (this.stateK) {
            return this.parte(this.valorKMax, this.valorKMin);
        }
        return 1.0;
    }

    public double getValorM() {
        if (this.stateM) {
            return this.parte(this.valorMMax, this.valorMMin);
        }
        return 1.0;
    }

    public double getValorN() {
        if (this.stateN) {
            return this.parte(this.valorNMax, this.valorNMin);
        }
        return 1.0;
    }

    private double parte(double d, double d2) {
        double d3 = (this.valorA - this.valorAMin) / (this.valorAMax - this.valorAMin);
        return d3 * (d2 - d) + d;
    }

    private void changeStateA(boolean bl) {
        this.stateA = bl;
    }

    private void changeStateB(boolean bl) {
        this.stateB = bl;
    }

    private void changeStateC(boolean bl) {
        this.stateC = bl;
    }

    private void changeStateK(boolean bl) {
        this.stateK = bl;
    }

    private void changeStateM(boolean bl) {
        this.stateM = bl;
    }

    private void changeStateN(boolean bl) {
        this.stateN = bl;
    }

    private void suspenderAnimacao() {
        this.stateA = this.anim;
        this.stateB = this.anim;
        this.stateC = this.anim;
        this.stateK = this.anim;
        this.stateM = this.anim;
        this.stateN = this.anim;
        this.anim = !this.anim;
    }
}

