/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import base.MontaFace;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.util.Vector;

public class VerticalPanel
extends Panel
implements ComponentListener {
    private Panel panelSupportToVP;
    private Vector vecOfPanels = new Vector();
    protected final MontaFace mf;
    private final GridBagConstraints cons = new GridBagConstraints();
    private String title;
    private boolean desenhaBorda;

    public boolean isDesenhaBorda() {
        return this.desenhaBorda;
    }

    public void setDesenhaBorda(boolean bl) {
        this.desenhaBorda = bl;
    }

    public MontaFace getMf() {
        return this.mf;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void addComponent(Component component) {
        this.vecOfPanels.add(component);
    }

    public void removeAllComponents() {
        this.vecOfPanels = new Vector();
    }

    public VerticalPanel(MontaFace montaFace) {
        this.mf = montaFace;
        this.setLayout(new BorderLayout());
        this.setBackground(Configuracoes.CINZA);
        this.desenhaBorda = false;
        this.title = "";
        this.addComponentListener(this);
    }

    public void update() {
    }

    public void paint(Graphics graphics) {
        if (this.desenhaBorda) {
            String string = I18n.getString(this.title);
            graphics.setColor(Configuracoes.FACE_DARK1);
            graphics.drawString(string, 5, 15);
            graphics.setColor(Color.black);
            graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
        }
    }

    public Insets getInsets() {
        if (this.desenhaBorda) {
            return new Insets(20, 5, 5, 5);
        }
        return super.getInsets();
    }

    public void redraw() {
        this.update();
        if (this.panelSupportToVP != null) {
            this.remove(this.panelSupportToVP);
            this.panelSupportToVP = null;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panelSupportToVP = new Panel(gridBagLayout);
        this.panelSupportToVP.setBackground(Configuracoes.CINZA);
        int n = 0;
        for (int i = 0; i < this.vecOfPanels.size(); ++i) {
            this.cons.gridx = 0;
            this.cons.gridy = n++;
            this.cons.gridwidth = 1;
            this.cons.gridheight = 1;
            this.panelSupportToVP.add((Component)this.vecOfPanels.get(i), this.cons);
        }
        this.add((Component)this.panelSupportToVP, "North");
        this.validate();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = componentEvent.getComponent().getWidth();
        if (n < Constants.PANEL_WIDTH) {
            Constants.PANEL_WIDTH = n;
            this.redraw();
        } else {
            Constants.PANEL_WIDTH = n;
            this.repaint();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

