/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import base.MontaFace;
import icomb.objects.Element;
import icomb.objects.Universo;
import icomb.ui.ImagePanel;
import icomb.ui.PopUpFrame;
import icomb.util.I18n;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class UniversoFrame
extends PopUpFrame
implements ActionListener,
WindowListener {
    public static final int WIDTH = 300;
    public static final int HEIGHT = 500;
    private MontaFace mf;
    private Universo universo;

    public UniversoFrame(MontaFace montaFace) {
        this(montaFace, null);
    }

    public UniversoFrame(MontaFace montaFace, Universo universo) {
        super(I18n.getString("windowShowUniverse"));
        this.mf = montaFace;
        this.universo = universo;
        int n = 300;
        int n2 = 500;
        ((Component)this).setSize(n, n2);
        this.setLocationRelativeTo(montaFace);
        ((Component)this).setVisible(false);
        this.addWindowListener(this);
        if (universo != null) {
            this.load();
        }
    }

    public void setUniverso(Universo universo) {
        if (this.universo == null) {
            this.universo = universo;
            this.load();
        }
    }

    public void load() {
        Vector vector = this.universo.getElementos();
        GridLayout gridLayout = new GridLayout(vector.size() + 2, 1);
        Panel panel = new Panel(gridLayout);
        Label label = new Label(I18n.getString("universe"));
        Object var5_5 = null;
        panel.add(label);
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.get(i);
            ImagePanel imagePanel = new ImagePanel(this.mf);
            imagePanel.setElement(this.universo, element, imagePanel.getNome());
            panel.add(imagePanel);
        }
        ScrollPane scrollPane = new ScrollPane(0);
        scrollPane.add(panel);
        this.add(scrollPane);
        try {
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            System.err.println("UniversoFrame.load(): Error to show window!");
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.repaint();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.repaint();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

