/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;

public class ToolTip
extends Canvas {
    private static final Color BACK_COLOR = new Color(255, 255, 220);
    private static final Color LINE_COLOR = new Color(100, 100, 100);
    private static final Font FONT = new Font("Helvetica", 0, 11);
    private static final int DY = 5;
    private static final int DX = 5;
    private static final int LINE_HEIGHT = 15;
    protected String tip;
    protected Component owner;
    private Container mainContainer;
    private LayoutManager mainLayout;
    private boolean shown;
    private final int VERTICAL_OFFSET = 30;
    private int TIP_HEIGHT;
    private int TIP_WIDTH;
    private int line_height;
    private int NUMBER_OF_LINES;
    private String[] tipArray;
    private static ToolTip staticToolTip = null;

    public ToolTip(String string, Component component) {
        this.tip = string;
        this.owner = component;
        component.addMouseListener(new MAdapter());
        this.setBackground(BACK_COLOR);
        this.setFont(FONT);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(LINE_COLOR);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics.setColor(Color.BLACK);
        int n = 15;
        for (int i = 0; i < this.tipArray.length; ++i) {
            graphics.drawString(this.tipArray[i], 3, n);
            n += 15;
        }
    }

    private void addToolTip() {
        int n;
        this.mainContainer.setLayout(null);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(this.tip, "\n");
        this.NUMBER_OF_LINES = stringTokenizer.countTokens();
        this.tipArray = new String[this.NUMBER_OF_LINES];
        int n2 = 0;
        this.TIP_WIDTH = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.tipArray[n2] = stringTokenizer.nextToken();
            n = fontMetrics.stringWidth(this.tipArray[n2]);
            if (n > this.TIP_WIDTH) {
                this.TIP_WIDTH = n;
            }
            ++n2;
        }
        this.line_height = fontMetrics.getHeight();
        this.TIP_HEIGHT = this.line_height * this.NUMBER_OF_LINES;
        this.setSize(this.TIP_WIDTH + 5, this.TIP_HEIGHT + 5);
        n = this.mainContainer.getLocationOnScreen().x;
        int n3 = this.mainContainer.getLocationOnScreen().y;
        int n4 = this.mainContainer.getSize().width;
        this.setLocation(this.owner.getLocationOnScreen().x - n, this.owner.getLocationOnScreen().y - n3 + 30);
        if (n4 < this.getLocation().x + this.getSize().width) {
            this.setLocation(n4 - this.getSize().width, this.getLocation().y);
        }
        this.setVisible(false);
        this.mainContainer.add((Component)this, 0);
        this.setVisible(true);
        this.mainContainer.validate();
        this.repaint();
        this.shown = true;
    }

    public void removeLastToolTip() {
        ToolTip toolTip = staticToolTip;
        if (toolTip == null) {
            staticToolTip = this;
            return;
        }
        if (toolTip.shown) {
            try {
                toolTip.mainContainer.remove(0);
                toolTip.mainContainer.setLayout(this.mainLayout);
                toolTip.mainContainer.validate();
            }
            catch (Exception exception) {
                System.err.println("ToolTip.removeLastToolTip");
            }
        } else {
            toolTip.setVisible(false);
        }
        toolTip.shown = false;
        staticToolTip = this;
    }

    private void removeToolTip() {
        if (this.shown) {
            this.mainContainer.remove(0);
            this.mainContainer.setLayout(this.mainLayout);
            this.mainContainer.validate();
        }
        this.shown = false;
    }

    private void findMainContainer() {
        Container container = this.owner.getParent();
        while (true) {
            if (container instanceof Applet || container instanceof Frame) break;
            container = container.getParent();
        }
        this.mainContainer = container;
        this.mainLayout = this.mainContainer.getLayout();
    }

    class MAdapter
    extends MouseAdapter {
        MAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ToolTip.this.findMainContainer();
            ToolTip.this.removeLastToolTip();
            ToolTip.this.addToolTip();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ToolTip.this.removeToolTip();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolTip.this.removeToolTip();
        }
    }
}

