/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import icomb.components.CustomChoice;
import icomb.components.CustomList;
import icomb.events.ObjectManager;
import icomb.objects.Estagio;
import icomb.ui.ConstructionPanel;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.I18n;
import icomb.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class ListPanel
extends Panel
implements ItemListener,
ActionListener {
    private ConstructionPanel pai;
    private Button btnSupressSelection;
    private Button btnModifySelection;
    private CustomChoice chAction;
    private CustomList list;
    private Label lblResult;
    private Button btnCancel;

    public ListPanel(ConstructionPanel constructionPanel) {
        this.pai = constructionPanel;
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        panel.setBackground(Configuracoes.CINZA);
        Panel panel2 = new Panel(new BorderLayout());
        panel2.setBackground(Configuracoes.CINZA);
        this.chAction = ObjectManager.criaCombo(panel, Util.getListActions(), "choiceAction-dica");
        this.chAction.setEnabled(false);
        this.chAction.addItemListener(this);
        Panel panel3 = new Panel(new BorderLayout());
        panel3.setBackground(Configuracoes.CINZA);
        this.lblResult = new Label("");
        this.lblResult.setForeground(Color.BLACK);
        this.btnCancel = ObjectManager.criaBotao(panel3, I18n.getString("cancel"), I18n.getString("cancel-dica"));
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(this);
        panel3.add((Component)this.lblResult, "Center");
        this.btnSupressSelection = ObjectManager.criaBotao(panel, I18n.getString("supressSelection"), I18n.getString("supressSelection-dica"));
        this.btnSupressSelection.setEnabled(false);
        this.btnSupressSelection.addActionListener(this);
        panel2.add((Component)this.btnSupressSelection, "North");
        panel2.add((Component)this.chAction, "South");
        panel.add((Component)panel2, "North");
        panel.add((Component)panel3, "South");
        this.list = ObjectManager.criaList(new Vector());
        this.list.setForeground(Color.BLACK);
        this.list.setEnabled(false);
        this.list.addItemListener(this);
        this.add((Component)this.list, "Center");
        this.add((Component)panel, "East");
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH - 10, 75);
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.list) {
            if (this.list.getSelectedIndex() >= 0) {
                this.btnSupressSelection.setEnabled(true);
            }
        } else if (itemEvent.getSource() == this.chAction && this.chAction.getSelectedIndex() >= 0) {
            ObjectManager.setMachine.setOperacao(this.chAction.getSelectedKey());
            this.lblResult.setText(ObjectManager.setMachine.getOperacaoTexto() + "   ");
            this.btnCancel.setEnabled(true);
            this.pai.habilitaBotaoEuTerminei(true);
            this.validate();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSupressSelection) {
            this.supressStage();
            this.btnSupressSelection.setEnabled(false);
        } else if (actionEvent.getSource() == this.btnCancel) {
            this.btnCancel.setEnabled(false);
            this.pai.habilitaBotaoEuTerminei(false);
        }
    }

    public void modifySelection() {
    }

    public void supressStage() {
        String string = this.list.getSelectedKey();
        for (int i = 0; i < ObjectManager.setMachine.getEstagios().size(); ++i) {
            Estagio estagio = (Estagio)ObjectManager.setMachine.getEstagios().get(i);
            if (!("" + estagio.hashCode()).equals(string)) continue;
            ObjectManager.setMachine.getEstagios().remove(estagio);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ExcluiEstagio(" + estagio.hashCode() + ")" + "$");
            ObjectManager.getInstance().registraAcao(stringBuffer);
            break;
        }
        this.redo();
        this.pai.stageWasDeleted();
    }

    public void addStageFromConstructionPanel() {
        Vector vector = ObjectManager.setMachine.getEstagios();
        Estagio estagio = null;
        if (vector == null || vector.size() <= 0) {
            return;
        }
        estagio = (Estagio)vector.lastElement();
        String string = estagio.getDescricao() + ": " + estagio.getTextoFormula();
        System.out.println("ListPanel.addStageFromConstructionPanel(): <" + estagio.hashCode() + "> :: " + string);
        this.list.add("" + estagio.hashCode(), string);
        this.list.setEnabled(true);
        this.lblResult.setText(ObjectManager.setMachine.getOperacaoTexto() + "   ");
        this.chAction.setEnabled(true);
    }

    public void redo() {
        this.list.removeAll();
        for (int i = 0; i < ObjectManager.setMachine.getEstagios().size(); ++i) {
            Estagio estagio = (Estagio)ObjectManager.setMachine.getEstagios().get(i);
            String string = estagio.getDescricao() + ": " + estagio.getTextoFormula();
            this.list.add("" + estagio.hashCode(), string);
        }
        this.list.setEnabled(true);
        this.lblResult.setText(ObjectManager.setMachine.getOperacaoTexto() + "   ");
        this.chAction.setEnabled(true);
    }
}

