/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import icomb.components.CustomList;
import icomb.ui.IListFrameListener;
import icomb.ui.PopUpFrame;
import icomb.ui.StagePanel;
import icomb.util.Util;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import java.util.Vector;

public class ListFrame
extends PopUpFrame
implements ActionListener,
ItemListener {
    private Button btnExit;
    private CustomList listContent;
    private StagePanel father;
    private Vector listeners;

    public ListFrame(StagePanel stagePanel) {
        super("Selecionar Op\u00e7\u00f5es");
        this.father = stagePanel;
        ((Component)this).setSize(200, 200);
        this.setLocationRelativeTo(stagePanel);
        ((Component)this).setVisible(false);
        this.listeners = new Vector();
        Panel panel = new Panel(new FlowLayout());
        this.btnExit = new Button("OK");
        this.btnExit.setEnabled(false);
        panel.add(this.btnExit);
        this.btnExit.addActionListener(this);
        this.listContent = new CustomList(new Vector());
        this.listContent.setMultipleMode(true);
        this.listContent.addItemListener(this);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.listContent);
        this.add((Component)scrollPane, "Center");
        this.add((Component)panel, "South");
    }

    public void removeListeners() {
        this.listeners = new Vector();
    }

    public void addListFrameListener(IListFrameListener iListFrameListener) {
        this.listeners.add(iListFrameListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEvents(this.createSetString());
        ((Component)this).setVisible(false);
    }

    private String createSetString() {
        String[] stringArray = this.listContent.getSelectedKeys();
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void changeModel(Vector vector) {
        this.listContent.populate(vector);
    }

    public void changeModel(Vector vector, Vector vector2) {
        this.listContent.populate(vector, vector2);
    }

    public void mark(String string) {
        Set set = Util.produceStringSet(string);
        this.listContent.select(set);
    }

    public void fireEvents(String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IListFrameListener iListFrameListener = (IListFrameListener)this.listeners.get(i);
            iListFrameListener.setStringList(string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.listContent.getSelectedIndexes().length > 0) {
            this.btnExit.setEnabled(true);
        } else {
            this.btnExit.setEnabled(false);
        }
    }
}

