/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import icomb.components.CustomChoice;
import icomb.events.ObjectManager;
import icomb.objects.Exercicio;
import icomb.objects.Universo;
import icomb.ui.MessageFrame;
import icomb.ui.SetMachinePanel;
import icomb.ui.UniversoFrame;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.GerenciadorRecursos;
import icomb.util.I18n;
import icomb.util.Parse;
import icomb.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class DefinedUniversePanel
extends Panel
implements ActionListener,
ItemListener {
    private String title;
    private final TextArea label;
    private Exercicio[] exercises;
    private final SetMachinePanel pai;
    private final Button btnUniverso;
    private final Panel leftPanel;
    private CustomChoice choiceUniverses;

    public DefinedUniversePanel(SetMachinePanel setMachinePanel) {
        this.pai = setMachinePanel;
        this.setBackground(Configuracoes.corBarraSupInf);
        this.setLayout(new BorderLayout());
        String string = "";
        if (ObjectManager.setMachine.getUniverso() != null) {
            string = I18n.getString("theSetOfSubsetsWith") + " " + ObjectManager.setMachine.getNElementos() + " " + I18n.getString("elementsTakenIn") + " " + I18n.getString(ObjectManager.setMachine.getUniverso().getNome());
        }
        this.label = new TextArea(ObjectManager.setMachine.getDica(), 2, 5, 3);
        this.label.setBackground(new Color(255, 215, 221));
        this.label.setForeground(Color.BLACK);
        this.label.setEditable(false);
        this.leftPanel = new Panel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        this.leftPanel.setBackground(Configuracoes.corBarraSupInf);
        this.leftPanel.add((Component)this.label, "Center");
        this.add((Component)this.leftPanel, "Center");
        Panel panel = new Panel(new BorderLayout());
        this.btnUniverso = ObjectManager.criaBotao(panel, I18n.getString("seeUniverse"), I18n.getString("seeUniverse-dica"));
        this.btnUniverso.addActionListener(this);
        panel.add((Component)this.btnUniverso, "North");
        this.choiceUniverses = ObjectManager.criaCombo(panel, Util.geUniversetList(), I18n.getString("changeUniverse"));
        this.choiceUniverses.addItemListener(this);
        panel.add((Component)this.choiceUniverses, "South");
        if (!ObjectManager.setMachine.isModoCriacao()) {
            this.choiceUniverses.setEnabled(false);
        }
        this.add((Component)panel, "East");
        this.setVisible(true);
    }

    public void mudaDica() {
        this.label.setText(ObjectManager.setMachine.getDica());
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH, 80);
    }

    public void paint(Graphics graphics) {
        this.label.setText(ObjectManager.setMachine.getDica());
        graphics.setColor(Color.white);
        graphics.drawString(I18n.getString("help"), 5, 15);
        graphics.setColor(Color.black);
        graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
    }

    public Insets getInsets() {
        return new Insets(20, 5, 5, 5);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choiceUniverses) {
            String string = this.choiceUniverses.getSelectedKey();
            System.out.println("DefinedUniversePanel.java: setChoosen=" + string);
            Universo universo = null;
            try {
                this.pai.getDePanel().setEnabled();
                String string2 = GerenciadorRecursos.getPath(this);
                String string3 = null;
                String string4 = null;
                string3 = "baralho/baralho.xml";
                if (string.equals(I18n.getString("universeFoot"))) {
                    string3 = "futebol/futebol.xml";
                }
                if (string2 != null && string2.equals("/")) {
                    string2 = "icomb/";
                }
                System.out.println("DefinedUniversePanel.itemStateChanged:\n * strUniversePath = " + string2 + "\n * strUniverseSet = " + string3 + "\n * strUniverse = " + string4);
                string4 = string2 + string3;
                universo = Parse.parseUniverso(string4);
                universo.setArquivo(string2, string4);
                ObjectManager.setMachine.setUniverso(universo);
            }
            catch (Exception exception) {
                String string5 = I18n.getString("invalid_universe");
                MessageFrame.showMessage(string5, this.pai);
                System.err.println("Erro: in 'DefinedUniversePanel.java': " + string5 + ": " + exception);
                exception.printStackTrace();
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnUniverso) {
            UniversoFrame universoFrame = null;
            try {
                Universo universo = ObjectManager.setMachine.getUniverso();
                universoFrame = new UniversoFrame(this.pai.getMf(), universo);
            }
            catch (Exception exception) {
                String string = I18n.getString("universe_empty");
                MessageFrame.showMessage(string, this.pai);
                System.err.println("Erro: " + string + ": " + exception);
                exception.printStackTrace();
                return;
            }
            ((Component)universoFrame).setVisible(true);
        }
    }
}

