/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import base.MontaFace;
import icomb.IComb;
import icomb.events.ObjectManager;
import icomb.ui.ListPanel;
import icomb.ui.MessageFrame;
import icomb.ui.NewStageButtonPanel;
import icomb.ui.SetMachinePanel;
import icomb.ui.StagePanel;
import icomb.ui.VerticalPanel;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.I18n;
import icomb.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Insets;

public class ConstructionPanel
extends VerticalPanel {
    private final NewStageButtonPanel painel_nsbp;
    private final StagePanel painel_sp;
    private final ListPanel painel_lp;
    private final SetMachinePanel painelSetMachine;

    public ConstructionPanel(SetMachinePanel setMachinePanel) {
        super((MontaFace)null);
        this.painelSetMachine = setMachinePanel;
        this.painel_nsbp = new NewStageButtonPanel(this);
        this.painel_sp = new StagePanel(this);
        this.painel_lp = new ListPanel(this);
        this.setDesenhaBorda(true);
        this.setBackground(Configuracoes.CINZA);
        this.addComponent(this.painel_nsbp);
        this.addComponent(this.painel_sp);
        this.addComponent(this.painel_lp);
        this.redraw();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void habilitarNovoEstagio() {
        this.painel_nsbp.open();
        this.painel_sp.carregaAtributos(ObjectManager.setMachine.getUniverso());
    }

    public void addStagePanel() {
        this.painel_lp.addStageFromConstructionPanel();
        this.painel_nsbp.open();
        this.painelSetMachine.drawAgain();
    }

    public void redrawPanel() {
        this.painelSetMachine.drawAgain();
    }

    public void stageWasDeleted() {
        this.painelSetMachine.drawAgain();
        this.painel_nsbp.enabledResetConstruction(false);
    }

    public void openStagePanel() {
        this.painel_sp.open();
    }

    public void validateConstruction() {
        this.painelSetMachine.redraw();
    }

    public void habilitaBotaoEuTerminei(boolean bl) {
        this.painel_nsbp.habilitaBotao(bl);
    }

    public boolean criarExercicio() {
        String string;
        if (!ObjectManager.setMachine.isModoCriacao()) {
            string = I18n.getString("errSystemCreatNot");
            System.err.println("Error: in ConstructionPanel: " + string);
            MessageFrame.showMessage(string, this.painelSetMachine);
        }
        if (!MontaFace.staticApplet) {
            string = this.painelSetMachine.getCePanel().storeExercise();
            System.out.println("ConstructionPanel.java: storeExercise(): " + string);
            if (string == null || string == "") {
                return false;
            }
            FileDialog fileDialog = new FileDialog(IComb.appletFrame, "iMath :: iComb", 1);
            fileDialog.setFile("*.cmb");
            fileDialog.setDirectory(".");
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() != null) {
                String string2 = fileDialog.getDirectory() + fileDialog.getFile();
                Util.storeFile(string2, string, "ConstructionPanel.java");
                return true;
            }
            return false;
        }
        return this.painelSetMachine.sent2Server();
    }

    public void apagaEstagioAtual() {
        this.painel_sp.close();
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH, 293);
    }
}

