/*
 * Decompiled with CFR 0.152.
 */
package icomb.ui;

import base.MontaFace;
import icomb.IComb;
import icomb.events.ObjectManager;
import icomb.objects.Exercicio;
import icomb.objects.Universo;
import icomb.ui.SetMachinePanel;
import icomb.util.Configuracoes;
import icomb.util.Constants;
import icomb.util.Crypto;
import icomb.util.I18n;
import icomb.util.ParserParametros;
import icomb.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ChooseExercisePanel
extends Panel
implements ItemListener,
ActionListener {
    private TextField txtFileName;
    private TextArea label;
    private Exercicio[] exercises;
    private SetMachinePanel painelSetMachine;
    private Button buttonValidate;
    private Button openFile;
    private Button btnBack;
    private Button btnCriar;
    private Hashtable mapExercicio;

    public ChooseExercisePanel(SetMachinePanel setMachinePanel) {
        this.painelSetMachine = setMachinePanel;
        this.exercises = ObjectManager.setMachine.getExercicios();
        Vector<String> vector = new Vector<String>();
        vector.add("emptyString");
        Panel panel = new Panel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        this.setLayout(new BorderLayout());
        this.txtFileName = new TextField();
        this.txtFileName.setBackground(new Color(240, 240, 240));
        this.txtFileName.setForeground(Color.BLACK);
        this.txtFileName.setEditable(false);
        panel.add((Component)this.txtFileName, "North");
        this.label = new TextArea("", 2, 5, 3);
        this.label.setEditable(false);
        this.label.setForeground(Color.BLACK);
        panel.add((Component)this.label, "Center");
        this.add((Component)panel, "Center");
        Panel panel2 = new Panel(new BorderLayout());
        this.openFile = ObjectManager.criaBotao(panel2, I18n.getString("openFile"), I18n.getString("openFile-dica"));
        if (!IComb.isApplet()) {
            this.openFile.addActionListener(this);
            panel2.add((Component)this.openFile, "North");
        }
        this.btnCriar = ObjectManager.criaBotao(panel2, I18n.getString("changeExercise"), I18n.getString("changeExercise-dica"));
        this.btnCriar.setEnabled(true);
        this.btnCriar.addActionListener(this);
        panel2.add((Component)this.btnCriar, "South");
        this.add((Component)panel2, "East");
        this.setVisible(true);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Constants.PANEL_WIDTH, 100);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Configuracoes.FACE_DARK1);
        graphics.drawString(I18n.getString("exercises"), 5, 15);
        graphics.setColor(Color.black);
        graphics.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
    }

    public Insets getInsets() {
        return new Insets(20, 5, 5, 5);
    }

    private static String readFileAsString(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = bufferedReader.read(cArray)) != -1) {
            String string2 = String.valueOf(cArray, 0, n);
            stringBuffer.append(string2);
            cArray = new char[1024];
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = itemEvent.getItem() + "";
        String string2 = "";
        try {
            string2 = ChooseExercisePanel.readFileAsString(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mapExercicio = ParserParametros.parser(string2);
        String string3 = (String)this.mapExercicio.get("EnumGabarito");
        this.label.setText(string3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnCriar) {
            this.btnCriar.setEnabled(false);
            ObjectManager.setMachine.criandoExercicio();
            this.painelSetMachine.redraw();
        } else if (actionEvent.getSource() == this.openFile) {
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getAbsolutePath().endsWith(".cmb");
                }

                public String getDescription() {
                    return "*.cmb";
                }
            });
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = "";
                try {
                    string = ChooseExercisePanel.readFileAsString(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.txtFileName.setText(file.getAbsolutePath());
                this.mapExercicio = ParserParametros.parser(string);
                String string2 = (String)this.mapExercicio.get("EnumGabarito");
                this.label.setText(string2);
                this.loadExercise();
            }
        }
    }

    public void loadText(String string, String string2) {
        this.mapExercicio = ParserParametros.parser(string2);
        String string3 = (String)this.mapExercicio.get("EnumGabarito");
        this.txtFileName.setText(string);
        this.label.setText(string3);
        this.loadExercise();
    }

    private void loadExercise() {
        Exercicio exercicio = new Exercicio(60, "", (String)this.mapExercicio.get("EnumGabarito"));
        String string = Crypto.hexToString((String)this.mapExercicio.get("solucao"));
        exercicio.setSolucao(Universo.interpretaCondicao(string));
        exercicio.setResposta(Long.parseLong((String)this.mapExercicio.get("resposta")));
        ObjectManager.setMachine.setCorrige((String)this.mapExercicio.get("corrige") == null ? true : ((String)this.mapExercicio.get("corrige")).trim().equals("true"));
        ObjectManager.setMachine.setArquivoUniverso("icomb/", (String)this.mapExercicio.get("ArquivoUniverso"));
        ObjectManager.setMachine.defineDica((String)this.mapExercicio.get("dica"));
        ObjectManager.setMachine.setOnline((String)this.mapExercicio.get("online") != null && ((String)this.mapExercicio.get("online")).equals("1"));
        ObjectManager.setMachine.setExercicio(exercicio);
        ObjectManager.setMachine.loadUniverso(this.painelSetMachine.getMf());
        ObjectManager.setMachine.confirmaExercicio();
        ObjectManager.setMachine.notExerciseCreation();
        this.painelSetMachine.redraw();
    }

    public String storeExercise() {
        String string = "";
        try {
            string = "# iComb: http://www.matematica.br\n[ .: version: 0.9.5 :. ]\n" + Util.getUserSystemData();
            String string2 = "{EnumGabarito: " + ObjectManager.setMachine.getExercicioAtual().getLongDescription() + "}\n";
            String string3 = "{Tipo: exercicio: 1}\n";
            String string4 = "{solucao: " + Crypto.hexToString(ObjectManager.setMachine.toFormatoReduzido()) + "}\n";
            String string5 = "{resposta: " + ObjectManager.setMachine.getResultadoFinal() + "}\n";
            String string6 = "{ArquivoUniverso: " + ObjectManager.setMachine.getUniverso().getArquivo() + "}\n";
            String string7 = "{dica: " + ObjectManager.setMachine.getDica() + "}\n";
            String string8 = "{online: " + (MontaFace.staticApplet ? "1" : "0") + "}\n";
            string = string + string2 + string3 + string4 + string5 + string6 + string7 + string8;
        }
        catch (Exception exception) {
            System.err.println("Error: in ChooseExercisePanel.storeExercise(): " + string);
            String string9 = ObjectManager.setMachine != null ? ObjectManager.setMachine.getExercicioAtual() + "" : "<>";
            System.err.println("Error: " + string9);
            exception.printStackTrace();
        }
        return string;
    }
}

