/*
 * Decompiled with CFR 0.152.
 */
package icomb.objects;

import icomb.objects.Element;
import java.util.Iterator;
import java.util.Set;

public class Expressao {
    private String attributeName;
    private boolean belong;
    private Set elements;

    public Expressao(String string, boolean bl, Set set) {
        this.attributeName = string;
        this.belong = bl;
        this.elements = set;
    }

    public String toString() {
        return this.attributeName + ": " + (this.belong ? "in" : "not in") + this.elements;
    }

    public boolean evaluate(Element element) {
        boolean bl = false;
        if (this.elements.contains(element.getAttribute(this.attributeName))) {
            bl = true;
        } else {
            Set set = element.getPredicates(this.attributeName);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    if (!this.elements.contains(iterator.next())) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (this.belong) {
            return bl;
        }
        return !bl;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Set getElements() {
        return this.elements;
    }

    public String toFormatoReduzido() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.elements.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next());
        }
        return this.attributeName + (this.belong ? "=" : "#") + "{" + stringBuffer + "}";
    }
}

