/*
 * Decompiled with CFR 0.152.
 */
package icomb.erro;

import icomb.formula.Binomio;
import icomb.objects.Condicao;
import icomb.objects.Element;
import icomb.objects.Estagio;
import icomb.objects.Universo;
import icomb.util.I18n;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Avaliador {
    private Element[] elementos;
    private Condicao[] condicoes;
    private Map elemParticao;
    private Map elemResposta;
    private Map particoes;

    public Avaliador(Universo universo, Condicao[] condicaoArray) {
        int n;
        Vector vector = universo.getElementos();
        this.elementos = new Element[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.elementos[n] = (Element)vector.get(n);
        }
        this.condicoes = condicaoArray;
        this.elemParticao = new Hashtable();
        this.elemResposta = new Hashtable();
        this.particoes = new Hashtable();
        for (n = 0; n < this.elementos.length; ++n) {
            for (int i = 0; i < condicaoArray.length; ++i) {
                if (!condicaoArray[i].evaluate(this.elementos[n])) continue;
                if (this.elemParticao.get(this.elementos[n]) != null) {
                    throw new RuntimeException(I18n.getString("evaluationMessage01"));
                }
                this.elemParticao.put(this.elementos[n], condicaoArray[i]);
                HashSet<Element> hashSet = (HashSet<Element>)this.particoes.get(condicaoArray[i]);
                if (hashSet == null) {
                    hashSet = new HashSet<Element>();
                }
                hashSet.add(this.elementos[n]);
                this.particoes.put(condicaoArray[i], hashSet);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void adicionaCondicao(Condicao condicao) {
        String string = "   #elementos=" + this.elementos.length + " - inserted in 'setCondicoes':\n";
        HashSet hashSet = new HashSet();
        HashSet<Element> hashSet2 = new HashSet<Element>();
        for (int i = 0; i < this.elementos.length; ++i) {
            if (!condicao.evaluate(this.elementos[i])) continue;
            hashSet2.add(this.elementos[i]);
            hashSet.add(this.elemParticao.get(this.elementos[i]));
            string = string + "   " + i + ": " + this.elementos[i] + " - " + this.elemParticao.get(this.elementos[i]) + "\n";
        }
        string = string + "   #setCondicoes=" + hashSet.size() + "\n";
        if (hashSet2.size() == 0) {
            throw new RuntimeException(I18n.getString("evaluationMessage02"));
        }
        if (hashSet.size() == 0 || hashSet.size() == 1 && hashSet.iterator().next() == null) {
            throw new RuntimeException(I18n.getString("evaluationMessage03"));
        }
        Condicao condicao2 = null;
        Condicao condicao3 = null;
        if (condicao.getQuantidade() != hashSet2.size()) {
            Condicao condicao4;
            Set set;
            if (hashSet.size() > 1) {
                try {
                    Object object;
                    Iterator iterator = hashSet.iterator();
                    condicao2 = (Condicao)iterator.next();
                    condicao3 = (Condicao)iterator.next();
                    HashSet hashSet3 = (HashSet)this.particoes.get(condicao2);
                    HashSet hashSet4 = (HashSet)this.particoes.get(condicao3);
                    Iterator iterator2 = hashSet2.iterator();
                    Object object2 = null;
                    while (iterator2.hasNext()) {
                        object = (Element)iterator2.next();
                        if (!hashSet3.contains(object)) continue;
                        object2 = object;
                        break;
                    }
                    object = hashSet2.iterator();
                    Element element = null;
                    while (object.hasNext()) {
                        Element element2 = (Element)object.next();
                        if (!hashSet4.contains(element2)) continue;
                        element = element2;
                        throw new RuntimeException(I18n.getString("evaluationMessage04", new Object[]{object2, element}));
                    }
                    throw new RuntimeException(I18n.getString("evaluationMessage04", new Object[]{object2, element}));
                }
                catch (Exception exception) {
                    System.err.println("Erro: formato nao iComb?: " + exception + "\nCondicoes: <(" + condicao2 + ")> e <(" + condicao3 + ")>");
                }
            }
            if (!((Object)hashSet2).equals(set = (Set)this.particoes.get(condicao4 = (Condicao)hashSet.iterator().next()))) throw new RuntimeException(I18n.getString("evaluationMessage06"));
            if (condicao.getQuantidade() != condicao4.getQuantidade()) {
                throw new RuntimeException(I18n.getString("evaluationMessage05"));
            }
        } else {
            Condicao condicao5 = null;
            Set set = null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                condicao5 = (Condicao)iterator.next();
                set = (Set)this.particoes.get(condicao5);
                if (condicao5.getQuantidade() == set.size()) continue;
                System.err.println("Error: condition does not match\nAvaliador.adicionaCondicao(...): " + I18n.getString("evaluationMessage07"));
                throw new RuntimeException(I18n.getString("evaluationMessage07"));
            }
        }
        this.consolida(condicao, hashSet2);
    }

    private void consolida(Condicao condicao, Set set) {
        Element element;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            Condicao condicao2 = (Condicao)this.elemResposta.get(element);
            if (condicao2 == null) continue;
            throw new RuntimeException(I18n.getString("evaluationMessage08"));
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            this.elemResposta.put(element, condicao);
        }
    }

    public void valida() {
        Iterator iterator = this.elemParticao.keySet().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Condicao condicao = (Condicao)this.elemParticao.get(element);
            Condicao condicao2 = (Condicao)this.elemResposta.get(element);
            if (condicao == null && condicao2 != null) {
                throw new RuntimeException(I18n.getString("evaluationMessage09"));
            }
            if (condicao2 != null || condicao == null) continue;
            throw new RuntimeException(I18n.getString("evaluationMessage10", new Object[]{element}));
        }
    }

    public void reset() {
        this.elemResposta = new Hashtable();
    }

    public int getResposta() {
        try {
            this.valida();
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    public static void deteccaoDeErroFormula(Universo universo, Estagio estagio) {
        Object object;
        int n;
        Condicao condicao = estagio.criaCondicao();
        Vector vector = universo.getElementos();
        int n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            object = (Element)vector.get(n);
            if (!condicao.evaluate((Element)object)) continue;
            ++n2;
        }
        n = condicao.getQuantidade();
        object = new Binomio();
        long l = ((Binomio)object).calcula(n2, n);
        long l2 = 0L;
        l2 = estagio.getFormula().calcula(estagio.getN(), estagio.getP());
        if (l != l2) {
            throw new RuntimeException(I18n.getString("evaluationMessage11"));
        }
    }
}

